/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.password.factory;

import com.atlassian.crowd.exception.PasswordEncoderException;
import com.atlassian.crowd.exception.PasswordEncoderNotFoundException;
import com.atlassian.crowd.password.encoder.AtlassianSHA1PasswordEncoder;
import com.atlassian.crowd.password.encoder.PasswordEncoder;
import com.atlassian.crowd.password.factory.PasswordEncoderFactory;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtlassianSHA1PasswordEncoderFactory
implements PasswordEncoderFactory {
    private final AtlassianSHA1PasswordEncoder passwordEncoder = new AtlassianSHA1PasswordEncoder();

    @Override
    public PasswordEncoder getInternalEncoder(String encoder) throws PasswordEncoderNotFoundException {
        return this.passwordEncoder;
    }

    @Override
    public PasswordEncoder getLdapEncoder(String encoder) throws PasswordEncoderNotFoundException {
        throw new PasswordEncoderNotFoundException("LDAP password encoder not configured");
    }

    @Override
    public PasswordEncoder getEncoder(String encoder) throws PasswordEncoderNotFoundException {
        return this.passwordEncoder;
    }

    @Override
    public Set<String> getSupportedInternalEncoders() {
        return Collections.singleton(this.passwordEncoder.getKey());
    }

    @Override
    public Set<String> getSupportedLdapEncoders() {
        return Collections.emptySet();
    }

    @Override
    public void addEncoder(PasswordEncoder passwordEncoder) throws PasswordEncoderException {
    }

    @Override
    public void removeEncoder(PasswordEncoder passwordEncoder) {
    }
}

