/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.password.encoder;

import com.atlassian.crowd.exception.PasswordEncoderException;
import com.atlassian.crowd.password.encoder.AtlassianSHA1PasswordEncoder;
import com.atlassian.crowd.password.encoder.InternalPasswordEncoder;
import com.atlassian.crowd.password.encoder.PasswordEncoder;
import com.atlassian.crowd.password.encoder.UpgradeablePasswordEncoder;
import com.atlassian.security.password.DefaultPasswordEncoder;

public class AtlassianSecurityPasswordEncoder
implements InternalPasswordEncoder,
UpgradeablePasswordEncoder {
    private final com.atlassian.security.password.PasswordEncoder defaultPasswordEncoder;
    private final PasswordEncoder oldPasswordEncoder;

    public AtlassianSecurityPasswordEncoder() {
        this.defaultPasswordEncoder = DefaultPasswordEncoder.getDefaultInstance();
        this.oldPasswordEncoder = new AtlassianSHA1PasswordEncoder();
    }

    AtlassianSecurityPasswordEncoder(com.atlassian.security.password.PasswordEncoder defaultPasswordEncoder, PasswordEncoder oldPasswordEncoder) {
        this.defaultPasswordEncoder = defaultPasswordEncoder;
        this.oldPasswordEncoder = oldPasswordEncoder;
    }

    public String encodePassword(String rawPass, Object salt) throws PasswordEncoderException {
        try {
            return this.defaultPasswordEncoder.encodePassword(rawPass);
        }
        catch (IllegalArgumentException e) {
            throw new PasswordEncoderException("Password could not be encoded.", e);
        }
    }

    public boolean isPasswordValid(String encPass, String rawPass, Object salt) {
        if (this.defaultPasswordEncoder.canDecodePassword(encPass)) {
            try {
                return this.defaultPasswordEncoder.isValidPassword(rawPass, encPass);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return this.oldPasswordEncoder.isPasswordValid(encPass, rawPass, salt);
    }

    public boolean isUpgradeRequired(String encPass) {
        return !this.defaultPasswordEncoder.canDecodePassword(encPass);
    }

    public String getKey() {
        return "atlassian-security";
    }
}

