/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.config_browser;

import com.opensymphony.webwork.config_browser.ListValidatorsAction;
import com.opensymphony.xwork.util.OgnlUtil;
import com.opensymphony.xwork.validator.Validator;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ShowValidatorAction
extends ListValidatorsAction {
    private static Log log = LogFactory.getLog((Class)ShowValidatorAction.class);
    Set properties = Collections.EMPTY_SET;
    int selected = 0;

    public int getSelected() {
        return this.selected;
    }

    public void setSelected(int selected) {
        this.selected = selected;
    }

    public Set getProperties() {
        return this.properties;
    }

    public Validator getSelectedValidator() {
        return (Validator)this.validators.get(this.selected);
    }

    public String execute() throws Exception {
        this.loadValidators();
        Validator validator = this.getSelectedValidator();
        this.properties = new TreeSet();
        try {
            Map context = Ognl.createDefaultContext((Object)validator);
            BeanInfo beanInfoFrom = null;
            try {
                beanInfoFrom = Introspector.getBeanInfo(validator.getClass(), Object.class);
            }
            catch (IntrospectionException e) {
                log.error((Object)"An error occurred", (Throwable)e);
                this.addActionError("An error occurred while introspecting a validator of type " + validator.getClass().getName());
                return "error";
            }
            PropertyDescriptor[] pds = beanInfoFrom.getPropertyDescriptors();
            for (int i = 0; i < pds.length; ++i) {
                PropertyDescriptor pd = pds[i];
                String name = pd.getName();
                Object value = null;
                if (pd.getReadMethod() == null) {
                    value = "No read method for property";
                } else {
                    try {
                        Object expr = OgnlUtil.compile((String)name);
                        value = Ognl.getValue((Object)expr, (Map)context, (Object)validator);
                    }
                    catch (OgnlException e) {
                        this.addActionError("Caught OGNL exception while getting property value for '" + name + "' on validator of type " + validator.getClass().getName());
                    }
                }
                this.properties.add(new PropertyInfo(name, pd.getPropertyType(), value));
            }
        }
        catch (Exception e) {
            log.warn((Object)"Unable to retrieve properties.", (Throwable)e);
            this.addActionError("Unable to retrieve properties: " + e.toString());
        }
        if (this.hasErrors()) {
            return "error";
        }
        return "success";
    }

    public static class PropertyInfo
    implements Comparable {
        private String name;
        private Class type;
        private Object value;

        public PropertyInfo(String name, Class type, Object value) {
            if (name == null) {
                throw new IllegalArgumentException("Name must not be null");
            }
            if (type == null) {
                throw new IllegalArgumentException("Type must not be null");
            }
            this.name = name;
            this.type = type;
            this.value = value;
        }

        public Class getType() {
            return this.type;
        }

        public void setType(Class type) {
            this.type = type;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PropertyInfo)) {
                return false;
            }
            PropertyInfo propertyInfo = (PropertyInfo)o;
            if (!this.name.equals(propertyInfo.name)) {
                return false;
            }
            if (!this.type.equals(propertyInfo.type)) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(propertyInfo.value) : propertyInfo.value != null);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 29 * result + this.type.hashCode();
            result = 29 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public int compareTo(Object o) {
            PropertyInfo other = (PropertyInfo)o;
            return this.name.compareTo(other.name);
        }
    }
}

