/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.container.impl;

import com.atlassian.plugin.osgi.container.OsgiContainerException;
import com.atlassian.plugin.osgi.container.OsgiPersistentCache;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOsgiPersistentCache
implements OsgiPersistentCache {
    private final File osgiBundleCache;
    private final File frameworkBundleCache;
    private final File transformedPluginCache;
    private final Logger log = LoggerFactory.getLogger(DefaultOsgiPersistentCache.class);

    public DefaultOsgiPersistentCache(File baseDir) {
        Validate.notNull((Object)baseDir, (String)"The base directory for OSGi caches cannot be null");
        Validate.isTrue((boolean)baseDir.exists(), (String)"The base directory for OSGi persistent caches should exist");
        this.osgiBundleCache = new File(baseDir, "felix");
        this.frameworkBundleCache = new File(baseDir, "framework-bundles");
        this.transformedPluginCache = new File(baseDir, "transformed-plugins");
        this.validate(null);
    }

    @Deprecated
    public DefaultOsgiPersistentCache(File baseDir, String applicationVersion) {
        this(baseDir);
    }

    public File getFrameworkBundleCache() {
        return this.frameworkBundleCache;
    }

    public File getOsgiBundleCache() {
        return this.osgiBundleCache;
    }

    public File getTransformedPluginCache() {
        return this.transformedPluginCache;
    }

    public void clear() throws OsgiContainerException {
        try {
            FileUtils.cleanDirectory((File)this.frameworkBundleCache);
            FileUtils.cleanDirectory((File)this.osgiBundleCache);
            FileUtils.cleanDirectory((File)this.transformedPluginCache);
        }
        catch (IOException e) {
            throw new OsgiContainerException("Unable to clear OSGi caches", e);
        }
    }

    public void validate(String cacheValidationKey) {
        this.ensureDirectoryExists(this.frameworkBundleCache);
        this.ensureDirectoryExists(this.osgiBundleCache);
        this.ensureDirectoryExists(this.transformedPluginCache);
        try {
            FileUtils.cleanDirectory((File)this.osgiBundleCache);
        }
        catch (IOException e) {
            throw new OsgiContainerException("Unable to clean the cache directory: " + this.osgiBundleCache, e);
        }
        if (cacheValidationKey != null) {
            File versionFile = new File(this.transformedPluginCache, "cache.key");
            if (versionFile.exists()) {
                String oldVersion = null;
                try {
                    oldVersion = FileUtils.readFileToString((File)versionFile);
                }
                catch (IOException e) {
                    this.log.debug("Unable to read cache key file", (Throwable)e);
                }
                if (!cacheValidationKey.equals(oldVersion)) {
                    this.log.info("Application upgrade detected, clearing OSGi cache directories");
                    this.clear();
                } else {
                    return;
                }
            }
            try {
                FileUtils.writeStringToFile((File)versionFile, (String)cacheValidationKey);
            }
            catch (IOException e) {
                this.log.warn("Unable to write cache key file, so will be unable to detect upgrades", (Throwable)e);
            }
        }
    }

    private void ensureDirectoryExists(File dir) {
        if (dir.exists() && !dir.isDirectory()) {
            throw new IllegalArgumentException("'" + dir + "' is not a directory");
        }
        if (!dir.exists() && !dir.mkdir()) {
            throw new IllegalArgumentException("Directory '" + dir + "' cannot be created");
        }
    }
}

