/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import com.atlassian.util.concurrent.CopyOnWriteMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import ognl.ASTChain;
import ognl.ASTConst;
import ognl.ArrayElementsAccessor;
import ognl.ArrayPropertyAccessor;
import ognl.ClassCacheInspector;
import ognl.ClassResolver;
import ognl.CollectionElementsAccessor;
import ognl.ElementsAccessor;
import ognl.EnumerationElementsAccessor;
import ognl.EnumerationPropertyAccessor;
import ognl.EvaluationPool;
import ognl.IteratorElementsAccessor;
import ognl.IteratorPropertyAccessor;
import ognl.ListPropertyAccessor;
import ognl.MapElementsAccessor;
import ognl.MapPropertyAccessor;
import ognl.MethodAccessor;
import ognl.MethodFailedException;
import ognl.NoSuchPropertyException;
import ognl.Node;
import ognl.NullHandler;
import ognl.NumberElementsAccessor;
import ognl.ObjectArrayPool;
import ognl.ObjectElementsAccessor;
import ognl.ObjectIndexedPropertyDescriptor;
import ognl.ObjectMethodAccessor;
import ognl.ObjectNullHandler;
import ognl.ObjectPropertyAccessor;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlInvokePermission;
import ognl.OgnlOps;
import ognl.PropertyAccessor;
import ognl.SetPropertyAccessor;
import ognl.TypeConverter;
import ognl.enhance.ExpressionCompiler;
import ognl.enhance.OgnlExpressionCompiler;
import ognl.internal.ClassCache;
import ognl.internal.ConcurrentClassCache;
import ognl.internal.IntrospectorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OgnlRuntime {
    public static final Object NotFound = new Object();
    public static final List<?> NotFoundList = Collections.unmodifiableList(Collections.emptyList());
    public static final Map<?, ?> NotFoundMap = Collections.unmodifiableMap(Collections.emptyMap());
    public static final Object[] NoArguments = new Object[0];
    public static final Class<?>[] NoArgumentTypes = new Class[0];
    public static final Object NoConversionPossible = "ognl.NoConversionPossible";
    public static int INDEXED_PROPERTY_NONE = 0;
    public static int INDEXED_PROPERTY_INT = 1;
    public static int INDEXED_PROPERTY_OBJECT = 2;
    public static final String NULL_STRING = "" + null;
    private static final String SET_PREFIX = "set";
    private static final String GET_PREFIX = "get";
    private static final String IS_PREFIX = "is";
    private static final Map<Integer, String> HEX_PADDING = CopyOnWriteMap.builder().newHashMap();
    private static final int HEX_LENGTH = 8;
    private static final String NULL_OBJECT_STRING = "<null>";
    private static boolean _jdk15 = false;
    private static boolean _jdkChecked = false;
    private static final SimpleCache<MethodAccessor> _methodAccessors = new SimpleCache("method accessor");
    private static final SimpleCache<PropertyAccessor> _propertyAccessors = new SimpleCache("property accessor");
    private static final SimpleCache<ElementsAccessor> _elementsAccessors = new SimpleCache("elements accessor");
    private static final SimpleCache<NullHandler> _nullHandlers = new SimpleCache("null handler");
    static final ClassCache<Map<String, PropertyDescriptor>> _propertyDescriptorCache = new ConcurrentClassCache<Map<String, PropertyDescriptor>>();
    private static final ClassCache<PropertyDescriptor[]> _propertyDescriptorArrayCache = new ConcurrentClassCache<PropertyDescriptor[]>();
    private static final ClassCache<List<Constructor<?>>> _constructorCache = new ConcurrentClassCache();
    private static final ClassCache<Map<String, List<Method>>> _staticMethodCache = new ConcurrentClassCache<Map<String, List<Method>>>();
    private static final ClassCache<Map<String, List<Method>>> _instanceMethodCache = new ConcurrentClassCache<Map<String, List<Method>>>();
    private static final ClassCache<Map<String, Object>> _fieldCache = new ConcurrentClassCache<Map<String, Object>>();
    private static final ClassCache<ConcurrentMap<String, List<Method>>>[] _declaredMethods = new ClassCache[]{new ConcurrentClassCache(), new ConcurrentClassCache()};
    private static final Map<String, Class<?>> _primitiveTypes;
    private static final Map<Class<?>, Object> _primitiveDefaults;
    private static final ConcurrentMap<Method, Class<?>[]> _genericMethodParameterTypesCache;
    private static final ConcurrentMap<Constructor<?>, Class<?>[]> _ctorParameterTypesCache;
    private static SecurityManager _securityManager;
    private static final EvaluationPool _evaluationPool;
    private static final ObjectArrayPool _objectArrayPool;
    private static OgnlExpressionCompiler _compiler;
    private static Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_CLASSES;
    private static final Map<Class<?>, String> NUMERIC_CASTS;
    private static final Map<Class<?>, String> NUMERIC_VALUES;
    private static final Map<Class<?>, String> NUMERIC_LITERALS;
    private static final Map<Class<?>, Object> NUMERIC_DEFAULTS;

    private static final <T> List<T> notFoundList() {
        return NotFoundList;
    }

    public static void clearCache() {
        _ctorParameterTypesCache.clear();
        _propertyDescriptorCache.clear();
        _constructorCache.clear();
        _staticMethodCache.clear();
        _instanceMethodCache.clear();
        _fieldCache.clear();
        _declaredMethods[0].clear();
        _declaredMethods[1].clear();
    }

    public static boolean isJdk15() {
        if (_jdkChecked) {
            return _jdk15;
        }
        try {
            Class.forName("java.lang.annotation.Annotation");
            _jdk15 = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        _jdkChecked = true;
        return _jdk15;
    }

    public static String getNumericValueGetter(Class<?> type) {
        return NUMERIC_VALUES.get(type);
    }

    public static Class<?> getPrimitiveWrapperClass(Class<?> primitiveClass) {
        return PRIMITIVE_WRAPPER_CLASSES.get(primitiveClass);
    }

    public static String getNumericCast(Class<?> type) {
        return NUMERIC_CASTS.get(type);
    }

    public static String getNumericLiteral(Class<?> type) {
        return NUMERIC_LITERALS.get(type);
    }

    public static void setCompiler(OgnlExpressionCompiler compiler) {
        _compiler = compiler;
    }

    public static OgnlExpressionCompiler getCompiler() {
        return _compiler;
    }

    public static void compileExpression(OgnlContext context, Node expression, Object root) throws Exception {
        _compiler.compileExpression(context, expression, root);
    }

    public static Class<?> getTargetClass(Object o) {
        return o == null ? null : (o instanceof Class ? (Class<?>)o : o.getClass());
    }

    public static String getBaseName(Object o) {
        return o == null ? null : OgnlRuntime.getClassBaseName(o.getClass());
    }

    public static String getClassBaseName(Class<?> c) {
        String s = c.getName();
        return s.substring(s.lastIndexOf(46) + 1);
    }

    public static String getClassName(Object o, boolean fullyQualified) {
        if (!(o instanceof Class)) {
            o = o.getClass();
        }
        return OgnlRuntime.getClassName(o, fullyQualified);
    }

    public static String getClassName(Class<?> c, boolean fullyQualified) {
        return fullyQualified ? c.getName() : OgnlRuntime.getClassBaseName(c);
    }

    public static String getPackageName(Object o) {
        return o == null ? null : OgnlRuntime.getClassPackageName(o.getClass());
    }

    public static String getClassPackageName(Class<?> c) {
        String s = c.getName();
        int i = s.lastIndexOf(46);
        return i < 0 ? null : s.substring(0, i);
    }

    public static String getPointerString(int num) {
        StringBuilder result = new StringBuilder();
        String hex = Integer.toHexString(num);
        Integer l = hex.length();
        String pad = HEX_PADDING.get(l);
        if (pad == null) {
            StringBuilder pb = new StringBuilder();
            for (int i = hex.length(); i < 8; ++i) {
                pb.append('0');
            }
            pad = pb.toString();
            HEX_PADDING.put(l, pad);
        }
        result.append(pad);
        result.append(hex);
        return result.toString();
    }

    public static String getPointerString(Object o) {
        return OgnlRuntime.getPointerString(o == null ? 0 : System.identityHashCode(o));
    }

    public static String getUniqueDescriptor(Object object, boolean fullyQualified) {
        StringBuffer result = new StringBuffer();
        if (object != null) {
            if (object instanceof Proxy) {
                Class<?> interfaceClass = object.getClass().getInterfaces()[0];
                result.append(OgnlRuntime.getClassName(interfaceClass, fullyQualified));
                result.append('^');
                object = Proxy.getInvocationHandler(object);
            }
            result.append(OgnlRuntime.getClassName(object, fullyQualified));
            result.append('@');
            result.append(OgnlRuntime.getPointerString(object));
        } else {
            result.append(NULL_OBJECT_STRING);
        }
        return new String(result);
    }

    public static String getUniqueDescriptor(Object object) {
        return OgnlRuntime.getUniqueDescriptor(object, false);
    }

    @Deprecated
    public static Object[] toArray(List<?> list) {
        Object[] result;
        int size = list.size();
        if (size == 0) {
            result = NoArguments;
        } else {
            result = new Object[list.size()];
            for (int i = 0; i < size; ++i) {
                result[i] = list.get(i);
            }
        }
        return result;
    }

    public static Class<?>[] getParameterTypes(Method m) {
        return m.getParameterTypes();
    }

    public static Class<?>[] findParameterTypes(Class<?> type, Method m) {
        Class[] types;
        if (type == null) {
            return OgnlRuntime.getParameterTypes(m);
        }
        if (!OgnlRuntime.isJdk15() || type.getGenericSuperclass() == null || !ParameterizedType.class.isInstance(type.getGenericSuperclass()) || m.getDeclaringClass().getTypeParameters() == null) {
            return OgnlRuntime.getParameterTypes(m);
        }
        while ((types = (Class[])_genericMethodParameterTypesCache.get(m)) == null) {
            ParameterizedType param = (ParameterizedType)type.getGenericSuperclass();
            Type[] genTypes = m.getGenericParameterTypes();
            TypeVariable<Class<?>>[] declaredTypes = m.getDeclaringClass().getTypeParameters();
            types = new Class[genTypes.length];
            for (int i = 0; i < genTypes.length; ++i) {
                TypeVariable paramType = null;
                if (TypeVariable.class.isInstance(genTypes[i])) {
                    paramType = (TypeVariable)genTypes[i];
                } else if (GenericArrayType.class.isInstance(genTypes[i])) {
                    paramType = (TypeVariable)((GenericArrayType)genTypes[i]).getGenericComponentType();
                } else if (Class.class.isInstance(genTypes[i])) {
                    types[i] = (Class)genTypes[i];
                    continue;
                }
                Class<?> resolved = OgnlRuntime.resolveType(param, paramType, declaredTypes);
                if (resolved != null) {
                    if (GenericArrayType.class.isInstance(genTypes[i])) {
                        resolved = Array.newInstance(resolved, 0).getClass();
                    }
                    types[i] = resolved;
                    continue;
                }
                types[i] = m.getParameterTypes()[i];
            }
            _genericMethodParameterTypesCache.putIfAbsent(m, types);
        }
        return types;
    }

    static Class<?> resolveType(ParameterizedType param, TypeVariable<?> var, TypeVariable<?>[] declaredTypes) {
        if (param.getActualTypeArguments().length < 1) {
            return null;
        }
        for (int i = 0; i < declaredTypes.length; ++i) {
            if (TypeVariable.class.isInstance(param.getActualTypeArguments()[i]) || !declaredTypes[i].getName().equals(var.getName())) continue;
            return (Class)param.getActualTypeArguments()[i];
        }
        return null;
    }

    static Class<?> findType(Type[] types, Class<?> clazz) {
        for (Type type : types) {
            if (!Class.class.isInstance(type) || !clazz.isAssignableFrom((Class)type)) continue;
            return (Class)type;
        }
        return null;
    }

    public static Class<?>[] getParameterTypes(Constructor<?> c) {
        Class[] result;
        while ((result = (Class[])_ctorParameterTypesCache.get(c)) == null) {
            result = c.getParameterTypes();
            _ctorParameterTypesCache.put(c, result);
        }
        return result;
    }

    public static SecurityManager getSecurityManager() {
        return _securityManager;
    }

    public static void setSecurityManager(SecurityManager value) {
        _securityManager = value;
    }

    @Deprecated
    public static Permission getPermission(Method method) {
        return new OgnlInvokePermission("invoke." + method.getDeclaringClass().getName() + "." + method.getName());
    }

    public static Object invokeMethod(Object target, Method method, Object[] argsArray) throws InvocationTargetException, IllegalAccessException {
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        return method.invoke(target, argsArray);
    }

    public static final Class<?> getArgClass(Object arg) {
        if (arg == null) {
            return null;
        }
        Class<?> c = arg.getClass();
        if (c == Boolean.class) {
            return Boolean.TYPE;
        }
        if (c.getSuperclass() == Number.class) {
            if (c == Integer.class) {
                return Integer.TYPE;
            }
            if (c == Double.class) {
                return Double.TYPE;
            }
            if (c == Byte.class) {
                return Byte.TYPE;
            }
            if (c == Long.class) {
                return Long.TYPE;
            }
            if (c == Float.class) {
                return Float.TYPE;
            }
            if (c == Short.class) {
                return Short.TYPE;
            }
        } else if (c == Character.class) {
            return Character.TYPE;
        }
        return c;
    }

    public static final boolean isTypeCompatible(Object object, Class<?> c) {
        boolean result = true;
        if (object != null) {
            if (c.isPrimitive()) {
                if (OgnlRuntime.getArgClass(object) != c) {
                    result = false;
                }
            } else if (!c.isInstance(object)) {
                result = false;
            }
        }
        return result;
    }

    public static boolean areArgsCompatible(Object[] args, Class<?>[] classes) {
        return OgnlRuntime.areArgsCompatible(args, classes, null);
    }

    public static boolean areArgsCompatible(Object[] args, Class<?>[] classes, Method m) {
        boolean varArgs;
        boolean result = true;
        boolean bl = varArgs = m != null && OgnlRuntime.isJdk15() && m.isVarArgs();
        if (args.length != classes.length && !varArgs) {
            result = false;
        } else if (varArgs) {
            int count = args.length;
            for (int index = 0; result && index < count && index < classes.length; ++index) {
                result = OgnlRuntime.isTypeCompatible(args[index], classes[index]);
                if (result || !classes[index].isArray()) continue;
                result = OgnlRuntime.isTypeCompatible(args[index], classes[index].getComponentType());
            }
        } else {
            int count = args.length;
            for (int index = 0; result && index < count; ++index) {
                result = OgnlRuntime.isTypeCompatible(args[index], classes[index]);
            }
        }
        return result;
    }

    public static final boolean isMoreSpecific(Class<?>[] classes1, Class<?>[] classes2) {
        int count = classes1.length;
        for (int index = 0; index < count; ++index) {
            Class<?> c1 = classes1[index];
            Class<?> c2 = classes2[index];
            if (c1 == c2) continue;
            if (c1.isPrimitive()) {
                return true;
            }
            if (c1.isAssignableFrom(c2)) {
                return false;
            }
            if (!c2.isAssignableFrom(c1)) continue;
            return true;
        }
        return false;
    }

    public static String getModifierString(int modifiers) {
        String result = Modifier.isPublic(modifiers) ? "public" : (Modifier.isProtected(modifiers) ? "protected" : (Modifier.isPrivate(modifiers) ? "private" : ""));
        if (Modifier.isStatic(modifiers)) {
            result = "static " + result;
        }
        if (Modifier.isFinal(modifiers)) {
            result = "final " + result;
        }
        if (Modifier.isNative(modifiers)) {
            result = "native " + result;
        }
        if (Modifier.isSynchronized(modifiers)) {
            result = "synchronized " + result;
        }
        if (Modifier.isTransient(modifiers)) {
            result = "transient " + result;
        }
        return result;
    }

    public static Class<?> classForName(OgnlContext context, String className) throws ClassNotFoundException {
        Class result = _primitiveTypes.get(className);
        if (result == null) {
            ClassResolver resolver;
            if (context == null || (resolver = context.getClassResolver()) == null) {
                resolver = OgnlContext.DEFAULT_CLASS_RESOLVER;
            }
            result = resolver.classForName(className, context);
        }
        if (result == null) {
            throw new ClassNotFoundException("Unable to resolve class: " + className);
        }
        return result;
    }

    public static boolean isInstance(OgnlContext context, Object value, String className) throws OgnlException {
        try {
            Class<?> c = OgnlRuntime.classForName(context, className);
            return c.isInstance(value);
        }
        catch (ClassNotFoundException e) {
            throw new OgnlException("No such class: " + className, e);
        }
    }

    public static Object getPrimitiveDefaultValue(Class<?> forClass) {
        return _primitiveDefaults.get(forClass);
    }

    public static Object getNumericDefaultValue(Class<?> forClass) {
        return NUMERIC_DEFAULTS.get(forClass);
    }

    public static Object getConvertedType(OgnlContext context, Object target, Member member, String propertyName, Object value, Class<?> type) {
        return context.getTypeConverter().convertValue(context, target, member, propertyName, value, type);
    }

    public static boolean getConvertedTypes(OgnlContext context, Object target, Member member, String propertyName, Class<?>[] parameterTypes, Object[] args, Object[] newArgs) {
        boolean result = false;
        if (parameterTypes.length == args.length) {
            result = true;
            int ilast = parameterTypes.length - 1;
            for (int i = 0; result && i <= ilast; ++i) {
                Object arg = args[i];
                Class<?> type = parameterTypes[i];
                if (OgnlRuntime.isTypeCompatible(arg, type)) {
                    newArgs[i] = arg;
                    continue;
                }
                Object v = OgnlRuntime.getConvertedType(context, target, member, propertyName, arg, type);
                if (v == NoConversionPossible) {
                    result = false;
                    continue;
                }
                newArgs[i] = v;
            }
        }
        return result;
    }

    public static Method getConvertedMethodAndArgs(OgnlContext context, Object target, String propertyName, List<Method> methods, Object[] args, Object[] newArgs) {
        TypeConverter converter = context.getTypeConverter();
        if (converter != null && methods != null) {
            for (Method m : methods) {
                Class<?>[] parameterTypes;
                if (!OgnlRuntime.getConvertedTypes(context, target, m, propertyName, parameterTypes = OgnlRuntime.findParameterTypes(target != null ? target.getClass() : null, m), args, newArgs) || m == null) continue;
                return m;
            }
        }
        return null;
    }

    public static Constructor<?> getConvertedConstructorAndArgs(OgnlContext context, Object target, List<Constructor<?>> constructors, Object[] args, Object[] newArgs) {
        Constructor<?> result = null;
        TypeConverter converter = context.getTypeConverter();
        if (converter != null && constructors != null) {
            int icount = constructors.size();
            for (int i = 0; result == null && i < icount; ++i) {
                Class<?>[] parameterTypes;
                Constructor<?> ctor = constructors.get(i);
                if (!OgnlRuntime.getConvertedTypes(context, target, ctor, null, parameterTypes = OgnlRuntime.getParameterTypes(ctor), args, newArgs)) continue;
                result = ctor;
            }
        }
        return result;
    }

    public static Method getAppropriateMethod(OgnlContext context, Object source, Object target, String propertyName, List<Method> methods, Object[] args, Object[] actualArgs) {
        Method result = null;
        Class<?>[] resultParameterTypes = null;
        if (methods != null) {
            for (Method m : methods) {
                Class<?>[] mParameterTypes;
                Class typeClass;
                Class clazz = typeClass = target != null ? target.getClass() : null;
                if (typeClass == null && source != null && Class.class.isInstance(source)) {
                    typeClass = (Class)source;
                }
                if (!OgnlRuntime.areArgsCompatible(args, mParameterTypes = OgnlRuntime.findParameterTypes(typeClass, m), m) || result != null && !OgnlRuntime.isMoreSpecific(mParameterTypes, resultParameterTypes)) continue;
                result = m;
                resultParameterTypes = mParameterTypes;
                System.arraycopy(args, 0, actualArgs, 0, args.length);
                for (int j = 0; j < mParameterTypes.length; ++j) {
                    Class<?> type = mParameterTypes[j];
                    if (!type.isPrimitive() || actualArgs[j] != null) continue;
                    actualArgs[j] = OgnlRuntime.getConvertedType(context, source, result, propertyName, null, type);
                }
            }
        }
        if (result == null) {
            result = OgnlRuntime.getConvertedMethodAndArgs(context, target, propertyName, methods, args, actualArgs);
        }
        return result;
    }

    public static Object callAppropriateMethod(OgnlContext context, Object source, Object target, String methodName, String propertyName, List<Method> methods, Object[] args) throws MethodFailedException {
        Throwable reason = null;
        try {
            Object[] actualArgs = new Object[args.length];
            Method method = OgnlRuntime.getAppropriateMethod(context, source, target, propertyName, methods, args, actualArgs);
            if (method == null || !OgnlRuntime.isMethodAccessible(context, source, method, propertyName)) {
                StringBuffer buffer = new StringBuffer();
                String className = "";
                if (target != null) {
                    className = target.getClass().getName() + ".";
                }
                int ilast = args.length - 1;
                for (int i = 0; i <= ilast; ++i) {
                    Object arg = args[i];
                    buffer.append(arg == null ? NULL_STRING : arg.getClass().getName());
                    if (i >= ilast) continue;
                    buffer.append(", ");
                }
                throw new NoSuchMethodException(className + methodName + "(" + buffer + ")");
            }
            Object[] convertedArgs = actualArgs;
            if (OgnlRuntime.isJdk15() && method.isVarArgs()) {
                Class<?>[] parmTypes = method.getParameterTypes();
                for (int i = 0; i < parmTypes.length; ++i) {
                    Object[] varArgs;
                    if (!parmTypes[i].isArray()) continue;
                    convertedArgs = new Object[i + 1];
                    System.arraycopy(actualArgs, 0, convertedArgs, 0, convertedArgs.length);
                    if (actualArgs.length > i) {
                        ArrayList<Object> varArgsList = new ArrayList<Object>(actualArgs.length);
                        for (int j = i; j < actualArgs.length; ++j) {
                            if (actualArgs[j] == null) continue;
                            varArgsList.add(actualArgs[j]);
                        }
                        varArgs = varArgsList.toArray();
                    } else {
                        varArgs = new Object[]{};
                    }
                    convertedArgs[i] = varArgs;
                    break;
                }
            }
            return OgnlRuntime.invokeMethod(target, method, convertedArgs);
        }
        catch (NoSuchMethodException e) {
            reason = e;
        }
        catch (IllegalAccessException e) {
            reason = e;
        }
        catch (InvocationTargetException e) {
            reason = e.getTargetException();
        }
        throw new MethodFailedException(source, methodName, reason);
    }

    public static Object callStaticMethod(OgnlContext context, String className, String methodName, Object[] args) throws OgnlException {
        try {
            Class<?> targetClass = OgnlRuntime.classForName(context, className);
            if (targetClass == null) {
                throw new ClassNotFoundException("Unable to resolve class with name " + className);
            }
            MethodAccessor ma = OgnlRuntime.getMethodAccessor(targetClass);
            return ma.callStaticMethod(context, targetClass, methodName, args);
        }
        catch (ClassNotFoundException ex) {
            throw new MethodFailedException(className, methodName, ex);
        }
    }

    @Deprecated
    public static Object callMethod(OgnlContext context, Object target, String methodName, String propertyName, Object[] args) throws OgnlException {
        return OgnlRuntime.callMethod(context, target, methodName == null ? propertyName : methodName, args);
    }

    public static Object callMethod(OgnlContext context, Object target, String methodName, Object[] args) throws OgnlException {
        if (target == null) {
            throw new NullPointerException("target is null for method " + methodName);
        }
        return OgnlRuntime.getMethodAccessor(target.getClass()).callMethod(context, target, methodName, args);
    }

    public static Object callConstructor(OgnlContext context, String className, Object[] args) throws OgnlException {
        Throwable reason = null;
        try {
            Object[] actualArgs = args;
            Constructor<?> ctor = null;
            Class<?>[] ctorParameterTypes = null;
            Class<?> target = OgnlRuntime.classForName(context, className);
            List<Constructor<?>> constructors = OgnlRuntime.getConstructors(target);
            int icount = constructors.size();
            for (int i = 0; i < icount; ++i) {
                Constructor<?> c = constructors.get(i);
                Class<?>[] cParameterTypes = OgnlRuntime.getParameterTypes(c);
                if (!OgnlRuntime.areArgsCompatible(args, cParameterTypes) || ctor != null && !OgnlRuntime.isMoreSpecific(cParameterTypes, ctorParameterTypes)) continue;
                ctor = c;
                ctorParameterTypes = cParameterTypes;
            }
            if (ctor == null && (ctor = OgnlRuntime.getConvertedConstructorAndArgs(context, target, constructors, args, actualArgs = new Object[args.length])) == null) {
                throw new NoSuchMethodException();
            }
            if (!context.getMemberAccess().isAccessible(context, target, ctor, null)) {
                throw new IllegalAccessException("access denied to " + target.getName() + "()");
            }
            return ctor.newInstance(actualArgs);
        }
        catch (ClassNotFoundException e) {
            reason = e;
        }
        catch (NoSuchMethodException e) {
            reason = e;
        }
        catch (IllegalAccessException e) {
            reason = e;
        }
        catch (InvocationTargetException e) {
            reason = e.getTargetException();
        }
        catch (InstantiationException e) {
            reason = e;
        }
        throw new MethodFailedException(className, "new", reason);
    }

    public static final Object getMethodValue(OgnlContext context, Object target, String propertyName) throws OgnlException, IllegalAccessException, NoSuchMethodException, IntrospectionException {
        return OgnlRuntime.getMethodValue(context, target, propertyName, false);
    }

    public static final Object getMethodValue(OgnlContext context, Object target, String propertyName, boolean checkAccessAndExistence) throws OgnlException, IllegalAccessException, NoSuchMethodException, IntrospectionException {
        Object result = null;
        Method m = OgnlRuntime.getGetMethod(context, target == null ? null : target.getClass(), propertyName);
        if (m == null) {
            m = OgnlRuntime.getReadMethod(target == null ? null : target.getClass(), propertyName, 0);
        }
        if (checkAccessAndExistence && (m == null || !context.getMemberAccess().isAccessible(context, target, m, propertyName))) {
            result = NotFound;
        }
        if (result == null) {
            if (m != null) {
                try {
                    result = OgnlRuntime.invokeMethod(target, m, NoArguments);
                }
                catch (InvocationTargetException ex) {
                    throw new OgnlException(propertyName, ex.getTargetException());
                }
            } else {
                throw new NoSuchMethodException(propertyName);
            }
        }
        return result;
    }

    public static boolean setMethodValue(OgnlContext context, Object target, String propertyName, Object value) throws OgnlException, IllegalAccessException, NoSuchMethodException, IntrospectionException {
        return OgnlRuntime.setMethodValue(context, target, propertyName, value, false);
    }

    public static boolean setMethodValue(OgnlContext context, Object target, String propertyName, Object value, boolean checkAccessAndExistence) throws OgnlException, IllegalAccessException, NoSuchMethodException, IntrospectionException {
        boolean result = true;
        Method m = OgnlRuntime.getSetMethod(context, target == null ? null : target.getClass(), propertyName);
        if (checkAccessAndExistence && (m == null || !context.getMemberAccess().isAccessible(context, target, m, propertyName))) {
            result = false;
        }
        if (result) {
            if (m != null) {
                Object[] args = new Object[]{value};
                OgnlRuntime.callAppropriateMethod(context, target, target, m.getName(), propertyName, Collections.nCopies(1, m), args);
            } else {
                result = false;
            }
        }
        return result;
    }

    public static List<Constructor<?>> getConstructors(Class<?> targetClass) {
        ImmutableList result = _constructorCache.get(targetClass);
        if (result == null) {
            result = ImmutableList.of((Object[])targetClass.getConstructors());
            _constructorCache.put(targetClass, (List<Constructor<?>>)result);
        }
        return result;
    }

    public static Map<String, List<Method>> getMethods(Class<?> targetClass, boolean staticMethods) {
        ClassCache<Map<String, List<Method>>> cache = staticMethods ? _staticMethodCache : _instanceMethodCache;
        ImmutableMap result = cache.get(targetClass);
        if (result == null) {
            HashMap<String, ArrayList<Method>> builder = new HashMap<String, ArrayList<Method>>();
            for (Class<?> c = targetClass; c != null; c = c.getSuperclass()) {
                Method[] ma = c.getDeclaredMethods();
                int icount = ma.length;
                for (int i = 0; i < icount; ++i) {
                    if (!OgnlRuntime.isMethodCallable(ma[i]) || Modifier.isStatic(ma[i].getModifiers()) != staticMethods) continue;
                    ArrayList<Method> ml = (ArrayList<Method>)builder.get(ma[i].getName());
                    if (ml == null) {
                        ml = new ArrayList<Method>();
                        builder.put(ma[i].getName(), ml);
                    }
                    ml.add(ma[i]);
                }
            }
            result = ImmutableMap.copyOf(builder);
            cache.put(targetClass, (Map<String, List<Method>>)result);
        }
        return result;
    }

    public static List<Method> getMethods(Class<?> targetClass, String name, boolean staticMethods) {
        return OgnlRuntime.getMethods(targetClass, staticMethods).get(name);
    }

    public static Map<String, Object> getFields(Class<?> targetClass) {
        CopyOnWriteMap result = _fieldCache.get(targetClass);
        if (result == null) {
            Field[] fa = targetClass.getDeclaredFields();
            HashMap<String, Field> builder = new HashMap<String, Field>(fa.length);
            for (Field element : fa) {
                builder.put(element.getName(), element);
            }
            result = CopyOnWriteMap.builder().addAll(builder).newHashMap();
            _fieldCache.put(targetClass, (Map<String, Object>)result);
        }
        return result;
    }

    public static Field getField(Class<?> inClass, String name) {
        Field result = null;
        Object o = OgnlRuntime.getFields(inClass).get(name);
        if (o == null) {
            LinkedList superclasses = new LinkedList();
            for (Class<?> sc = inClass; sc != null && (o = OgnlRuntime.getFields(sc).get(name)) != NotFound; sc = sc.getSuperclass()) {
                superclasses.add(sc);
                result = (Field)o;
                if (result != null) break;
            }
            for (Class clazz : superclasses) {
                ConcurrentMap map = (ConcurrentMap)OgnlRuntime.getFields(clazz);
                map.putIfAbsent(name, result == null ? NotFound : result);
            }
        } else if (o instanceof Field) {
            result = (Field)o;
        } else if (result == NotFound) {
            result = null;
        }
        return result;
    }

    public static Object getFieldValue(OgnlContext context, Object target, String propertyName) throws NoSuchFieldException {
        return OgnlRuntime.getFieldValue(context, target, propertyName, false);
    }

    public static Object getFieldValue(OgnlContext context, Object target, String propertyName, boolean checkAccessAndExistence) throws NoSuchFieldException {
        Object result = null;
        Field f = OgnlRuntime.getField(target == null ? null : target.getClass(), propertyName);
        if (checkAccessAndExistence && (f == null || !context.getMemberAccess().isAccessible(context, target, f, propertyName))) {
            result = NotFound;
        }
        if (result == null) {
            if (f == null) {
                throw new NoSuchFieldException(propertyName);
            }
            try {
                Object state = null;
                if (Modifier.isStatic(f.getModifiers())) {
                    throw new NoSuchFieldException(propertyName);
                }
                state = context.getMemberAccess().setup(context, target, f, propertyName);
                result = f.get(target);
                context.getMemberAccess().restore(context, target, f, propertyName, state);
            }
            catch (IllegalAccessException ex) {
                throw new NoSuchFieldException(propertyName);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setFieldValue(OgnlContext context, Object target, String propertyName, Object value) throws OgnlException {
        boolean result;
        block6: {
            result = false;
            try {
                Field f = OgnlRuntime.getField(target == null ? null : target.getClass(), propertyName);
                if (f == null || Modifier.isStatic(f.getModifiers())) break block6;
                Object state = context.getMemberAccess().setup(context, target, f, propertyName);
                try {
                    if (OgnlRuntime.isTypeCompatible(value, f.getType()) || (value = OgnlRuntime.getConvertedType(context, target, f, propertyName, value, f.getType())) != null) {
                        f.set(target, value);
                        result = true;
                    }
                }
                finally {
                    context.getMemberAccess().restore(context, target, f, propertyName, state);
                }
            }
            catch (IllegalAccessException ex) {
                throw new NoSuchPropertyException(target, propertyName, ex);
            }
        }
        return result;
    }

    public static boolean isFieldAccessible(OgnlContext context, Object target, Class<?> inClass, String propertyName) {
        return OgnlRuntime.isFieldAccessible(context, target, OgnlRuntime.getField(inClass, propertyName), propertyName);
    }

    public static boolean isFieldAccessible(OgnlContext context, Object target, Field field, String propertyName) {
        return context.getMemberAccess().isAccessible(context, target, field, propertyName);
    }

    public static boolean hasField(OgnlContext context, Object target, Class<?> inClass, String propertyName) {
        Field f = OgnlRuntime.getField(inClass, propertyName);
        return f != null && OgnlRuntime.isFieldAccessible(context, target, f, propertyName);
    }

    public static Object getStaticField(OgnlContext context, String className, String fieldName) throws OgnlException {
        Exception reason = null;
        try {
            Class<?> c = OgnlRuntime.classForName(context, className);
            if (c == null) {
                throw new OgnlException("Unable to find class " + className + " when resolving field name of " + fieldName);
            }
            if (fieldName.equals("class")) {
                return c;
            }
            if (OgnlRuntime.isJdk15() && c.isEnum()) {
                Class<?> enumType = c;
                Object result = Enum.valueOf(enumType, fieldName);
                return result;
            }
            Field f = c.getField(fieldName);
            if (!Modifier.isStatic(f.getModifiers())) {
                throw new OgnlException("Field " + fieldName + " of class " + className + " is not static");
            }
            return f.get(null);
        }
        catch (ClassNotFoundException e) {
            reason = e;
        }
        catch (NoSuchFieldException e) {
            reason = e;
        }
        catch (SecurityException e) {
            reason = e;
        }
        catch (IllegalAccessException e) {
            reason = e;
        }
        throw new OgnlException("Could not get static field " + fieldName + " from class " + className, reason);
    }

    public static List<Method> getDeclaredMethods(Class<?> targetClass, String propertyName, boolean findSets) {
        ArrayList<Method> result = null;
        ClassCache<ConcurrentMap<String, List<Method>>> cache = _declaredMethods[findSets ? 0 : 1];
        CopyOnWriteMap propertyCache = cache.get(targetClass);
        if (propertyCache == null || (result = (ArrayList<Method>)propertyCache.get(propertyName)) == null) {
            String baseName = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
            for (Class<?> c = targetClass; c != null; c = c.getSuperclass()) {
                Method[] methods = c.getDeclaredMethods();
                for (int i = 0; i < methods.length; ++i) {
                    int prefixLength;
                    String ms;
                    if (!OgnlRuntime.isMethodCallable(methods[i]) || !(ms = methods[i].getName()).endsWith(baseName)) continue;
                    boolean isSet = false;
                    boolean isIs = false;
                    isSet = ms.startsWith(SET_PREFIX);
                    if (!isSet && !ms.startsWith(GET_PREFIX) && !(isIs = ms.startsWith(IS_PREFIX))) continue;
                    int n = prefixLength = isIs ? 2 : 3;
                    if (isSet != findSets || baseName.length() != ms.length() - prefixLength) continue;
                    if (result == null) {
                        result = new ArrayList<Method>();
                    }
                    result.add(methods[i]);
                }
            }
            if (propertyCache == null) {
                propertyCache = CopyOnWriteMap.builder().newHashMap();
                cache.put(targetClass, (ConcurrentMap<String, List<Method>>)propertyCache);
            }
            result = result == null ? OgnlRuntime.notFoundList() : ImmutableList.copyOf((Iterable)result);
            propertyCache.putIfAbsent(propertyName, result);
        }
        return result == NotFoundList ? null : result;
    }

    static boolean isMethodCallable(Method m) {
        return (!OgnlRuntime.isJdk15() || !m.isSynthetic()) && !Modifier.isVolatile(m.getModifiers());
    }

    public static Method getGetMethod(OgnlContext context, Class<?> targetClass, String propertyName) throws IntrospectionException, OgnlException {
        Method result = null;
        List<Method> methods = OgnlRuntime.getDeclaredMethods(targetClass, propertyName, false);
        if (methods != null) {
            int icount = methods.size();
            for (int i = 0; i < icount; ++i) {
                Method m = methods.get(i);
                Class<?>[] mParameterTypes = OgnlRuntime.findParameterTypes(targetClass, m);
                if (mParameterTypes.length != 0) continue;
                result = m;
                break;
            }
        }
        return result;
    }

    public static boolean isMethodAccessible(OgnlContext context, Object target, Method method, String propertyName) {
        return method != null && context.getMemberAccess().isAccessible(context, target, method, propertyName);
    }

    public static boolean hasGetMethod(OgnlContext context, Object target, Class<?> targetClass, String propertyName) throws IntrospectionException, OgnlException {
        return OgnlRuntime.isMethodAccessible(context, target, OgnlRuntime.getGetMethod(context, targetClass, propertyName), propertyName);
    }

    public static Method getSetMethod(OgnlContext context, Class<?> targetClass, String propertyName) throws IntrospectionException, OgnlException {
        Method result = null;
        List<Method> methods = OgnlRuntime.getDeclaredMethods(targetClass, propertyName, true);
        if (methods != null) {
            int icount = methods.size();
            for (int i = 0; i < icount; ++i) {
                Method m = methods.get(i);
                Class<?>[] mParameterTypes = OgnlRuntime.findParameterTypes(targetClass, m);
                if (mParameterTypes.length != 1) continue;
                result = m;
                break;
            }
        }
        return result;
    }

    public static final boolean hasSetMethod(OgnlContext context, Object target, Class<?> targetClass, String propertyName) throws IntrospectionException, OgnlException {
        return OgnlRuntime.isMethodAccessible(context, target, OgnlRuntime.getSetMethod(context, targetClass, propertyName), propertyName);
    }

    public static final boolean hasGetProperty(OgnlContext context, Object target, Object oname) throws IntrospectionException, OgnlException {
        Class<?> targetClass = target == null ? null : target.getClass();
        String name = oname.toString();
        return OgnlRuntime.hasGetMethod(context, target, targetClass, name) || OgnlRuntime.hasField(context, target, targetClass, name);
    }

    public static final boolean hasSetProperty(OgnlContext context, Object target, Object oname) throws IntrospectionException, OgnlException {
        Class<?> targetClass = target == null ? null : target.getClass();
        String name = oname.toString();
        return OgnlRuntime.hasSetMethod(context, target, targetClass, name) || OgnlRuntime.hasField(context, target, targetClass, name);
    }

    private static final boolean indexMethodCheck(List<Method> methods) {
        boolean result = false;
        if (methods.size() > 0) {
            Method fm = methods.get(0);
            Class<?>[] fmpt = OgnlRuntime.getParameterTypes(fm);
            int fmpc = fmpt.length;
            Class<?> lastMethodClass = fm.getDeclaringClass();
            result = true;
            for (int i = 1; result && i < methods.size(); ++i) {
                Method m = methods.get(i);
                Class<?> c = m.getDeclaringClass();
                if (lastMethodClass == c) {
                    result = false;
                } else {
                    Class<?>[] mpt = OgnlRuntime.getParameterTypes(fm);
                    int mpc = fmpt.length;
                    if (fmpc != mpc) {
                        result = false;
                    }
                    for (int j = 0; j < fmpc; ++j) {
                        if (fmpt[j] == mpt[j]) continue;
                        result = false;
                        break;
                    }
                }
                lastMethodClass = c;
            }
        }
        return result;
    }

    static Map<String, PropertyDescriptor> findObjectIndexedPropertyDescriptors(Class<?> targetClass) throws OgnlException {
        Map<String, List<Method>> allMethods = OgnlRuntime.getMethods(targetClass, false);
        HashMap pairs = new HashMap();
        for (String methodName : allMethods.keySet()) {
            List<Method> pair;
            List<Method> methods = allMethods.get(methodName);
            if (!OgnlRuntime.indexMethodCheck(methods)) continue;
            boolean isGet = false;
            boolean isSet = false;
            Method m = methods.get(0);
            isSet = methodName.startsWith(SET_PREFIX);
            if (!isSet && !(isGet = methodName.startsWith(GET_PREFIX)) || methodName.length() <= 3) continue;
            String propertyName = Introspector.decapitalize(methodName.substring(3));
            Class<?>[] parameterTypes = OgnlRuntime.getParameterTypes(m);
            int parameterCount = parameterTypes.length;
            if (isGet && parameterCount == 1 && m.getReturnType() != Void.TYPE) {
                pair = (ArrayList<Method>)pairs.get(propertyName);
                if (pair == null) {
                    pair = new ArrayList<Method>();
                    pairs.put(propertyName, pair);
                }
                pair.add(m);
            }
            if (!isSet || parameterCount != 2 || m.getReturnType() != Void.TYPE) continue;
            pair = (List)pairs.get(propertyName);
            if (pair == null) {
                pair = new ArrayList();
                pairs.put(propertyName, pair);
            }
            pair.add(m);
        }
        HashMap<String, PropertyDescriptor> result = new HashMap<String, PropertyDescriptor>();
        for (String propertyName : pairs.keySet()) {
            List methods = (List)pairs.get(propertyName);
            if (methods.size() != 2) continue;
            Method method1 = (Method)methods.get(0);
            Method method2 = (Method)methods.get(1);
            Method setMethod = method1.getParameterTypes().length == 2 ? method1 : method2;
            Method getMethod = setMethod == method1 ? method2 : method1;
            Class<?> keyType = getMethod.getParameterTypes()[0];
            Class<?> propertyType = getMethod.getReturnType();
            if (keyType != setMethod.getParameterTypes()[0] || propertyType != setMethod.getParameterTypes()[1]) continue;
            try {
                result.put(propertyName, new ObjectIndexedPropertyDescriptor(propertyName, propertyType, getMethod, setMethod));
            }
            catch (IntrospectionException ex) {
                throw new OgnlException("Creating object indexed property descriptor for '" + propertyName + "' in " + targetClass, ex);
            }
        }
        return result;
    }

    public static Map<String, PropertyDescriptor> getPropertyDescriptors(Class<?> targetClass) throws IntrospectionException, OgnlException {
        ImmutableMap result = _propertyDescriptorCache.get(targetClass);
        if (result == null) {
            PropertyDescriptor[] pda = IntrospectorUtils.getBeanInfo(targetClass).getPropertyDescriptors();
            HashMap<String, PropertyDescriptor> builder = new HashMap<String, PropertyDescriptor>(101);
            int icount = pda.length;
            for (int i = 0; i < icount; ++i) {
                if (pda[i].getReadMethod() != null && !OgnlRuntime.isMethodCallable(pda[i].getReadMethod())) {
                    pda[i].setReadMethod(OgnlRuntime.findClosestMatchingMethod(targetClass, pda[i].getReadMethod(), pda[i].getName(), pda[i].getPropertyType(), true));
                }
                if (pda[i].getWriteMethod() != null && !OgnlRuntime.isMethodCallable(pda[i].getWriteMethod())) {
                    pda[i].setWriteMethod(OgnlRuntime.findClosestMatchingMethod(targetClass, pda[i].getWriteMethod(), pda[i].getName(), pda[i].getPropertyType(), false));
                }
                builder.put(pda[i].getName(), pda[i]);
            }
            builder.putAll(OgnlRuntime.findObjectIndexedPropertyDescriptors(targetClass));
            result = ImmutableMap.copyOf(builder);
            _propertyDescriptorCache.put(targetClass, (Map<String, PropertyDescriptor>)result);
        }
        return result;
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> targetClass, String propertyName) throws IntrospectionException, OgnlException {
        if (targetClass == null) {
            return null;
        }
        return OgnlRuntime.getPropertyDescriptors(targetClass).get(propertyName);
    }

    static Method findClosestMatchingMethod(Class<?> targetClass, Method m, String propertyName, Class<?> propertyType, boolean isReadMethod) {
        List<Method> methods = OgnlRuntime.getDeclaredMethods(targetClass, propertyName, !isReadMethod);
        for (int i = 0; i < methods.size(); ++i) {
            Method method = methods.get(i);
            if (!method.getName().equals(m.getName()) || !m.getReturnType().isAssignableFrom(m.getReturnType()) || method.getReturnType() != propertyType || method.getParameterTypes().length != m.getParameterTypes().length) continue;
            return method;
        }
        return m;
    }

    public static PropertyDescriptor[] getPropertyDescriptorsArray(Class<?> targetClass) throws IntrospectionException {
        PropertyDescriptor[] result = null;
        if (targetClass != null && (result = _propertyDescriptorArrayCache.get(targetClass)) == null) {
            result = IntrospectorUtils.getBeanInfo(targetClass).getPropertyDescriptors();
            _propertyDescriptorArrayCache.put(targetClass, result);
        }
        return result;
    }

    public static PropertyDescriptor getPropertyDescriptorFromArray(Class<?> targetClass, String name) throws IntrospectionException {
        PropertyDescriptor result = null;
        PropertyDescriptor[] pda = OgnlRuntime.getPropertyDescriptorsArray(targetClass);
        int icount = pda.length;
        for (int i = 0; result == null && i < icount; ++i) {
            if (pda[i].getName().compareTo(name) != 0) continue;
            result = pda[i];
        }
        return result;
    }

    public static void setMethodAccessor(Class<?> cls, MethodAccessor accessor) {
        _methodAccessors.put(cls, accessor);
    }

    public static MethodAccessor getMethodAccessor(Class<?> cls) throws OgnlException {
        return _methodAccessors.get(cls);
    }

    public static void setPropertyAccessor(Class<?> cls, PropertyAccessor accessor) {
        _propertyAccessors.put(cls, accessor);
    }

    public static PropertyAccessor getPropertyAccessor(Class<?> cls) throws OgnlException {
        return _propertyAccessors.get(cls);
    }

    public static ElementsAccessor getElementsAccessor(Class<?> cls) throws OgnlException {
        return _elementsAccessors.get(cls);
    }

    public static void setElementsAccessor(Class<?> cls, ElementsAccessor accessor) {
        _elementsAccessors.put(cls, accessor);
    }

    public static NullHandler getNullHandler(Class<?> cls) throws OgnlException {
        return _nullHandlers.get(cls);
    }

    public static void setNullHandler(Class<?> cls, NullHandler handler) {
        _nullHandlers.put(cls, handler);
    }

    public static Object getProperty(OgnlContext context, Object source, Object name) throws OgnlException {
        if (source == null) {
            throw new OgnlException("source is null for getProperty(null, \"" + name + "\")");
        }
        PropertyAccessor accessor = OgnlRuntime.getPropertyAccessor(OgnlRuntime.getTargetClass(source));
        if (accessor == null) {
            throw new OgnlException("No property accessor for " + OgnlRuntime.getTargetClass(source).getName());
        }
        return accessor.getProperty(context, source, name);
    }

    public static void setProperty(OgnlContext context, Object target, Object name, Object value) throws OgnlException {
        if (target == null) {
            throw new OgnlException("target is null for setProperty(null, \"" + name + "\", " + value + ")");
        }
        PropertyAccessor accessor = OgnlRuntime.getPropertyAccessor(OgnlRuntime.getTargetClass(target));
        if (accessor == null) {
            throw new OgnlException("No property accessor for " + OgnlRuntime.getTargetClass(target).getName());
        }
        accessor.setProperty(context, target, name, value);
    }

    public static int getIndexedPropertyType(OgnlContext context, Class<?> sourceClass, String name) throws OgnlException {
        int result = INDEXED_PROPERTY_NONE;
        try {
            PropertyDescriptor pd = OgnlRuntime.getPropertyDescriptor(sourceClass, name);
            if (pd != null) {
                if (pd instanceof IndexedPropertyDescriptor) {
                    result = INDEXED_PROPERTY_INT;
                } else if (pd instanceof ObjectIndexedPropertyDescriptor) {
                    result = INDEXED_PROPERTY_OBJECT;
                }
            }
        }
        catch (Exception ex) {
            throw new OgnlException("problem determining if '" + name + "' is an indexed property", ex);
        }
        return result;
    }

    public static Object getIndexedProperty(OgnlContext context, Object source, String name, Object index) throws OgnlException {
        try {
            Method m;
            Object[] args = new Object[]{index};
            PropertyDescriptor pd = OgnlRuntime.getPropertyDescriptor(source == null ? null : source.getClass(), name);
            if (pd instanceof IndexedPropertyDescriptor) {
                m = ((IndexedPropertyDescriptor)pd).getIndexedReadMethod();
            } else if (pd instanceof ObjectIndexedPropertyDescriptor) {
                m = ((ObjectIndexedPropertyDescriptor)pd).getIndexedReadMethod();
            } else {
                throw new OgnlException("property '" + name + "' is not an indexed property");
            }
            return OgnlRuntime.callMethod(context, source, m.getName(), args);
        }
        catch (OgnlException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OgnlException("getting indexed property descriptor for '" + name + "'", ex);
        }
    }

    public static void setIndexedProperty(OgnlContext context, Object source, String name, Object index, Object value) throws OgnlException {
        Object[] args = new Object[]{index, value};
        try {
            Method m;
            PropertyDescriptor pd = OgnlRuntime.getPropertyDescriptor(source == null ? null : source.getClass(), name);
            if (pd instanceof IndexedPropertyDescriptor) {
                m = ((IndexedPropertyDescriptor)pd).getIndexedWriteMethod();
            } else if (pd instanceof ObjectIndexedPropertyDescriptor) {
                m = ((ObjectIndexedPropertyDescriptor)pd).getIndexedWriteMethod();
            } else {
                throw new OgnlException("property '" + name + "' is not an indexed property");
            }
            OgnlRuntime.callMethod(context, source, m.getName(), args);
        }
        catch (OgnlException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OgnlException("getting indexed property descriptor for '" + name + "'", ex);
        }
    }

    public static EvaluationPool getEvaluationPool() {
        return _evaluationPool;
    }

    public static ObjectArrayPool getObjectArrayPool() {
        return _objectArrayPool;
    }

    public static void setClassCacheInspector(ClassCacheInspector cacheInspector) {
        _propertyDescriptorCache.setClassInspector(cacheInspector);
        _constructorCache.setClassInspector(cacheInspector);
        _staticMethodCache.setClassInspector(cacheInspector);
        _instanceMethodCache.setClassInspector(cacheInspector);
        _fieldCache.setClassInspector(cacheInspector);
        _declaredMethods[0].setClassInspector(cacheInspector);
        _declaredMethods[1].setClassInspector(cacheInspector);
    }

    public static Method getMethod(OgnlContext context, Class<?> target, String name, Node[] children, boolean includeStatic) {
        Class[] parms;
        if (children != null && children.length > 0) {
            parms = new Class[children.length];
            Class currType = context.getCurrentType();
            Class currAccessor = context.getCurrentAccessor();
            Object cast = context.get("_preCast");
            context.setCurrentObject(context.getRoot());
            context.setCurrentType(context.getRoot() != null ? context.getRoot().getClass() : null);
            context.setCurrentAccessor(null);
            context.setPreviousType(null);
            for (int i = 0; i < children.length; ++i) {
                children[i].toGetSourceString(context, context.getRoot());
                parms[i] = context.getCurrentType();
            }
            context.put("_preCast", cast);
            context.setCurrentType(currType);
            context.setCurrentAccessor(currAccessor);
            context.setCurrentObject(target);
        } else {
            parms = new Class[]{};
        }
        List<Method> methods = OgnlRuntime.getMethods(target, name, includeStatic);
        if (methods == null) {
            return null;
        }
        for (int i = 0; i < methods.size(); ++i) {
            boolean varArgs;
            Method m = methods.get(i);
            boolean bl = varArgs = OgnlRuntime.isJdk15() && m.isVarArgs();
            if (parms.length != m.getParameterTypes().length && !varArgs) continue;
            Class<?>[] mparms = m.getParameterTypes();
            boolean matched = true;
            for (int p = 0; p < mparms.length; ++p) {
                if (varArgs && mparms[p].isArray()) continue;
                if (parms[p] == null) {
                    matched = false;
                    break;
                }
                if (parms[p] == mparms[p] || mparms[p].isPrimitive() && Character.TYPE != mparms[p] && Byte.TYPE != mparms[p] && Number.class.isAssignableFrom(parms[p]) && OgnlRuntime.getPrimitiveWrapperClass(parms[p]) == mparms[p]) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            return m;
        }
        return null;
    }

    public static Method getReadMethod(Class<?> target, String name) {
        return OgnlRuntime.getReadMethod(target, name, -1);
    }

    public static Method getReadMethod(Class<?> target, String name, int numParms) {
        try {
            int i;
            name = name.replaceAll("\"", "").toLowerCase();
            BeanInfo info = IntrospectorUtils.getBeanInfo(target);
            MethodDescriptor[] methods = info.getMethodDescriptors();
            Method m = null;
            for (i = 0; i < methods.length; ++i) {
                if (!OgnlRuntime.isMethodCallable(methods[i].getMethod()) || !methods[i].getName().equalsIgnoreCase(name) && !methods[i].getName().toLowerCase().equals(name) && !methods[i].getName().toLowerCase().equals(GET_PREFIX + name) && !methods[i].getName().toLowerCase().equals("has" + name) && !methods[i].getName().toLowerCase().equals(IS_PREFIX + name) || methods[i].getName().startsWith(SET_PREFIX)) continue;
                if (numParms > 0 && methods[i].getMethod().getParameterTypes().length == numParms) {
                    return methods[i].getMethod();
                }
                if (numParms >= 0 || (m == null || m.getParameterTypes().length <= methods[i].getMethod().getParameterTypes().length) && m != null) continue;
                m = methods[i].getMethod();
            }
            if (m != null) {
                return m;
            }
            for (i = 0; i < methods.length; ++i) {
                if (!OgnlRuntime.isMethodCallable(methods[i].getMethod()) || !methods[i].getName().toLowerCase().endsWith(name) || methods[i].getName().startsWith(SET_PREFIX) || methods[i].getMethod().getReturnType() == Void.TYPE) continue;
                if (numParms > 0 && methods[i].getMethod().getParameterTypes().length == numParms) {
                    return methods[i].getMethod();
                }
                if (numParms >= 0 || (m == null || m.getParameterTypes().length <= methods[i].getMethod().getParameterTypes().length) && m != null) continue;
                m = methods[i].getMethod();
            }
            if (m != null) {
                return m;
            }
            if (!name.startsWith(GET_PREFIX)) {
                return OgnlRuntime.getReadMethod(target, GET_PREFIX + name, numParms);
            }
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        return null;
    }

    public static Method getWriteMethod(Class<?> target, String name) {
        return OgnlRuntime.getWriteMethod(target, name, -1);
    }

    public static Method getWriteMethod(Class<?> target, String name, int numParms) {
        try {
            name = name.replaceAll("\"", "");
            BeanInfo info = IntrospectorUtils.getBeanInfo(target);
            MethodDescriptor[] methods = info.getMethodDescriptors();
            for (int i = 0; i < methods.length; ++i) {
                if (!OgnlRuntime.isMethodCallable(methods[i].getMethod()) || !methods[i].getName().equalsIgnoreCase(name) && !methods[i].getName().toLowerCase().equals(name.toLowerCase()) && !methods[i].getName().toLowerCase().equals(SET_PREFIX + name.toLowerCase()) || methods[i].getName().startsWith(GET_PREFIX)) continue;
                if (numParms > 0 && methods[i].getMethod().getParameterTypes().length == numParms) {
                    return methods[i].getMethod();
                }
                if (numParms >= 0) continue;
                return methods[i].getMethod();
            }
            Method[] cmethods = target.getClass().getMethods();
            for (int i = 0; i < cmethods.length; ++i) {
                if (!OgnlRuntime.isMethodCallable(cmethods[i]) || !cmethods[i].getName().equalsIgnoreCase(name) && !cmethods[i].getName().toLowerCase().equals(name.toLowerCase()) && !cmethods[i].getName().toLowerCase().equals(SET_PREFIX + name.toLowerCase()) || cmethods[i].getName().startsWith(GET_PREFIX)) continue;
                if (numParms > 0 && cmethods[i].getParameterTypes().length == numParms) {
                    return cmethods[i];
                }
                if (numParms >= 0) continue;
                return cmethods[i];
            }
            if (!name.startsWith(SET_PREFIX)) {
                return OgnlRuntime.getReadMethod(target, SET_PREFIX + name, numParms);
            }
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        return null;
    }

    public static PropertyDescriptor getProperty(Class<?> target, String name) {
        try {
            PropertyDescriptor[] pds;
            BeanInfo info = IntrospectorUtils.getBeanInfo(target);
            for (PropertyDescriptor pd : pds = info.getPropertyDescriptors()) {
                if (!pd.getName().equalsIgnoreCase(name) && !pd.getName().toLowerCase().equals(name.toLowerCase()) && !pd.getName().toLowerCase().endsWith(name.toLowerCase())) continue;
                return pd;
            }
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        return null;
    }

    public static boolean isBoolean(String expression) {
        if (expression == null) {
            return false;
        }
        return "true".equals(expression) || "false".equals(expression) || "!true".equals(expression) || "!false".equals(expression) || "(true)".equals(expression) || "!(true)".equals(expression) || "(false)".equals(expression) || "!(false)".equals(expression) || expression.startsWith("ognl.OgnlOps");
    }

    public static boolean shouldConvertNumericTypes(OgnlContext context) {
        if (context.getCurrentType() == null || context.getPreviousType() == null) {
            return true;
        }
        if (context.getCurrentType() == context.getPreviousType() && context.getCurrentType().isPrimitive() && context.getPreviousType().isPrimitive()) {
            return false;
        }
        return context.getCurrentType() != null && !context.getCurrentType().isArray() && context.getPreviousType() != null && !context.getPreviousType().isArray();
    }

    public static String getChildSource(OgnlContext context, Object target, Node child) throws OgnlException {
        return OgnlRuntime.getChildSource(context, target, child, false);
    }

    public static String getChildSource(OgnlContext context, Object target, Node child, boolean forceConversion) throws OgnlException {
        String pre = (String)context.get("_currentChain");
        if (pre == null) {
            pre = "";
        }
        try {
            child.getValue(context, target);
        }
        catch (NullPointerException e) {
        }
        catch (ArithmeticException e) {
            context.setCurrentType(Integer.TYPE);
            return "0";
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        String source = null;
        try {
            source = child.toGetSourceString(context, target);
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        if (!(ASTConst.class.isInstance(child) || target != null && context.getRoot() == target)) {
            source = pre + source;
        }
        if (context.getRoot() != null) {
            source = ExpressionCompiler.getRootExpression(child, context.getRoot(), context) + source;
            context.setCurrentAccessor(context.getRoot().getClass());
        }
        if (ASTChain.class.isInstance(child)) {
            String cast = (String)context.remove("_preCast");
            if (cast == null) {
                cast = "";
            }
            source = cast + source;
        }
        if (source == null || source.trim().length() < 1) {
            source = "null";
        }
        return source;
    }

    static {
        _genericMethodParameterTypesCache = CopyOnWriteMap.builder().newHashMap();
        _ctorParameterTypesCache = CopyOnWriteMap.builder().newHashMap();
        _securityManager = System.getSecurityManager();
        _evaluationPool = new EvaluationPool();
        _objectArrayPool = new ObjectArrayPool();
        _compiler = new ExpressionCompiler();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(Boolean.TYPE, Boolean.class);
        builder.put(Boolean.class, Boolean.TYPE);
        builder.put(Byte.TYPE, Byte.class);
        builder.put(Byte.class, Byte.TYPE);
        builder.put(Character.TYPE, Character.class);
        builder.put(Character.class, Character.TYPE);
        builder.put(Short.TYPE, Short.class);
        builder.put(Short.class, Short.TYPE);
        builder.put(Integer.TYPE, Integer.class);
        builder.put(Integer.class, Integer.TYPE);
        builder.put(Long.TYPE, Long.class);
        builder.put(Long.class, Long.TYPE);
        builder.put(Float.TYPE, Float.class);
        builder.put(Float.class, Float.TYPE);
        builder.put(Double.TYPE, Double.class);
        builder.put(Double.class, Double.TYPE);
        PRIMITIVE_WRAPPER_CLASSES = builder.build();
        builder = ImmutableMap.builder();
        builder.put(Double.class, (Object)"(double)");
        builder.put(Float.class, (Object)"(float)");
        builder.put(Integer.class, (Object)"(int)");
        builder.put(Long.class, (Object)"(long)");
        builder.put(BigDecimal.class, (Object)"(double)");
        builder.put(BigInteger.class, (Object)"");
        NUMERIC_CASTS = builder.build();
        builder = ImmutableMap.builder();
        builder.put(Double.class, (Object)"doubleValue()");
        builder.put(Float.class, (Object)"floatValue()");
        builder.put(Integer.class, (Object)"intValue()");
        builder.put(Long.class, (Object)"longValue()");
        builder.put(Short.class, (Object)"shortValue()");
        builder.put(Byte.class, (Object)"byteValue()");
        builder.put(BigDecimal.class, (Object)"doubleValue()");
        builder.put(BigInteger.class, (Object)"doubleValue()");
        builder.put(Boolean.class, (Object)"booleanValue()");
        NUMERIC_VALUES = builder.build();
        builder = ImmutableMap.builder();
        builder.put(Integer.class, (Object)"");
        builder.put(Integer.TYPE, (Object)"");
        builder.put(Long.class, (Object)"l");
        builder.put(Long.TYPE, (Object)"l");
        builder.put(Float.class, (Object)"f");
        builder.put(Float.TYPE, (Object)"f");
        builder.put(Double.class, (Object)"d");
        builder.put(Double.TYPE, (Object)"d");
        builder.put(BigInteger.class, (Object)"d");
        builder.put(BigDecimal.class, (Object)"d");
        NUMERIC_LITERALS = builder.build();
        builder = ImmutableMap.builder();
        builder.put(Boolean.class, (Object)Boolean.FALSE);
        builder.put(Byte.class, (Object)new Byte(0));
        builder.put(Short.class, (Object)new Short(0));
        builder.put(Character.class, (Object)new Character('\u0000'));
        builder.put(Integer.class, (Object)new Integer(0));
        builder.put(Long.class, (Object)new Long(0L));
        builder.put(Float.class, (Object)new Float(0.0f));
        builder.put(Double.class, (Object)new Double(0.0));
        builder.put(BigInteger.class, (Object)new BigInteger("0"));
        builder.put(BigDecimal.class, (Object)new BigDecimal(0.0));
        NUMERIC_DEFAULTS = builder.build();
        ArrayPropertyAccessor p = new ArrayPropertyAccessor();
        OgnlRuntime.setPropertyAccessor(Object.class, new ObjectPropertyAccessor());
        OgnlRuntime.setPropertyAccessor(byte[].class, p);
        OgnlRuntime.setPropertyAccessor(short[].class, p);
        OgnlRuntime.setPropertyAccessor(char[].class, p);
        OgnlRuntime.setPropertyAccessor(int[].class, p);
        OgnlRuntime.setPropertyAccessor(long[].class, p);
        OgnlRuntime.setPropertyAccessor(float[].class, p);
        OgnlRuntime.setPropertyAccessor(double[].class, p);
        OgnlRuntime.setPropertyAccessor(Object[].class, p);
        OgnlRuntime.setPropertyAccessor(List.class, new ListPropertyAccessor());
        OgnlRuntime.setPropertyAccessor(Map.class, new MapPropertyAccessor());
        OgnlRuntime.setPropertyAccessor(Set.class, new SetPropertyAccessor());
        OgnlRuntime.setPropertyAccessor(Iterator.class, new IteratorPropertyAccessor());
        OgnlRuntime.setPropertyAccessor(Enumeration.class, new EnumerationPropertyAccessor());
        ArrayElementsAccessor e = new ArrayElementsAccessor();
        OgnlRuntime.setElementsAccessor(Object.class, new ObjectElementsAccessor());
        OgnlRuntime.setElementsAccessor(byte[].class, e);
        OgnlRuntime.setElementsAccessor(short[].class, e);
        OgnlRuntime.setElementsAccessor(char[].class, e);
        OgnlRuntime.setElementsAccessor(int[].class, e);
        OgnlRuntime.setElementsAccessor(long[].class, e);
        OgnlRuntime.setElementsAccessor(float[].class, e);
        OgnlRuntime.setElementsAccessor(double[].class, e);
        OgnlRuntime.setElementsAccessor(Object[].class, e);
        OgnlRuntime.setElementsAccessor(Collection.class, new CollectionElementsAccessor());
        OgnlRuntime.setElementsAccessor(Map.class, new MapElementsAccessor());
        OgnlRuntime.setElementsAccessor(Iterator.class, new IteratorElementsAccessor());
        OgnlRuntime.setElementsAccessor(Enumeration.class, new EnumerationElementsAccessor());
        OgnlRuntime.setElementsAccessor(Number.class, new NumberElementsAccessor());
        ObjectNullHandler nh = new ObjectNullHandler();
        OgnlRuntime.setNullHandler(Object.class, nh);
        OgnlRuntime.setNullHandler(byte[].class, nh);
        OgnlRuntime.setNullHandler(short[].class, nh);
        OgnlRuntime.setNullHandler(char[].class, nh);
        OgnlRuntime.setNullHandler(int[].class, nh);
        OgnlRuntime.setNullHandler(long[].class, nh);
        OgnlRuntime.setNullHandler(float[].class, nh);
        OgnlRuntime.setNullHandler(double[].class, nh);
        OgnlRuntime.setNullHandler(Object[].class, nh);
        ObjectMethodAccessor ma = new ObjectMethodAccessor();
        OgnlRuntime.setMethodAccessor(Object.class, ma);
        OgnlRuntime.setMethodAccessor(byte[].class, ma);
        OgnlRuntime.setMethodAccessor(short[].class, ma);
        OgnlRuntime.setMethodAccessor(char[].class, ma);
        OgnlRuntime.setMethodAccessor(int[].class, ma);
        OgnlRuntime.setMethodAccessor(long[].class, ma);
        OgnlRuntime.setMethodAccessor(float[].class, ma);
        OgnlRuntime.setMethodAccessor(double[].class, ma);
        OgnlRuntime.setMethodAccessor(Object[].class, ma);
        ImmutableMap.Builder builder2 = ImmutableMap.builder();
        builder2.put((Object)"boolean", Boolean.TYPE);
        builder2.put((Object)"byte", Byte.TYPE);
        builder2.put((Object)"short", Short.TYPE);
        builder2.put((Object)"char", Character.TYPE);
        builder2.put((Object)"int", Integer.TYPE);
        builder2.put((Object)"long", Long.TYPE);
        builder2.put((Object)"float", Float.TYPE);
        builder2.put((Object)"double", Double.TYPE);
        _primitiveTypes = builder2.build();
        builder2 = ImmutableMap.builder();
        builder2.put(Boolean.TYPE, (Object)Boolean.FALSE);
        builder2.put(Boolean.class, (Object)Boolean.FALSE);
        builder2.put(Byte.TYPE, (Object)new Byte(0));
        builder2.put(Byte.class, (Object)new Byte(0));
        builder2.put(Short.TYPE, (Object)new Short(0));
        builder2.put(Short.class, (Object)new Short(0));
        builder2.put(Character.TYPE, (Object)new Character('\u0000'));
        builder2.put(Integer.TYPE, (Object)new Integer(0));
        builder2.put(Long.TYPE, (Object)new Long(0L));
        builder2.put(Float.TYPE, (Object)new Float(0.0f));
        builder2.put(Double.TYPE, (Object)new Double(0.0));
        builder2.put(BigInteger.class, (Object)new BigInteger("0"));
        builder2.put(BigDecimal.class, (Object)new BigDecimal(0.0));
        _primitiveDefaults = builder2.build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SimpleCache<T> {
        private final String name;
        private final ClassCache<T> cache = new ConcurrentClassCache();

        SimpleCache(String name) {
            this.name = name;
        }

        T get(Class<?> cls) throws OgnlException {
            T answer = this.getHandler(cls);
            if (answer != null) {
                return answer;
            }
            throw new OgnlException("No " + this.name + " for class " + cls);
        }

        void put(Class<?> key, T value) {
            this.cache.put(key, value);
        }

        private T getHandler(Class<?> forClass) {
            Object answer = null;
            T t = this.cache.get(forClass);
            answer = t;
            if (t == null) {
                Class<?> keyFound;
                if (forClass.isArray()) {
                    answer = this.cache.get(Object[].class);
                    keyFound = null;
                } else {
                    keyFound = forClass;
                    block0: for (Class<?> c = forClass; c != null; c = c.getSuperclass()) {
                        answer = this.cache.get(c);
                        if (answer == null) {
                            for (Class<?> iface : c.getInterfaces()) {
                                answer = this.cache.get(iface);
                                if (answer == null) {
                                    answer = this.getHandler(iface);
                                }
                                if (answer == null) continue;
                                keyFound = iface;
                                break block0;
                            }
                            continue;
                        }
                        keyFound = c;
                        break;
                    }
                }
                if (answer != null && keyFound != forClass) {
                    this.cache.putIfAbsent(forClass, answer);
                }
            }
            return answer;
        }
    }
}

