/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.continuations;

import com.uwyn.rife.continuations.ContinuationConfig;
import com.uwyn.rife.continuations.MetricsClassVisitor;
import com.uwyn.rife.continuations.asm.AnnotationVisitor;
import com.uwyn.rife.continuations.asm.Attribute;
import com.uwyn.rife.continuations.asm.Label;
import com.uwyn.rife.continuations.asm.MethodVisitor;
import com.uwyn.rife.continuations.asm.Opcodes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

class MetricsMethodVisitor
implements MethodVisitor,
Opcodes {
    private MetricsClassVisitor mClassVisitor = null;
    private String mClassName = null;
    private int mPausecount = 0;
    private ArrayList mLabelsOrder = new ArrayList();
    private HashMap mExceptionTypes = new HashMap();

    MetricsMethodVisitor(MetricsClassVisitor classVisitor, String className) {
        this.mClassVisitor = classVisitor;
        this.mClassName = className;
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        ArrayList exception_labels_types = new ArrayList(this.mLabelsOrder.size());
        Iterator iterator = this.mLabelsOrder.iterator();
        while (iterator.hasNext()) {
            Label label = (Label)iterator.next();
            exception_labels_types.add(this.mExceptionTypes.get(label));
        }
        this.mClassVisitor.setMaxLocals(maxLocals);
        this.mClassVisitor.setPauseCount(this.mPausecount);
        this.mClassVisitor.setExceptionTypes(exception_labels_types);
    }

    public void visitMethodInsn(int opcode, String owner, String methodname, String desc) {
        String owner_classname = owner.replace('/', '.');
        if ((ContinuationConfig.getInstance().getContinuableClassOrInterfaceName().equals(owner_classname) || this.mClassName.equals(owner_classname)) && ("pause".equals(methodname) || "call".equals(methodname) && "(Ljava/lang/String;)Ljava/lang/Object;".equals(desc))) {
            ++this.mPausecount;
        }
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
    }

    public void visitVarInsn(int opcode, int var) {
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        if (null == type) {
            type = "java/lang/Throwable";
        }
        this.mExceptionTypes.put(handler, type);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
    }

    public void visitJumpInsn(int opcode, Label label) {
    }

    public void visitLabel(Label label) {
        this.mLabelsOrder.add(label);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
    }

    public void visitLineNumber(int line, Label start) {
    }

    public void visitIntInsn(int opcode, int operand) {
    }

    public void visitIincInsn(int var, int increment) {
    }

    public void visitTypeInsn(int opcode, String desc) {
    }

    public void visitLdcInsn(Object cst) {
    }

    public void visitInsn(int opcode) {
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitCode() {
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return null;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return null;
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        return null;
    }

    public void visitEnd() {
    }
}

