/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.connector;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.crowd.integration.directory.connector.ApacheDS;
import com.atlassian.crowd.integration.directory.connector.ApacheDS15;
import com.atlassian.crowd.integration.directory.connector.AppleOpenDirectory;
import com.atlassian.crowd.integration.directory.connector.FedoraDS;
import com.atlassian.crowd.integration.directory.connector.GenericLDAP;
import com.atlassian.crowd.integration.directory.connector.MicrosoftActiveDirectory;
import com.atlassian.crowd.integration.directory.connector.NovelleDirectory;
import com.atlassian.crowd.integration.directory.connector.OpenDS;
import com.atlassian.crowd.integration.directory.connector.OpenLDAP;
import com.atlassian.crowd.integration.directory.connector.OpenLDAPRfc2307;
import com.atlassian.crowd.integration.directory.connector.Rfc2307;
import com.atlassian.crowd.integration.directory.connector.SunONE;
import com.atlassian.crowd.integration.directory.monitor.MonitorCapable;
import com.atlassian.crowd.integration.directory.monitor.listener.ListeningCapable;
import com.atlassian.crowd.integration.directory.monitor.poller.PollingCapable;
import com.atlassian.crowd.util.connector.LDAPPropertiesHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPPropertiesHelperImpl
implements InitializingBean,
LDAPPropertiesHelper {
    private static final Logger logger = Logger.getLogger(LDAPPropertiesHelperImpl.class);
    private Map<String, String> implementations;
    private Map<String, Properties> configurationDetails;
    private List<String> monitorCapableImplementations;
    private List<String> listeningCapableImplementations;
    private List<String> pollingCapableImplementations;

    public void afterPropertiesSet() throws Exception {
        this.implementations = new LinkedHashMap<String, String>();
        this.implementations.put(MicrosoftActiveDirectory.getStaticDirectoryType(), MicrosoftActiveDirectory.class.getName());
        this.implementations.put(ApacheDS.getStaticDirectoryType(), ApacheDS.class.getName());
        this.implementations.put(ApacheDS15.getStaticDirectoryType(), ApacheDS15.class.getName());
        this.implementations.put(AppleOpenDirectory.getStaticDirectoryType(), AppleOpenDirectory.class.getName());
        this.implementations.put(FedoraDS.getStaticDirectoryType(), FedoraDS.class.getName());
        this.implementations.put(GenericLDAP.getStaticDirectoryType(), GenericLDAP.class.getName());
        this.implementations.put(NovelleDirectory.getStaticDirectoryType(), NovelleDirectory.class.getName());
        this.implementations.put(OpenDS.getStaticDirectoryType(), OpenDS.class.getName());
        this.implementations.put(OpenLDAP.getStaticDirectoryType(), OpenLDAP.class.getName());
        this.implementations.put(OpenLDAPRfc2307.getStaticDirectoryType(), OpenLDAPRfc2307.class.getName());
        this.implementations.put(Rfc2307.getStaticDirectoryType(), Rfc2307.class.getName());
        this.implementations.put(SunONE.getStaticDirectoryType(), SunONE.class.getName());
        logger.debug((Object)("Added the following LDAP implementations: " + this.implementations.toString()));
        this.configurationDetails = new HashMap<String, Properties>();
        this.configurationDetails.put(GenericLDAP.class.getName(), this.loadDirectoryProperties(GenericLDAP.class));
        this.configurationDetails.put(OpenLDAP.class.getName(), this.loadDirectoryProperties(OpenLDAP.class));
        this.configurationDetails.put(MicrosoftActiveDirectory.class.getName(), this.loadDirectoryProperties(MicrosoftActiveDirectory.class));
        this.configurationDetails.put(SunONE.class.getName(), this.loadDirectoryProperties(SunONE.class));
        this.configurationDetails.put(ApacheDS.class.getName(), this.loadDirectoryProperties(ApacheDS.class));
        this.configurationDetails.put(ApacheDS15.class.getName(), this.loadDirectoryProperties(ApacheDS15.class));
        this.configurationDetails.put(NovelleDirectory.class.getName(), this.loadDirectoryProperties(NovelleDirectory.class));
        this.configurationDetails.put(Rfc2307.class.getName(), this.loadDirectoryProperties(Rfc2307.class));
        this.configurationDetails.put(AppleOpenDirectory.class.getName(), this.loadDirectoryProperties(AppleOpenDirectory.class));
        this.configurationDetails.put(OpenDS.class.getName(), this.loadDirectoryProperties(OpenDS.class));
        this.configurationDetails.put(FedoraDS.class.getName(), this.loadDirectoryProperties(FedoraDS.class));
        this.configurationDetails.put(OpenLDAPRfc2307.class.getName(), this.loadDirectoryProperties(OpenLDAPRfc2307.class));
        logger.debug((Object)("Added the following LDAP configuration details: " + this.configurationDetails.toString()));
        this.monitorCapableImplementations = new ArrayList<String>();
        this.listeningCapableImplementations = new ArrayList<String>();
        this.pollingCapableImplementations = new ArrayList<String>();
        for (String className : this.implementations.values()) {
            try {
                Class clazz = ClassLoaderUtils.loadClass((String)className, this.getClass());
                if (MonitorCapable.class.isAssignableFrom(clazz)) {
                    this.monitorCapableImplementations.add(className);
                }
                if (ListeningCapable.class.isAssignableFrom(clazz)) {
                    this.listeningCapableImplementations.add(className);
                }
                if (!PollingCapable.class.isAssignableFrom(clazz)) continue;
                this.pollingCapableImplementations.add(className);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to load directory connector implementation class: " + className));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadDirectoryProperties(Class clazz) {
        Properties props = new Properties();
        String fqcn = clazz.getName();
        String key = fqcn.substring(fqcn.lastIndexOf(46) + 1) + ".properties";
        InputStream stream = clazz.getResourceAsStream(key.toLowerCase());
        if (stream == null) {
            logger.warn((Object)("Unable to load properties with key: " + key));
        } else {
            try {
                props.load(stream);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("The following properties for key: " + key + "were loaded: " + props));
                }
            }
            catch (IOException e) {
                logger.fatal((Object)("Failed to load property with key: " + key), (Throwable)e);
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return props;
    }

    public Map<String, String> getImplementations() {
        return this.implementations;
    }

    public Map<String, Properties> getConfigurationDetails() {
        return this.configurationDetails;
    }

    public List<String> getMonitorCapableImplementations() {
        return this.monitorCapableImplementations;
    }

    public List<String> getListeningCapableImplementations() {
        return this.listeningCapableImplementations;
    }

    public List<String> getPollingCapableImplementations() {
        return this.pollingCapableImplementations;
    }
}

