/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.connector.util;

import com.atlassian.crowd.util.xml.XmlValidator;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.ldap.UncategorizedLdapException;

public class DirectoryAttributeRetriever {
    private static final Logger logger = Logger.getLogger(DirectoryAttributeRetriever.class);

    public static String getValueFromAttributes(String directoryAttributeName, Attributes directoryAttributes) {
        if (StringUtils.isBlank((String)directoryAttributeName)) {
            return null;
        }
        String value = null;
        Attribute values = directoryAttributes.get(directoryAttributeName);
        if (values != null && values.size() > 0) {
            try {
                Object attributeValue = values.get(0);
                if (attributeValue != null && (StringUtils.isBlank((String)(value = attributeValue.toString())) || !XmlValidator.isSafe(value))) {
                    logger.info((Object)("Unsafe or Blank attribute value for attribute <" + directoryAttributeName + ">: " + value));
                    value = null;
                }
            }
            catch (NamingException e) {
                throw new UncategorizedLdapException((Throwable)e);
            }
        }
        return value;
    }
}

