/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.manager;

import java.util.concurrent.atomic.AtomicReference;

class StateTracker {
    private final AtomicReference<State> state = new AtomicReference<State>(State.NOT_STARTED);

    StateTracker() {
    }

    public State get() {
        return this.state.get();
    }

    StateTracker setState(State newState) throws IllegalStateException {
        State oldState;
        do {
            oldState = this.get();
            oldState.check(newState);
        } while (!this.state.compareAndSet(oldState, newState));
        return this;
    }

    public String toString() {
        return this.get().toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        NOT_STARTED{

            void check(State newState) {
                if (newState != STARTING && newState != SHUTTING_DOWN) {
                    this.illegalState(newState);
                }
            }
        }
        ,
        STARTING,
        STARTED,
        SHUTTING_DOWN,
        SHUTDOWN{

            void check(State newState) {
                if (newState != STARTING) {
                    this.illegalState(newState);
                }
            }
        };


        void check(State newState) {
            if (this.ordinal() + 1 != newState.ordinal()) {
                this.illegalState(newState);
            }
        }

        void illegalState(State newState) {
            throw new IllegalStateException("Cannot go from State: " + (Object)((Object)this) + " to: " + (Object)((Object)newState));
        }
    }
}

