/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.springsecurity;

import com.atlassian.crowd.integration.authentication.ValidationFactor;
import com.atlassian.crowd.integration.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.integration.exception.ExpiredCredentialException;
import com.atlassian.crowd.integration.exception.InactiveAccountException;
import com.atlassian.crowd.integration.exception.InvalidAuthenticationException;
import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.springsecurity.CrowdAccessDeniedException;
import com.atlassian.crowd.integration.springsecurity.CrowdSSOAuthenticationDetails;
import com.atlassian.crowd.integration.springsecurity.CrowdSSOAuthenticationToken;
import com.atlassian.crowd.integration.springsecurity.CrowdSSOTokenInvalidException;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetails;
import java.rmi.RemoteException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.AuthenticationServiceException;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.CredentialsExpiredException;
import org.springframework.security.DisabledException;
import org.springframework.security.providers.AbstractAuthenticationToken;
import org.springframework.security.providers.AuthenticationProvider;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.userdetails.UsernameNotFoundException;

public abstract class CrowdAuthenticationProvider
implements AuthenticationProvider {
    private static final Log logger = LogFactory.getLog(CrowdAuthenticationProvider.class);
    protected final String applicationName;

    protected CrowdAuthenticationProvider(String applicationName) {
        this.applicationName = applicationName;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!this.supports(authentication.getClass())) {
            return null;
        }
        if (!this.supports((AbstractAuthenticationToken)authentication)) {
            return null;
        }
        Authentication authenticatedToken = null;
        if (authentication instanceof UsernamePasswordAuthenticationToken) {
            logger.debug((Object)"Processing a UsernamePasswordAuthenticationToken");
            authenticatedToken = this.authenticateUsernamePassword((UsernamePasswordAuthenticationToken)authentication);
        } else if (authentication instanceof CrowdSSOAuthenticationToken) {
            logger.debug((Object)"Processing a CrowdSSOAuthenticationToken");
            authenticatedToken = this.authenticateCrowdSSO((CrowdSSOAuthenticationToken)authentication);
        }
        return authenticatedToken;
    }

    protected Authentication authenticateUsernamePassword(UsernamePasswordAuthenticationToken passwordToken) throws AuthenticationException {
        if (passwordToken.getPrincipal() == null || StringUtils.isEmpty((String)passwordToken.getPrincipal().toString())) {
            throw new BadCredentialsException("UsernamePasswordAuthenticationToken contains empty username");
        }
        if (passwordToken.getCredentials() == null || StringUtils.isEmpty((String)passwordToken.getCredentials().toString())) {
            throw new BadCredentialsException("UsernamePasswordAuthenticationToken contains empty password");
        }
        Object authenticatedToken = null;
        try {
            if (passwordToken.getDetails() != null && passwordToken.getDetails() instanceof CrowdSSOAuthenticationDetails) {
                CrowdSSOAuthenticationDetails details = (CrowdSSOAuthenticationDetails)passwordToken.getDetails();
                String crowdTokenString = this.authenticate(passwordToken.getPrincipal().toString(), passwordToken.getCredentials().toString(), details.getValidationFactors());
                CrowdUserDetails userDetails = this.loadUserByUsername(passwordToken.getPrincipal().toString());
                authenticatedToken = new CrowdSSOAuthenticationToken(userDetails, crowdTokenString, userDetails.getAuthorities());
            } else {
                this.authenticate(passwordToken.getPrincipal().toString(), passwordToken.getCredentials().toString(), new ValidationFactor[0]);
                CrowdUserDetails userDetails = this.loadUserByUsername(passwordToken.getPrincipal().toString());
                authenticatedToken = new UsernamePasswordAuthenticationToken((Object)userDetails, passwordToken.getCredentials(), userDetails.getAuthorities());
            }
        }
        catch (Exception e) {
            throw this.translateException(e);
        }
        return authenticatedToken;
    }

    protected abstract boolean isAuthenticated(String var1, ValidationFactor[] var2) throws InvalidAuthorizationTokenException, RemoteException, ApplicationAccessDeniedException;

    protected abstract String authenticate(String var1, String var2, ValidationFactor[] var3) throws InvalidAuthorizationTokenException, InvalidAuthenticationException, InactiveAccountException, ApplicationAccessDeniedException, RemoteException, ExpiredCredentialException;

    protected abstract CrowdUserDetails loadUserByUsername(String var1) throws UsernameNotFoundException, DataAccessException;

    protected abstract CrowdUserDetails loadUserByToken(String var1) throws CrowdSSOTokenInvalidException, DataAccessException;

    protected Authentication authenticateCrowdSSO(CrowdSSOAuthenticationToken ssoToken) throws AuthenticationException {
        if (ssoToken.getCredentials() == null || StringUtils.isEmpty((String)ssoToken.getCredentials().toString())) {
            throw new BadCredentialsException("CrowdSSOAuthenticationToken contains empty token credential");
        }
        if (ssoToken.getDetails() == null || !(ssoToken.getDetails() instanceof CrowdSSOAuthenticationDetails)) {
            throw new BadCredentialsException("CrowdSSOAuthenticationToken does not contain any validation factors");
        }
        CrowdSSOAuthenticationToken authenticatedToken = null;
        String crowdTokenString = ssoToken.getCredentials().toString();
        CrowdSSOAuthenticationDetails details = (CrowdSSOAuthenticationDetails)ssoToken.getDetails();
        try {
            if (!this.isAuthenticated(crowdTokenString, details.getValidationFactors())) {
                throw new CrowdSSOTokenInvalidException("Crowd SSO token is invalid");
            }
            CrowdUserDetails userDetails = this.loadUserByToken(crowdTokenString);
            authenticatedToken = new CrowdSSOAuthenticationToken(userDetails, crowdTokenString, userDetails.getAuthorities());
        }
        catch (Exception e) {
            throw this.translateException(e);
        }
        return authenticatedToken;
    }

    protected AuthenticationException translateException(Exception e) {
        if (e instanceof AuthenticationException) {
            return (AuthenticationException)e;
        }
        if (e instanceof ApplicationAccessDeniedException) {
            return new CrowdAccessDeniedException("User does not have access to application: " + this.applicationName);
        }
        if (e instanceof ExpiredCredentialException) {
            return new CredentialsExpiredException(e.getMessage());
        }
        if (e instanceof InvalidAuthenticationException || e instanceof InvalidTokenException) {
            return new BadCredentialsException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof InactiveAccountException) {
            return new DisabledException(e.getMessage(), (Throwable)e);
        }
        return new AuthenticationServiceException(e.getMessage(), (Throwable)e);
    }

    public boolean supports(Class authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication) || CrowdSSOAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public boolean supports(AbstractAuthenticationToken authenticationToken) {
        if (authenticationToken.getDetails() == null || !(authenticationToken.getDetails() instanceof CrowdSSOAuthenticationDetails)) {
            return true;
        }
        if (authenticationToken.getDetails() instanceof CrowdSSOAuthenticationDetails) {
            CrowdSSOAuthenticationDetails details = (CrowdSSOAuthenticationDetails)authenticationToken.getDetails();
            return details.getApplicationName().equals(this.applicationName);
        }
        return false;
    }
}

