/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.atlassianuser;

import com.atlassian.crowd.integration.authentication.UserAuthenticationContext;
import com.atlassian.crowd.integration.http.HttpAuthenticator;
import com.atlassian.crowd.integration.http.HttpAuthenticatorFactory;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClientFactory;
import com.atlassian.user.EntityException;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.security.authentication.Authenticator;
import org.apache.log4j.Logger;

public class CrowdAuthenticator
implements Authenticator {
    private static final Logger logger = Logger.getLogger(CrowdAuthenticator.class);
    private final RepositoryIdentifier repositoryIdentifier;
    private final SecurityServerClient securityServerClient;
    private final HttpAuthenticator httpAuthenticator;

    public CrowdAuthenticator(RepositoryIdentifier repositoryIdentifier) {
        this(repositoryIdentifier, SecurityServerClientFactory.getSecurityServerClient(), HttpAuthenticatorFactory.getCacheAwareHttpAuthenticator());
    }

    public CrowdAuthenticator(RepositoryIdentifier repositoryIdentifier, SecurityServerClient securityServerClient, HttpAuthenticator httpAuthenticator) {
        this.repositoryIdentifier = repositoryIdentifier;
        this.securityServerClient = securityServerClient;
        this.httpAuthenticator = httpAuthenticator;
    }

    public boolean authenticate(String username, String password) throws EntityException {
        try {
            UserAuthenticationContext authenticationContext = this.httpAuthenticator.getPrincipalAuthenticationContext(null, null, username, password);
            this.securityServerClient.authenticatePrincipal(authenticationContext);
            return true;
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public RepositoryIdentifier getRepository() {
        return this.repositoryIdentifier;
    }
}

