/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.container.felix;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.felix.framework.Logger;
import org.apache.felix.moduleloader.ResourceNotFoundException;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class FelixLoggerBridge
extends Logger {
    private final Log log;
    private static final List<String> messagesToIgnore = Arrays.asList("BeanInfo", "sun.beans.editors.", "add an import for 'org.springframework.osgi.service.", "Class 'org.springframework.util.Assert'", "Class '[Lorg.springframework.osgi.service", "org.springframework.core.InfrastructureProxy", "org.springframework.aop.SpringProxy", "org.springframework.aop.IntroductionInfo", "Class 'org.apache.commons.logging.impl.Log4JLogger'", "org.springframework.util.Assert", "org.springframework.osgi.service.importer.ServiceReferenceProxy", "org.springframework.osgi.service.importer.ImportedOsgiServiceProxy", "org.springframework.osgi.service.importer.support.ImportContextClassLoaderEditor", "[Lorg.springframework.osgi.service.importer.OsgiServiceLifecycleListener;Editor");

    public FelixLoggerBridge(Log log) {
        this.log = log;
        this.setLogLevel(log.isDebugEnabled() ? 4 : (log.isInfoEnabled() ? 2 : (log.isWarnEnabled() ? 2 : 1)));
    }

    protected void doLog(ServiceReference serviceReference, int level, String message, Throwable throwable) {
        if (serviceReference != null) {
            message = "Service " + serviceReference + ": " + message;
        }
        switch (level) {
            case 4: {
                this.log.debug((Object)message);
                break;
            }
            case 1: {
                if (throwable != null) {
                    if (throwable instanceof BundleException && ((BundleException)throwable).getNestedException() != null) {
                        throwable = ((BundleException)throwable).getNestedException();
                    }
                    this.log.error((Object)message, throwable);
                    break;
                }
                this.log.error((Object)message);
                break;
            }
            case 3: {
                this.logInfoUnlessLame(message);
                break;
            }
            case 2: {
                if (throwable != null) {
                    if (throwable instanceof ClassNotFoundException && this.isClassNotFoundsWeCareAbout(throwable)) {
                        this.log.debug((Object)("Class not found in bundle: " + message));
                        break;
                    }
                    if (!(throwable instanceof ResourceNotFoundException)) break;
                    this.log.trace((Object)("Resource not found in bundle: " + message));
                    break;
                }
                this.logInfoUnlessLame(message);
                break;
            }
            default: {
                this.log.debug((Object)("UNKNOWN[" + level + "]: " + message));
            }
        }
    }

    protected void logInfoUnlessLame(String message) {
        if (message != null) {
            for (String dumbBit : messagesToIgnore) {
                if (!message.contains(dumbBit)) continue;
                return;
            }
        }
        this.log.info((Object)message);
    }

    public boolean isClassNotFoundsWeCareAbout(Throwable t) {
        if (t instanceof ClassNotFoundException) {
            String className = t.getMessage();
            if (className.contains("***") && t.getCause() instanceof ClassNotFoundException) {
                className = t.getCause().getMessage();
            }
            if (!(className.startsWith("org.springframework") || className.endsWith("BeanInfo") || className.endsWith("Editor"))) {
                return true;
            }
        }
        return false;
    }
}

