/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.hibernate;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.impl.DuplicateEntityException;
import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.impl.hibernate.DefaultHibernateGroup;
import com.atlassian.user.impl.hibernate.DefaultHibernateUser;
import com.atlassian.user.impl.hibernate.repository.HibernateRepository;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.security.password.PasswordEncryptor;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.orm.hibernate.support.HibernateDaoSupport;

public class HibernateUserManager
extends HibernateDaoSupport
implements UserManager {
    private static final String USERNAME_FIELD = "username";
    public static final String ENTITYID_FIELD = "entityid";
    private static final Logger log = Logger.getLogger((Class)HibernateUserManager.class);
    private final RepositoryIdentifier identifier;
    private final PasswordEncryptor passwordEncryptor;

    public HibernateUserManager(RepositoryIdentifier identifier, HibernateRepository repository, PasswordEncryptor passwordEncryptor) {
        this.identifier = identifier;
        this.passwordEncryptor = passwordEncryptor;
        this.setSessionFactory(repository.getSessionFactory());
    }

    public Pager getUsers() throws EntityException {
        List result;
        try {
            result = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query queryObject = session.getNamedQuery("atluser.user_findAll");
                    SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateUserManager.this.getSessionFactory());
                    return queryObject.list();
                }
            });
        }
        catch (DataAccessException e) {
            throw new RepositoryException(e);
        }
        return new DefaultPager(result);
    }

    public Pager getUserNames() throws EntityException {
        List result;
        try {
            result = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query queryObject = session.getNamedQuery("atluser.user_findAllUserNames");
                    SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateUserManager.this.getSessionFactory());
                    return queryObject.list();
                }
            });
        }
        catch (DataAccessException e) {
            throw new RepositoryException(e);
        }
        return new DefaultPager(result);
    }

    public User getUser(final String username) throws EntityException {
        List result;
        if (username == null) {
            throw new IllegalArgumentException("Input (username) is null.");
        }
        try {
            result = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query queryObject = session.getNamedQuery("atluser.user_find");
                    SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateUserManager.this.getSessionFactory());
                    if (username != null) {
                        queryObject.setParameter(HibernateUserManager.USERNAME_FIELD, (Object)username);
                    }
                    return queryObject.list();
                }
            });
        }
        catch (DataAccessException e) {
            throw new RepositoryException(e);
        }
        return result.isEmpty() ? null : (User)result.get(0);
    }

    public User createUser(String username) throws EntityException {
        if (username == null) {
            throw new IllegalArgumentException("Input (username) is null.");
        }
        User existingUser = this.getUser(username);
        if (existingUser != null) {
            throw new DuplicateEntityException("User with name [" + username + "] already exists in this repository (" + this.identifier.getName() + ")");
        }
        DefaultHibernateUser user = new DefaultHibernateUser(username);
        this.saveUser(user);
        return user;
    }

    public void alterPassword(User user, String password) throws EntityException {
        User foundUser = this.getUser(user.getName());
        if (foundUser == null) {
            throw new EntityException("This repository [" + this.identifier.getName() + "] does not handle user [" + user.getName() + "]");
        }
        password = this.passwordEncryptor.encrypt(password);
        foundUser.setPassword(password);
        this.saveUser(foundUser);
    }

    public void saveUser(User user) throws EntityException {
        if (user == null) {
            throw new IllegalArgumentException("Input (user) is null.");
        }
        if (!this.isHandledUser(user)) {
            throw new IllegalArgumentException("User is not a Hibernate entity [" + user.getClass().getName() + "]");
        }
        DefaultHibernateUser dUser = (DefaultHibernateUser)user;
        this.getHibernateTemplate().saveOrUpdate((Object)dUser);
    }

    public void removeUser(User user) throws EntityException {
        if (user == null) {
            throw new IllegalArgumentException("Input (username) is null.");
        }
        if (!this.isHandledUser(user)) {
            throw new IllegalArgumentException("User is not a Hibernate entity [" + user.getClass().getName());
        }
        DefaultHibernateUser dUser = (DefaultHibernateUser)this.getUser(user.getName());
        if (dUser == null) {
            throw new IllegalArgumentException("User can not be found in this user manager: [" + user + "]");
        }
        List groups = this.getGroupsForLocalUser(dUser);
        if (groups != null) {
            dUser.setGroups(null);
            Iterator groupsOfUser = groups.iterator();
            while (groupsOfUser.hasNext()) {
                DefaultHibernateGroup group = (DefaultHibernateGroup)groupsOfUser.next();
                Set members = group.getLocalMembers();
                if (members != null) {
                    members.remove(dUser);
                }
                this.getHibernateTemplate().saveOrUpdate((Object)group);
            }
        }
        this.getHibernateTemplate().delete((Object)dUser);
    }

    protected List getGroupsForLocalUser(User user) throws RepositoryException {
        List result;
        if (user == null) {
            throw new IllegalArgumentException("Input (user) is null.");
        }
        final DefaultHibernateUser defUser = (DefaultHibernateUser)user;
        try {
            result = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    Query queryObject = session.getNamedQuery("atluser.group_getGroupsForUser");
                    SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateUserManager.this.getSessionFactory());
                    queryObject.setLong(HibernateUserManager.ENTITYID_FIELD, defUser.getId());
                    return queryObject.list();
                }
            });
        }
        catch (DataAccessException e) {
            throw new RepositoryException(e);
        }
        return result;
    }

    private boolean isHandledUser(User user) {
        return user instanceof DefaultHibernateUser;
    }

    public boolean isReadOnly(User user) throws EntityException {
        return false;
    }

    public PasswordEncryptor getPasswordEncryptor(User user) throws EntityException {
        return this.passwordEncryptor;
    }

    public RepositoryIdentifier getIdentifier() {
        return this.identifier;
    }

    public RepositoryIdentifier getRepository(Entity entity) throws EntityException {
        return this.getUser(entity.getName()) == null ? null : this.identifier;
    }

    public boolean isCreative() {
        return true;
    }
}

