/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.search;

import com.atlassian.crowd.integration.model.group.GroupType;
import com.atlassian.crowd.search.Entity;
import org.apache.commons.lang.builder.ToStringBuilder;

public class EntityDescriptor {
    private final Entity entityType;
    private final GroupType groupType;

    private EntityDescriptor(Entity entityType, GroupType groupType) {
        this.entityType = entityType;
        this.groupType = groupType;
    }

    private EntityDescriptor(Entity entity) {
        this(entity, null);
    }

    public static EntityDescriptor group(GroupType groupType) {
        return new EntityDescriptor(Entity.GROUP, groupType);
    }

    public static EntityDescriptor group() {
        return EntityDescriptor.group(null);
    }

    public static EntityDescriptor user() {
        return new EntityDescriptor(Entity.USER);
    }

    public static EntityDescriptor directory() {
        return new EntityDescriptor(Entity.DIRECTORY);
    }

    public static EntityDescriptor token() {
        return new EntityDescriptor(Entity.TOKEN);
    }

    public static EntityDescriptor application() {
        return new EntityDescriptor(Entity.APPLICATION);
    }

    public static EntityDescriptor alias() {
        return new EntityDescriptor(Entity.ALIAS);
    }

    public Entity getEntityType() {
        return this.entityType;
    }

    public GroupType getGroupType() {
        return this.groupType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityDescriptor that = (EntityDescriptor)o;
        if (this.entityType != that.entityType) {
            return false;
        }
        return this.groupType == that.groupType;
    }

    public int hashCode() {
        int result = this.entityType != null ? this.entityType.hashCode() : 0;
        result = 31 * result + (this.groupType != null ? this.groupType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("entityType", (Object)this.entityType).append("groupType", (Object)this.groupType).toString();
    }
}

