/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.console.action;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.crowd.integration.exception.DirectoryAccessException;
import com.atlassian.crowd.integration.exception.InvalidUserException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetails;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetailsService;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.bootstrap.CrowdBootstrapManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.license.CrowdLicenseManager;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.extras.api.crowd.CrowdLicense;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.model.WebLink;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.xwork.ActionSupport;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.anonymous.AnonymousAuthenticationToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseAction
extends ActionSupport {
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    protected Integer tab = 1;
    private Boolean authenticated = null;
    private Boolean admin = null;
    private SOAPPrincipal remoteUser;
    protected boolean initialLoad = true;
    private Map<String, Object> siteMeshProperties = null;
    protected String actionMessageAlertColor;
    public static final String ALERT_GREEN = "green";
    public static final String ALERT_YELLOW = "yellow";
    public static final String ALERT_RED = "red";
    public static final String ALERT_BLUE = "blue";
    protected PropertyManager propertyManager;
    protected DirectoryManager directoryManager;
    protected ApplicationManager applicationManager;
    protected CrowdLicenseManager crowdLicenseManager;
    private WebResourceManager webResourceManager;
    private CrowdUserDetailsService crowdUserDetailsService;
    private Map<String, Object> webFragmentsContextMap;
    private WebInterfaceManager webInterfaceManager;
    private Integer currentLicenseResourceTotal = new Integer(0);
    private static final String DEFAULT_IMAGE_LOCATION = "/console/images/icons/16x16/16";
    private static final String ICON_IMAGE_TYPE = ".png";
    protected ApplicationService applicationService;

    public String doDefault() throws Exception {
        return "success";
    }

    private void updateAuthenticationStatus() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        this.admin = false;
        if (auth == null || auth instanceof AnonymousAuthenticationToken || auth.getPrincipal() == null || !(auth.getPrincipal() instanceof CrowdUserDetails)) {
            this.authenticated = false;
            this.remoteUser = null;
        } else {
            this.authenticated = true;
            CrowdUserDetails userDetails = (CrowdUserDetails)auth.getPrincipal();
            this.remoteUser = userDetails.getRemotePrincipal();
            String adminRole = this.crowdUserDetailsService.getAuthorityPrefix() + this.crowdUserDetailsService.getAuthoritySuffix();
            for (int i = 0; i < userDetails.getAuthorities().length; ++i) {
                if (!userDetails.getAuthorities()[i].getAuthority().equals(adminRole)) continue;
                this.admin = true;
                break;
            }
        }
    }

    public boolean isAuthenticated() {
        if (this.isSetupComplete() && this.authenticated == null) {
            this.updateAuthenticationStatus();
        } else if (!this.isSetupComplete()) {
            this.authenticated = Boolean.FALSE;
        }
        return this.authenticated;
    }

    public boolean isAdmin() {
        if (!this.isAuthenticated()) {
            this.admin = false;
        } else if (this.admin == null) {
            this.updateAuthenticationStatus();
        }
        return this.admin;
    }

    public String getSitemeshPageProperty(String propertyName) {
        String property = null;
        Map<String, Object> properties = this.getSitemeshPageProperties();
        if (properties != null) {
            property = (String)properties.get(propertyName);
        }
        return property;
    }

    public Map<String, Object> getSitemeshPageProperties() {
        Page page;
        PageContext pageContext;
        if (this.siteMeshProperties == null && (pageContext = ServletActionContext.getPageContext()) != null && (page = (Page)pageContext.getAttribute("sitemeshPage")) != null) {
            this.siteMeshProperties = page.getProperties();
        }
        return this.siteMeshProperties;
    }

    public String getUserName() throws InvalidUserException {
        if (!this.isAuthenticated()) {
            return null;
        }
        String userName = "";
        if (this.getRemoteUser() != null) {
            String firstName = this.getFirstAttribute("givenName");
            String lastName = this.getFirstAttribute("sn");
            if (TextUtils.stringSet((String)firstName)) {
                userName = firstName;
            }
            if (TextUtils.stringSet((String)lastName)) {
                if (TextUtils.stringSet((String)userName) && userName.length() > 0) {
                    userName = userName + " ";
                }
                userName = userName + lastName;
            }
            if (!TextUtils.stringSet((String)userName)) {
                userName = this.getRemoteUser().getName();
            }
        }
        return userName;
    }

    public SOAPPrincipal getRemoteUser() {
        if (!this.isAuthenticated()) {
            return null;
        }
        if (this.remoteUser == null) {
            this.updateAuthenticationStatus();
        }
        return this.remoteUser;
    }

    public SOAPAttribute getAttribute(String name) throws InvalidUserException {
        if (!this.isAuthenticated()) {
            return null;
        }
        SOAPPrincipal remotePrincipal = this.getRemoteUser();
        SOAPAttribute[] attributes = remotePrincipal.getAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].getName().equals(name)) continue;
            return attributes[i];
        }
        SOAPAttribute soapAttribute = new SOAPAttribute();
        soapAttribute.setName(name);
        return soapAttribute;
    }

    public String getFirstAttribute(String name) throws InvalidUserException {
        SOAPAttribute attribute = this.getAttribute(name);
        if (attribute == null || attribute.getValues() == null) {
            return null;
        }
        if (attribute.getValues().length > 0) {
            return attribute.getValues()[0];
        }
        return null;
    }

    protected HttpSession getSession() {
        return ServletActionContext.getRequest().getSession();
    }

    protected HttpServletRequest getHttpRequest() {
        return ServletActionContext.getRequest();
    }

    public Integer getTab() {
        return this.tab;
    }

    public void setTab(Integer tab) {
        this.tab = tab;
    }

    public boolean isInitialLoad() {
        return this.initialLoad;
    }

    public CrowdLicense getLicense() {
        return this.crowdLicenseManager.getLicense();
    }

    public boolean isEvaluation() {
        return this.isSetupComplete() && this.getLicense().isEvaluation();
    }

    public boolean isSubscription() {
        return this.isSetupComplete() && this.getLicense().isSubscription();
    }

    private boolean isSetupComplete() {
        return this.getBootstrapManager().isSetupComplete();
    }

    public boolean isWithinGracePeriod() {
        return this.isSetupComplete() && this.getLicense().isWithinGracePeriod();
    }

    public boolean isLicenseExpired() {
        return this.isSetupComplete() && this.getLicense().isExpired();
    }

    public String getActionMessageAlertColor() {
        if (StringUtils.isEmpty((String)this.actionMessageAlertColor)) {
            return ALERT_YELLOW;
        }
        return this.actionMessageAlertColor;
    }

    public void addActionMessage(String color, String message) {
        this.actionMessageAlertColor = color;
        this.addActionMessage(message);
    }

    public List getWebItemsForSection(String sectionName) {
        return this.webInterfaceManager.getDisplayableItems(sectionName, this.getWebFragmentsContextMap());
    }

    public List getWebSectionsForLocation(String location) {
        return this.webInterfaceManager.getDisplayableSections(location, this.getWebFragmentsContextMap());
    }

    public String renderFreemarkerTemplate(String templateString) {
        return this.webInterfaceManager.getWebFragmentHelper().renderVelocityFragment(templateString, this.getWebFragmentsContextMap());
    }

    public Map<String, Object> getWebFragmentsContextMap() {
        Map<String, Object> siteMeshProperties;
        if (this.webFragmentsContextMap == null) {
            Map map = (Map)ServletActionContext.getContext().get((Object)"com.opensymphony.xwork.ActionContext.parameters");
            this.webFragmentsContextMap = new HashMap<String, Object>();
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof String[]) {
                    String[] strArray = (String[])value;
                    this.webFragmentsContextMap.put(key.toString(), strArray[0]);
                    continue;
                }
                this.webFragmentsContextMap.put(key.toString(), value);
            }
        }
        if ((siteMeshProperties = this.getSitemeshPageProperties()) != null && !siteMeshProperties.isEmpty()) {
            this.webFragmentsContextMap.putAll(siteMeshProperties);
        }
        return this.webFragmentsContextMap;
    }

    public String getDisplayableLink(WebLink link) {
        return link.getDisplayableUrl(this.getHttpRequest(), this.getWebFragmentsContextMap());
    }

    public String getLink(WebLink link) {
        return link.getDisplayableUrl(this.getHttpRequest(), Collections.EMPTY_MAP);
    }

    public Directory directory(long directoryID) {
        try {
            return this.directoryManager.findDirectoryById(directoryID);
        }
        catch (Exception e) {
            this.logger.warn((Object)e.getMessage(), (Throwable)e);
            this.addActionError(e.getMessage());
            return null;
        }
    }

    public boolean containsErrorMessages() {
        return this.getActionErrors() != null && !this.getActionErrors().isEmpty();
    }

    public boolean containsActionMessages() {
        return this.getActionMessages() != null && !this.getActionMessages().isEmpty();
    }

    public void setPropertyManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    public void setCrowdLicenseManager(CrowdLicenseManager crowdLicenseManager) {
        this.crowdLicenseManager = crowdLicenseManager;
    }

    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager = applicationManager;
    }

    public void setCrowdUserDetailsService(CrowdUserDetailsService crowdUserDetailsService) {
        this.crowdUserDetailsService = crowdUserDetailsService;
    }

    public void setWebInterfaceManager(WebInterfaceManager webInterfaceManager) {
        this.webInterfaceManager = webInterfaceManager;
    }

    public WebInterfaceManager getWebInterfaceManager() {
        return this.webInterfaceManager;
    }

    public WebResourceManager getWebResourceManager() {
        return this.webResourceManager;
    }

    public void setWebResourceManager(WebResourceManager webResourceManager) {
        this.webResourceManager = webResourceManager;
    }

    protected CrowdBootstrapManager getBootstrapManager() {
        return (CrowdBootstrapManager)BootstrapUtils.getBootstrapManager();
    }

    public boolean isAtResourceLimit() {
        return this.crowdLicenseManager.isResourceTotalOverLimit(90.0f, this.getCurrentLicenseResourceTotal());
    }

    public Integer getCurrentLicenseResourceTotal() {
        if (this.currentLicenseResourceTotal == null || this.currentLicenseResourceTotal == 0) {
            this.currentLicenseResourceTotal = new Integer(this.propertyManager.getCurrentLicenseResourceTotal());
        }
        return this.currentLicenseResourceTotal;
    }

    public String getImageTitle(boolean active, ApplicationType applicationType) {
        String imageI8n = "application." + applicationType.toString().toLowerCase() + (active ? ".enabled" : ".disabled");
        return this.getText(imageI8n);
    }

    public String getImageLocation(boolean active, ApplicationType applicationType) {
        return ServletActionContext.getRequest().getContextPath() + DEFAULT_IMAGE_LOCATION + applicationType.toString().toLowerCase() + (active ? "" : "_disabled") + ICON_IMAGE_TYPE;
    }

    protected boolean authorisedToAccessCrowdConsole(Long directoryId, String name) throws ObjectNotFoundException, DirectoryAccessException {
        List<Application> authorisedApplications = this.applicationService.findAuthorisedApplications(this.directoryManager.findUserByName(directoryId, name));
        String crowdConsoleName = this.getText("application.name").toLowerCase();
        boolean authorised = false;
        for (int i = 0; i < authorisedApplications.size() && !authorised; ++i) {
            Application application = authorisedApplications.get(i);
            if (!application.getName().equals(crowdConsoleName)) continue;
            authorised = true;
        }
        return authorised;
    }

    protected boolean authorisedToAccessCrowdAdminConsole(DirectoryMapping directoryMapping, Long directoryId, String username) throws ObjectNotFoundException, DirectoryAccessException {
        boolean allowAllToAuthenticate = directoryMapping.isAllowAllToAuthenticate();
        directoryMapping.setAllowAllToAuthenticate(false);
        boolean hasAdminAccess = this.authorisedToAccessCrowdConsole(directoryId, username);
        directoryMapping.setAllowAllToAuthenticate(allowAllToAuthenticate);
        return hasAdminAccess;
    }

    public void setApplicationService(ApplicationService applicationService) {
        this.applicationService = applicationService;
    }

    public String getText(String i18nKey, List args, boolean encode) {
        if (encode) {
            args = Lists.transform((List)args, (Function)new Function(){

                public Object apply(Object from) {
                    return from instanceof String ? TextUtils.htmlEncode((String)((String)from)) : from;
                }
            });
        }
        return super.getText(i18nKey, args);
    }

    public String getText(String i18nKey, List args) {
        return this.getText(i18nKey, args, true);
    }
}

