/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration.legacy.database;

import com.atlassian.crowd.integration.model.InternalEntityTemplate;
import com.atlassian.crowd.integration.model.group.Group;
import com.atlassian.crowd.integration.model.group.GroupTemplate;
import com.atlassian.crowd.integration.model.group.GroupType;
import com.atlassian.crowd.integration.model.group.InternalGroup;
import com.atlassian.crowd.integration.model.group.InternalGroupWithAttributes;
import com.atlassian.crowd.integration.model.membership.InternalMembership;
import com.atlassian.crowd.integration.model.membership.MembershipType;
import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.legacy.LegacyImportDataHolder;
import com.atlassian.crowd.migration.legacy.database.DatabaseImporter;
import com.atlassian.crowd.migration.legacy.database.DatabaseMapper;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.model.directory.DirectoryDAOHibernate;
import com.atlassian.crowd.model.group.GroupDAOHibernate;
import com.atlassian.crowd.model.membership.MembershipDAOHibernate;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchResult;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchResultWithIdReferences;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.SessionFactory;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleMapper
extends DatabaseMapper
implements DatabaseImporter {
    private final GroupDAOHibernate groupDAO;
    private final MembershipDAOHibernate membershipDAO;
    private final DirectoryDAOHibernate directoryDAO;

    public RoleMapper(SessionFactory sessionFactory, BatchProcessor batchProcessor, JdbcOperations jdbcTemplate, GroupDAOHibernate groupDAO, MembershipDAOHibernate membershipDAO, DirectoryDAOHibernate directoryDAO) {
        super(sessionFactory, batchProcessor, jdbcTemplate);
        this.groupDAO = groupDAO;
        this.membershipDAO = membershipDAO;
        this.directoryDAO = directoryDAO;
    }

    @Override
    public void importFromDatabase(LegacyImportDataHolder importData) throws ImportException {
        List<InternalGroupWithAttributes> roles = this.importRolesFromDatabase(importData.getOldToNewDirectoryIds());
        BatchResultWithIdReferences roleImportResults = this.groupDAO.addAll(roles);
        for (Group role : roleImportResults.getFailedEntities()) {
            this.logger.error((Object)("Unable to add role <" + role.getName() + "> in directory with id <" + role.getDirectoryId() + ">"));
        }
        if (roleImportResults.hasFailures()) {
            throw new ImportException("Unable to import all roles. See logs for more details.");
        }
        Set<InternalMembership> memberships = this.importMembershipsFromDatabase(importData, (BatchResultWithIdReferences<Group>)roleImportResults);
        BatchResult membershipResult = this.membershipDAO.addAll(memberships);
        for (InternalMembership membership : membershipResult.getFailedEntities()) {
            this.logger.error((Object)("Unable to add user <" + membership.getChildName() + "> to role <" + membership.getParentName() + "> in directory with id <" + membership.getDirectory().getId() + ">"));
        }
        if (membershipResult.hasFailures()) {
            throw new ImportException("Unable to import all memberships. See logs for more details.");
        }
        this.logger.info((Object)("Successfully migrated " + roleImportResults.getTotalSuccessful() + " roles, with " + memberships.size() + " memberships."));
    }

    protected List<InternalGroupWithAttributes> importRolesFromDatabase(Map<Long, Long> oldToNewDirectoryIds) {
        ArrayList<InternalGroupWithAttributes> internalRolesWithAttributes = new ArrayList<InternalGroupWithAttributes>();
        RoleTableMapper roleTableMapper = new RoleTableMapper(oldToNewDirectoryIds);
        Map<InternalGroup, Long> roleToOldDirectoryId = roleTableMapper.getRoleToOldDirectoryIds();
        List<InternalGroup> roles = this.getRoles(roleTableMapper);
        Map<DatabaseMapper.EntityIdentifier, Map<String, List<String>>> allRoleAttributes = this.getRoleAttributes();
        for (InternalGroup role : roles) {
            DatabaseMapper.EntityIdentifier currentRole = new DatabaseMapper.EntityIdentifier(roleToOldDirectoryId.get(role), role.getName());
            Map<String, List<String>> attributes = allRoleAttributes.get(currentRole);
            if (attributes == null) {
                attributes = new HashMap<String, List<String>>();
            }
            internalRolesWithAttributes.add(new InternalGroupWithAttributes(role, attributes));
        }
        return internalRolesWithAttributes;
    }

    private List<InternalGroup> getRoles(RoleTableMapper roleTableMapper) {
        return this.jdbcTemplate.query(this.legacyTableQueries.getRolesSQL(), (RowMapper)roleTableMapper);
    }

    private Map<DatabaseMapper.EntityIdentifier, Map<String, List<String>>> getRoleAttributes() {
        DatabaseMapper.AttributeMapper roleAttributeMapper = new DatabaseMapper.AttributeMapper("REMOTEROLEDIRECTORYID", "REMOTEROLENAME");
        this.jdbcTemplate.query(this.legacyTableQueries.getRoleAttributesSQL(), (RowCallbackHandler)roleAttributeMapper);
        roleAttributeMapper.getEntityAttributes();
        Map<DatabaseMapper.EntityIdentifier, List<Map<String, String>>> roleAttributes = roleAttributeMapper.getEntityAttributes();
        HashMap<DatabaseMapper.EntityIdentifier, Map<String, List<String>>> roleAttributeMap = new HashMap<DatabaseMapper.EntityIdentifier, Map<String, List<String>>>();
        for (Map.Entry<DatabaseMapper.EntityIdentifier, List<Map<String, String>>> entry : roleAttributes.entrySet()) {
            roleAttributeMap.put(entry.getKey(), this.attributeListToMultiAttributeMap(entry.getValue()));
        }
        return roleAttributeMap;
    }

    protected Set<InternalMembership> importMembershipsFromDatabase(LegacyImportDataHolder importData, BatchResultWithIdReferences<Group> roleImportResults) {
        MembershipTableMapper membershipTableMapper = new MembershipTableMapper(importData, roleImportResults);
        List memberships = this.jdbcTemplate.query(this.legacyTableQueries.getRoleMembershipsSQL(), (RowMapper)membershipTableMapper);
        return new HashSet<InternalMembership>(memberships);
    }

    private class MembershipTableMapper
    implements RowMapper {
        private final LegacyImportDataHolder importData;
        private final BatchResultWithIdReferences roleImportResults;

        public MembershipTableMapper(LegacyImportDataHolder importData, BatchResultWithIdReferences roleImportResults) {
            this.importData = importData;
            this.roleImportResults = roleImportResults;
        }

        public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
            String parentName = rs.getString("REMOTEROLENAME");
            String childName = rs.getString("REMOTEPRINCIPALNAME");
            Long oldDirectoryId = rs.getLong("REMOTEROLEDIRECTORYID");
            Long directoryId = this.importData.getOldToNewDirectoryIds().get(oldDirectoryId);
            if (directoryId == null) {
                throw new IllegalArgumentException("Role belongs to an unknown old directory with ID: " + directoryId);
            }
            Directory directory = (Directory)RoleMapper.this.directoryDAO.loadReference(directoryId.longValue());
            Long roleId = this.roleImportResults.getIdReference(directoryId, parentName);
            Long userId = this.importData.getUserImportResults().getIdReference(directoryId, childName);
            return new InternalMembership(null, roleId, userId, MembershipType.GROUP_USER, GroupType.LEGACY_ROLE, parentName, childName, directory);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RoleTableMapper
    implements RowMapper {
        private final Map<Long, Long> oldToNewDirectoryIds;
        private final Map<InternalGroup, Long> roleToOldDirectoryIds = new HashMap<InternalGroup, Long>();

        public RoleTableMapper(Map<Long, Long> oldToNewDirectoryIds) {
            this.oldToNewDirectoryIds = oldToNewDirectoryIds;
        }

        public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
            Long oldDirectoryId = rs.getLong("DIRECTORYID");
            String roleName = rs.getString("NAME");
            boolean active = rs.getBoolean("ACTIVE");
            Date createDate = RoleMapper.this.getDateFromDatabase(rs.getString("CONCEPTION"));
            Date updatedDate = RoleMapper.this.getDateFromDatabase(rs.getString("LASTMODIFIED"));
            String description = rs.getString("DESCRIPTION");
            GroupType groupType = GroupType.LEGACY_ROLE;
            Long directoryId = this.oldToNewDirectoryIds.get(oldDirectoryId);
            if (directoryId == null) {
                throw new IllegalArgumentException("Role belongs to an unknown old directory with ID: " + directoryId);
            }
            Directory directory = (Directory)RoleMapper.this.directoryDAO.loadReference(directoryId.longValue());
            InternalEntityTemplate internalEntityTemplate = RoleMapper.this.createInternalEntityTemplate(directoryId, roleName, createDate, updatedDate, active);
            internalEntityTemplate.setId(null);
            GroupTemplate roleTemplate = new GroupTemplate(internalEntityTemplate.getName(), directoryId, groupType);
            roleTemplate.setActive(internalEntityTemplate.isActive());
            roleTemplate.setDescription(description);
            InternalGroup role = new InternalGroup(internalEntityTemplate, directory, roleTemplate);
            this.roleToOldDirectoryIds.put(role, oldDirectoryId);
            return role;
        }

        public Map<InternalGroup, Long> getRoleToOldDirectoryIds() {
            return this.roleToOldDirectoryIds;
        }
    }
}

