/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration.legacy.database;

import com.atlassian.crowd.integration.model.InternalEntityTemplate;
import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.legacy.LegacyImportDataHolder;
import com.atlassian.crowd.migration.legacy.database.DatabaseImporter;
import com.atlassian.crowd.migration.legacy.database.DatabaseMapper;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.model.directory.DirectoryType;
import com.atlassian.crowd.model.directory.OperationType;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.SessionFactory;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryMapper
extends DatabaseMapper
implements DatabaseImporter {
    public DirectoryMapper(SessionFactory sessionFactory, BatchProcessor batchProcessor, JdbcOperations jdbcTemplate) {
        super(sessionFactory, batchProcessor, jdbcTemplate);
    }

    @Override
    public void importFromDatabase(LegacyImportDataHolder importData) throws ImportException {
        this.importDirectoriesFromDatabase(importData.getOldToNewDirectoryIds());
    }

    protected List<Directory> importDirectoriesFromDatabase(Map<Long, Long> oldToNewDirectoryIds) throws ImportException {
        DirectoryTableMapper directoryTableMapper = new DirectoryTableMapper();
        List<Directory> directories = this.getDirectories(directoryTableMapper);
        Map<Directory, Long> directoryIdMap = directoryTableMapper.getDirectoryIdMap();
        Map<Long, List<Map<String, String>>> allDirectoryAttributes = this.getDirectoryAttributes();
        Map<Long, Set<OperationType>> allDirectoryOperations = this.getDirectoryOperations();
        for (Directory directory : directories) {
            Long oldDirectoryId = directoryIdMap.get(directory);
            Set<OperationType> allowedOperations = allDirectoryOperations.get(oldDirectoryId);
            if (allowedOperations == null) {
                allowedOperations = new HashSet<OperationType>();
            }
            directory.setAllowedOperations(allowedOperations);
            Map<String, String> directoryAttributes = this.attributeListToMap(allDirectoryAttributes.get(oldDirectoryId));
            directory.setAttributes(directoryAttributes);
            try {
                Directory addedDirectory = (Directory)this.addEntityViaMerge(directory);
                long newDirectoryId = addedDirectory.getId();
                oldToNewDirectoryIds.put(oldDirectoryId, newDirectoryId);
            }
            catch (ImportException e) {
                this.logger.error((Object)"Error adding directory entity via merge", (Throwable)e);
            }
        }
        this.logger.info((Object)("Successfully migrated " + directories.size() + " directories."));
        return directories;
    }

    private List<Directory> getDirectories(DirectoryTableMapper directoryTableMapper) {
        return this.jdbcTemplate.query(this.legacyTableQueries.getDirectoriesSQL(), (RowMapper)directoryTableMapper);
    }

    private Map<Long, Set<OperationType>> getDirectoryOperations() {
        DirectoryOperationMapper directoryOperationMapper = new DirectoryOperationMapper();
        this.jdbcTemplate.query(this.legacyTableQueries.getDirectoryOperationsSQL(), (RowCallbackHandler)directoryOperationMapper);
        return directoryOperationMapper.getAllDirectoryOperations();
    }

    private Map<Long, List<Map<String, String>>> getDirectoryAttributes() {
        DirectoryAttributeMapper directoryAttributeMapper = new DirectoryAttributeMapper();
        this.jdbcTemplate.query(this.legacyTableQueries.getDirectoryAttributesSQL(), (RowCallbackHandler)directoryAttributeMapper);
        return directoryAttributeMapper.getDirectoryAttributes();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DirectoryOperationMapper
    implements RowCallbackHandler {
        private final Map<Long, Set<OperationType>> allDirectoryOperations = new HashMap<Long, Set<OperationType>>();

        private DirectoryOperationMapper() {
        }

        public void processRow(ResultSet rs) throws SQLException {
            Long directoryId = rs.getLong("DIRECTORYID");
            String operationType = rs.getString("KEY");
            if (!this.allDirectoryOperations.containsKey(directoryId)) {
                this.allDirectoryOperations.put(directoryId, new HashSet());
            }
            this.allDirectoryOperations.get(directoryId).add(DirectoryMapper.this.getOperationTypeFromLegacyPermissionName(operationType));
        }

        public Map<Long, Set<OperationType>> getAllDirectoryOperations() {
            return this.allDirectoryOperations;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DirectoryAttributeMapper
    implements RowCallbackHandler {
        private final Map<Long, List<Map<String, String>>> directoryAttributes = new HashMap<Long, List<Map<String, String>>>();

        private DirectoryAttributeMapper() {
        }

        public void processRow(ResultSet rs) throws SQLException {
            String attributeName = rs.getString("ATTRIBUTE");
            String attributeValue = rs.getString("VALUE");
            Long directoryId = rs.getLong("DIRECTORYID");
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put(attributeName, attributeValue);
            if (!this.directoryAttributes.containsKey(directoryId)) {
                this.directoryAttributes.put(directoryId, new ArrayList());
            }
            this.directoryAttributes.get(directoryId).add(attributes);
        }

        public Map<Long, List<Map<String, String>>> getDirectoryAttributes() {
            return this.directoryAttributes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DirectoryTableMapper
    implements RowMapper {
        private final Map<Directory, Long> directoryIdMap = new HashMap<Directory, Long>();

        private DirectoryTableMapper() {
        }

        public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
            Long oldDirectoryid = rs.getLong("ID");
            String directoryName = rs.getString("NAME");
            boolean active = rs.getBoolean("ACTIVE");
            Date createdDate = DirectoryMapper.this.getDateFromDatabase(rs.getString("CONCEPTION"));
            Date updatedDate = DirectoryMapper.this.getDateFromDatabase(rs.getString("LASTMODIFIED"));
            String description = rs.getString("DESCRIPTION");
            String implementationClass = rs.getString("IMPLEMENTATIONCLASS");
            DirectoryType directoryType = DirectoryMapper.this.getDirectoryTypeFromLegacyCode(Integer.parseInt(rs.getString("CODE")));
            InternalEntityTemplate template = DirectoryMapper.this.createInternalEntityTemplate(oldDirectoryid, directoryName, createdDate, updatedDate, active);
            template.setId(null);
            Directory directory = new Directory(template);
            directory.setDescription(description);
            directory.setImplementationClass(implementationClass);
            directory.setType(directoryType);
            this.directoryIdMap.put(directory, oldDirectoryid);
            return directory;
        }

        public Map<Directory, Long> getDirectoryIdMap() {
            return this.directoryIdMap;
        }
    }
}

