/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration;

import com.atlassian.crowd.event.XMLRestoreFinishedEvent;
import com.atlassian.crowd.event.XMLRestoreStartedEvent;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationManagerException;
import com.atlassian.crowd.manager.application.CrowdApplicationPasswordManager;
import com.atlassian.crowd.migration.ExportException;
import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.XmlMigrationManager;
import com.atlassian.crowd.migration.XmlMigrator;
import com.atlassian.crowd.migration.legacy.LegacyXmlMigrator;
import com.atlassian.crowd.migration.verify.VerificationManager;
import com.atlassian.crowd.upgrade.UpgradeManager;
import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.crowd.util.persistence.hibernate.ResetableHiLoGeneratorHelper;
import com.atlassian.crowd.util.persistence.hibernate.ResettableTableHiLoGenerator;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.config.JohnsonConfig;
import com.atlassian.spring.container.ContainerManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import net.sf.ehcache.CacheManager;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.persister.entity.EntityPersister;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.web.context.ServletContextAware;

public class XmlMigrationManagerImpl
implements XmlMigrationManager,
ServletContextAware {
    private final Logger logger = Logger.getLogger(this.getClass());
    private SessionFactory sessionFactory;
    private XmlMigrator xmlMigrator;
    private LegacyXmlMigrator legacyXmlMigrator;
    private UpgradeManager upgradeManager;
    private ResetableHiLoGeneratorHelper resetableHiLoGeneratorHelper;
    private EventManager eventManager;
    private CrowdApplicationPasswordManager crowdApplicationPasswordManager;
    private CacheManager cacheManager;
    private ServletContext servletContext;
    private I18nHelper i18nHelper;
    private VerificationManager verificationManager;
    public static final String XML_ROOT = "crowd";
    public static final String CROWD_XML_VERSION = "version";
    public static final String CROWD_XML_DATE = "creationDate";
    public static final String CROWD_XML_BUILD_NUMBER = "buildNumber";
    public static final String CROWD_XML_BUILD_DATE = "buildDate";
    public static final String OPTION_RESET_DOMAIN = "OPTION_RESET_DOMAIN";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized long exportXml(String path, Map options) throws ExportException {
        long startTime = System.currentTimeMillis();
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(XML_ROOT);
        root.addElement(CROWD_XML_DATE).addText(new Date().toString());
        root.addElement(CROWD_XML_VERSION).addText("2.0.7");
        root.addElement(CROWD_XML_BUILD_NUMBER).addText("416");
        root.addElement(CROWD_XML_BUILD_DATE).addText("13-08-2010");
        this.xmlMigrator.exportXml(root, options);
        File exportFile = new File(path);
        if (exportFile.getParentFile() != null) {
            exportFile.getParentFile().mkdirs();
        }
        OutputStreamWriter xmlOut = null;
        XMLWriter writer = null;
        try {
            xmlOut = new OutputStreamWriter((OutputStream)new FileOutputStream(exportFile), "UTF-8");
            writer = new XMLWriter((Writer)xmlOut, OutputFormat.createPrettyPrint());
            writer.write(document);
            writer.close();
            xmlOut.close();
        }
        catch (IOException e) {
            try {
                throw new ExportException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(xmlOut);
                try {
                    if (writer == null) throw throwable;
                    writer.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)xmlOut);
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException e) {}
        long timeTaken = System.currentTimeMillis() - startTime;
        this.logger.info((Object)("Time taken to export (millis): " + timeTaken));
        return timeTaken;
    }

    public synchronized long importXml(String path) throws ImportException {
        long startTime = System.currentTimeMillis();
        File importFile = new File(path);
        if (!importFile.exists()) {
            this.logger.warn((Object)"The import file does not exist. Import halted.");
            throw new ImportException("The file specified: " + path + " does not exist");
        }
        this.eventManager.publishEvent((Event)new XMLRestoreStartedEvent((Object)this));
        SAXReader reader = new SAXReader();
        Document document = null;
        try {
            document = reader.read(path);
        }
        catch (DocumentException e) {
            throw new ImportException((Exception)((Object)e));
        }
        Element root = document.getRootElement();
        this.verificationManager.validate(document);
        this.cleanDatabase();
        this.clearCaches();
        boolean legacyImport = this.isLegacyImport(root);
        if (legacyImport) {
            this.legacyXmlMigrator.importXml(root);
        } else {
            this.xmlMigrator.importXml(root);
        }
        this.resetIdentifierGenerators();
        this.flushAndClearHibernateSession();
        this.clearCaches();
        try {
            this.crowdApplicationPasswordManager.resetCrowdPasswordIfRequired();
        }
        catch (ObjectNotFoundException e) {
            throw new ImportException((Exception)((Object)e));
        }
        catch (ApplicationManagerException e) {
            throw new ImportException((Exception)((Object)e));
        }
        boolean notInError = this.performUpgrades();
        if (notInError) {
            this.eventManager.publishEvent((Event)new XMLRestoreFinishedEvent((Object)this));
        }
        long timeTaken = System.currentTimeMillis() - startTime;
        this.logger.info((Object)("Time taken to import (millis): " + timeTaken));
        return timeTaken;
    }

    private boolean isLegacyImport(Element root) {
        Element versionElement = (Element)root.selectSingleNode("/crowd/ version");
        String version = versionElement.getText();
        boolean isLegacyImport = version.startsWith("0.") || version.startsWith("1.");
        return isLegacyImport;
    }

    private boolean performUpgrades() {
        boolean notInError = true;
        Exception upgradeException = null;
        Collection errors = null;
        try {
            errors = this.upgradeManager.doUpgrade();
        }
        catch (Exception e) {
            upgradeException = e;
        }
        if (upgradeException != null || CollectionUtils.isNotEmpty((Collection)errors)) {
            JohnsonEventContainer agentJohnson = JohnsonEventContainer.get((ServletContext)this.servletContext);
            JohnsonConfig johnsonConfig = JohnsonConfig.getInstance();
            String errorMessage = this.i18nHelper.getText("xmlmigration.import.error");
            if (upgradeException != null) {
                agentJohnson.addEvent(new com.atlassian.johnson.event.Event(johnsonConfig.getEventType("import"), errorMessage, upgradeException.getMessage(), johnsonConfig.getEventLevel("fatal")));
            }
            if (CollectionUtils.isNotEmpty((Collection)errors)) {
                for (String error : errors) {
                    agentJohnson.addEvent(new com.atlassian.johnson.event.Event(johnsonConfig.getEventType("import"), errorMessage, error, johnsonConfig.getEventLevel("fatal")));
                }
            }
            notInError = false;
        }
        return notInError;
    }

    protected void clearCaches() {
        this.cacheManager.clearAll();
    }

    protected void flushAndClearHibernateSession() {
        this.sessionFactory.getCurrentSession().flush();
        this.sessionFactory.getCurrentSession().clear();
    }

    protected void cleanDatabase() {
        Session s = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)false);
        if (s != null) {
            try {
                s.flush();
                s.connection().commit();
            }
            catch (HibernateException he) {
                this.logger.error((Object)"error flushing session", (Throwable)he);
            }
            catch (SQLException sqle) {
                this.logger.error((Object)"error commiting connection", (Throwable)sqle);
            }
        }
        this.deleteDatabase();
        if (s != null) {
            try {
                s.flush();
                s.connection().commit();
                s.clear();
            }
            catch (HibernateException he) {
                this.logger.error((Object)"error flushing session", (Throwable)he);
            }
            catch (SQLException sqle) {
                this.logger.error((Object)"error commiting connection", (Throwable)sqle);
            }
        }
    }

    private void deleteDatabase() throws HibernateException {
        LocalSessionFactoryBean sessionFactory = (LocalSessionFactoryBean)ContainerManager.getComponent((String)"&sessionFactory");
        if (sessionFactory != null) {
            sessionFactory.dropDatabaseSchema();
            sessionFactory.createDatabaseSchema();
        }
    }

    protected void resetIdentifierGenerators() throws ImportException {
        Map metadata = this.sessionFactory.getAllClassMetadata();
        Iterator it = metadata.keySet().iterator();
        while (it.hasNext()) {
            EntityPersister persister = ((SessionFactoryImplementor)this.sessionFactory).getEntityPersister((String)it.next());
            IdentifierGenerator idGen = persister.getIdentifierGenerator();
            if (!(idGen instanceof ResettableTableHiLoGenerator)) continue;
            ((ResettableTableHiLoGenerator)idGen).reset();
        }
        ArrayList errors = new ArrayList();
        try {
            this.resetableHiLoGeneratorHelper.setNextHiValue(errors);
        }
        catch (Throwable e) {
            this.logger.error((Object)"Error adjusting the hibernat_unique_key.next_hi value", e);
        }
        if (!errors.isEmpty()) {
            StringBuffer errorMessages = new StringBuffer();
            errorMessages.append("The following errors were thrown: \n");
            for (Object error : errors) {
                errorMessages.append(error.toString()).append("\n");
            }
            throw new ImportException(errorMessages.toString());
        }
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setResetableHiLoGeneratorHelper(ResetableHiLoGeneratorHelper resetableHiLoGeneratorHelper) {
        this.resetableHiLoGeneratorHelper = resetableHiLoGeneratorHelper;
    }

    public void setUpgradeManager(UpgradeManager upgradeManager) {
        this.upgradeManager = upgradeManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void setXmlMigrator(XmlMigrator xmlMigrator) {
        this.xmlMigrator = xmlMigrator;
    }

    public void setLegacyXmlMigrator(LegacyXmlMigrator legacyXmlMigrator) {
        this.legacyXmlMigrator = legacyXmlMigrator;
    }

    public void setCrowdApplicationPasswordManager(CrowdApplicationPasswordManager crowdApplicationPasswordManager) {
        this.crowdApplicationPasswordManager = crowdApplicationPasswordManager;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setI18nHelper(I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
    }

    public void setVerificationManager(VerificationManager verificationManager) {
        this.verificationManager = verificationManager;
    }
}

