/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.hibernate.batch;

import com.atlassian.crowd.integration.model.DirectoryEntity;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchResult;
import com.atlassian.crowd.util.persistence.hibernate.batch.operation.HibernateOperation;
import com.atlassian.crowd.util.persistence.hibernate.batch.operation.MergeOperation;
import com.atlassian.crowd.util.persistence.hibernate.batch.operation.ReplicateOperation;
import com.atlassian.crowd.util.persistence.hibernate.batch.operation.SaveOrUpdateOperation;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.ReplicationMode;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchProcessorImpl
implements BatchProcessor {
    private static final Logger logger = Logger.getLogger(BatchProcessorImpl.class);
    private final SessionFactory sessionFactory;
    private int batchSize = 20;

    public BatchProcessorImpl(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public <E extends Serializable> BatchResult<E> replicate(Collection<E> objects, ReplicationMode replicationMode) {
        return this.processCollection(objects, new ReplicateOperation(replicationMode));
    }

    public <E extends Serializable> BatchResult<E> merge(Collection<E> objects) {
        return this.processCollection(objects, new MergeOperation());
    }

    public <E extends Serializable> BatchResult<E> saveOrUpdate(Collection<E> objects) {
        return this.processCollection(objects, new SaveOrUpdateOperation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends DirectoryEntity> Collection<E> find(long directoryID, Collection<String> names, Class<E> persistentClass) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Attempting to find " + names.size() + " objects of class " + persistentClass.getName()));
        }
        Session session = this.sessionFactory.openSession();
        try {
            session.setFlushMode(FlushMode.MANUAL);
            session.setCacheMode(CacheMode.IGNORE);
            ArrayList<E> results = new ArrayList<E>();
            ArrayList<String> nameBatch = new ArrayList<String>(this.batchSize);
            for (String name : names) {
                nameBatch.add(name);
                if (nameBatch.size() != this.batchSize) continue;
                results.addAll(this.processBatchFind((org.hibernate.Session)session, directoryID, nameBatch, persistentClass));
                nameBatch.clear();
            }
            if (!nameBatch.isEmpty()) {
                results.addAll(this.processBatchFind((org.hibernate.Session)session, directoryID, nameBatch, persistentClass));
                nameBatch.clear();
            }
            ArrayList<E> arrayList = results;
            return arrayList;
        }
        finally {
            session.close();
        }
    }

    public <E extends DirectoryEntity> Collection<E> processBatchFind(org.hibernate.Session session, long directoryID, Collection<String> names, Class<E> persistentClass) {
        Collection lowercaseNames = Collections2.transform(names, (Function)new Function<String, String>(){

            public String apply(String from) {
                return from.toLowerCase();
            }
        });
        List result = session.createCriteria(persistentClass).add((Criterion)Restrictions.eq((String)"directory.id", (Object)directoryID)).add(Restrictions.in((String)"lowerName", (Collection)lowercaseNames)).list();
        session.clear();
        return result;
    }

    private <E extends Serializable> BatchResult<E> processCollection(Collection<E> objects, HibernateOperation op) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Attempting to add " + objects.size() + " objects via multiple batches"));
        }
        BatchResult result = new BatchResult((long)objects.size());
        Session session = this.sessionFactory.openSession();
        ArrayList<Serializable> batch = new ArrayList<Serializable>(this.batchSize);
        long count = 0L;
        for (Serializable object : objects) {
            ++count;
            if (logger.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer();
                sb.append("Adding '").append(object.toString()).append("' to batch (").append(count).append("/").append(objects.size()).append(")");
                logger.debug((Object)sb.toString());
            }
            batch.add(object);
            if (batch.size() != this.batchSize) continue;
            this.processBatch(batch, (org.hibernate.Session)session, op, result);
            batch.clear();
        }
        if (!batch.isEmpty()) {
            this.processBatch(batch, (org.hibernate.Session)session, op, result);
            batch.clear();
        }
        session.close();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends Serializable> void processBatch(List<E> objects, org.hibernate.Session session, HibernateOperation op, BatchResult<E> result) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Attempting to process " + objects.size() + " objects in batch"));
        }
        Transaction tx = null;
        try {
            tx = session.beginTransaction();
            for (Serializable object : objects) {
                op.performOperation(session, object);
            }
            session.flush();
            tx.commit();
            session.clear();
        }
        catch (RuntimeException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Batch failed", (Throwable)e);
            }
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            finally {
                session.clear();
            }
            this.processIndividual(objects, session, op, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends Serializable> void processIndividual(Collection<E> objects, org.hibernate.Session session, HibernateOperation op, BatchResult<E> result) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Attempting to process " + objects.size() + " objects one-by-one"));
        }
        for (Serializable object : objects) {
            Transaction tx = null;
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Processing '" + object.toString() + "' individually"));
                }
                tx = session.beginTransaction();
                op.performOperation(session, object);
                session.flush();
                tx.commit();
                session.clear();
            }
            catch (RuntimeException e) {
                result.addFailure((Object)object);
                logger.error((Object)("Could not process " + object.getClass() + ": " + object.toString()), (Throwable)e);
                try {
                    if (tx == null) continue;
                    tx.rollback();
                }
                finally {
                    session.clear();
                }
            }
        }
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }
}

