/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.directory;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.crowd.integration.directory.RemoteDirectory;
import com.atlassian.crowd.integration.directory.cache.CachingLDAPDirectory;
import com.atlassian.crowd.integration.directory.cache.DirectoryCache;
import com.atlassian.crowd.integration.directory.connector.LDAPDirectory;
import com.atlassian.crowd.integration.directory.monitor.MonitorCapable;
import com.atlassian.crowd.integration.exception.DirectoryInstantiationException;
import com.atlassian.crowd.manager.directory.cache.DirectoryCacheManager;
import com.atlassian.crowd.manager.directory.monitor.DirectoryMonitorManager;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.model.directory.DirectoryInstanceLoader;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryInstanceLoaderImpl
implements DirectoryInstanceLoader,
ApplicationContextAware {
    private final Logger logger = Logger.getLogger(this.getClass());
    private final DirectoryCacheManager directoryCacheManager;
    private final DirectoryMonitorManager directoryMonitorManager;
    private ApplicationContext applicationContext;

    public DirectoryInstanceLoaderImpl(DirectoryCacheManager directoryCacheManager, DirectoryMonitorManager directoryMonitorManager) {
        this.directoryCacheManager = directoryCacheManager;
        this.directoryMonitorManager = directoryMonitorManager;
    }

    public RemoteDirectory getDirectory(Directory directory) throws DirectoryInstantiationException {
        String implClass = directory.getImplementationClass();
        return this.getDirectory(implClass, directory.getAttributes(), directory.getId());
    }

    public RemoteDirectory getDirectory(String clazzName, Map<String, String> directoryAttributes, Long id) throws DirectoryInstantiationException {
        try {
            boolean caching;
            boolean monitoring;
            RemoteDirectory remoteDirectory = this.getRawDirectory(clazzName, directoryAttributes, id);
            boolean bl = monitoring = remoteDirectory instanceof MonitorCapable && Boolean.valueOf(directoryAttributes.get("useMonitoring")) != false;
            if (monitoring) {
                try {
                    if (!this.directoryMonitorManager.hasMonitor(id.longValue())) {
                        this.directoryMonitorManager.addMonitor(id.longValue());
                    }
                }
                catch (Exception e) {
                    this.logger.warn((Object)("Could not add a monitor for the directory with id: " + id), (Throwable)e);
                }
            }
            boolean bl2 = caching = monitoring && this.directoryMonitorManager.hasMonitor(id.longValue()) && Boolean.valueOf(directoryAttributes.get("useCaching")) != false && remoteDirectory instanceof LDAPDirectory && Boolean.valueOf(directoryAttributes.get("ldap.roles.disabled")) != false;
            if (caching) {
                try {
                    DirectoryCache cache = this.directoryCacheManager.getCache(id.longValue());
                    remoteDirectory = new CachingLDAPDirectory((LDAPDirectory)remoteDirectory, cache);
                }
                catch (Exception e) {
                    this.logger.warn((Object)("Could not wrap cache around the directory with id: " + id), (Throwable)e);
                }
            }
            return remoteDirectory;
        }
        catch (Exception e) {
            this.logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw new DirectoryInstantiationException((Throwable)e);
        }
    }

    public RemoteDirectory getRawDirectory(Directory directory) throws DirectoryInstantiationException {
        return this.getRawDirectory(directory.getImplementationClass(), directory.getAttributes(), directory.getId());
    }

    public RemoteDirectory getRawDirectory(String className, Map directoryAttributes, Long id) throws DirectoryInstantiationException {
        try {
            Class clazz = ClassLoaderUtils.loadClass((String)className, this.getClass());
            Object object = this.applicationContext.getAutowireCapableBeanFactory().createBean(clazz, 1, false);
            RemoteDirectory remoteDirectory = (RemoteDirectory)object;
            if (id != null) {
                remoteDirectory.setDirectoryId(id.longValue());
            }
            remoteDirectory.setAttributes(directoryAttributes);
            return remoteDirectory;
        }
        catch (Exception e) {
            this.logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw new DirectoryInstantiationException((Throwable)e);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

