/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.mail;

import com.atlassian.crowd.manager.mail.MailManager;
import com.atlassian.crowd.manager.mail.MailSendException;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.crowd.util.mail.SMTPServer;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MailManagerImpl
implements MailManager {
    private static final Logger logger = Logger.getLogger(MailManagerImpl.class);
    private static final String MAILER_SMTP_HOST = "mail.smtp.host";
    private static final String MAILER_SMTP_PORT = "mail.smtp.port";
    private static final String MAILER_CONTENT_TYPE = "Content-Type";
    private static final String MAILER_CONTENT_ENCODING = "text/plain;charset=\"us-ascii\";";
    private PropertyManager propertyManager;
    private InitialContext initialContext;
    I18nHelper i18nHelper;

    public MailManagerImpl(PropertyManager propertyManager, InitialContext initialContext, I18nHelper i18nHelper) {
        this.propertyManager = propertyManager;
        this.initialContext = initialContext;
        this.i18nHelper = i18nHelper;
    }

    public void sendEmail(InternetAddress emailAddress, String subject, String body) throws MailSendException {
        try {
            SMTPServer smtpServer = this.propertyManager.getSMTPServer();
            Session session = smtpServer.isJndiMailActive() ? this.getJndiMailSession(smtpServer) : this.getHostMailSession(smtpServer);
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setFrom((Address)smtpServer.getFrom());
            mimeMessage.setSentDate(new Date());
            mimeMessage.addRecipient(MimeMessage.RecipientType.TO, (Address)emailAddress);
            mimeMessage.setSubject(smtpServer.getPrefix() + " " + subject);
            mimeMessage.setText(body);
            mimeMessage.setHeader(MAILER_CONTENT_TYPE, MAILER_CONTENT_ENCODING);
            Transport.send((Message)mimeMessage);
        }
        catch (Exception e) {
            throw new MailSendException(this.i18nHelper.getText("principal.resetpassword.error.invalid", (Object)emailAddress) + e.getMessage(), (Throwable)e);
        }
    }

    private Session getHostMailSession(final SMTPServer smtpServer) throws IllegalStateException {
        Authenticator auth = null;
        if (StringUtils.isNotBlank((String)smtpServer.getUsername())) {
            auth = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(smtpServer.getUsername(), smtpServer.getPassword());
                }
            };
        }
        Properties properties = new Properties();
        if (StringUtils.isBlank((String)smtpServer.getHost())) {
            throw new IllegalStateException("Mail server configured in Remote Host mode, but no remote host is specified in the database.");
        }
        properties.put(MAILER_SMTP_HOST, smtpServer.getHost());
        properties.put(MAILER_SMTP_PORT, smtpServer.getPort());
        Session session = auth == null ? Session.getInstance((Properties)properties) : Session.getInstance((Properties)properties, (Authenticator)auth);
        return session;
    }

    private Session getJndiMailSession(SMTPServer smtpServer) throws IllegalStateException, NamingException {
        if (!StringUtils.isNotBlank((String)smtpServer.getJndiLocation())) {
            throw new IllegalStateException("Mail server configured in JNDI mode, but no JNDI location is specified in the database.");
        }
        Session session = (Session)this.initialContext.lookup(smtpServer.getJndiLocation());
        return session;
    }
}

