/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application;

import com.atlassian.crowd.integration.authentication.ApplicationAuthenticationContext;
import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.authentication.PasswordHelper;
import com.atlassian.crowd.integration.exception.InvalidAuthenticationException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.service.soap.client.ClientProperties;
import com.atlassian.crowd.integration.service.soap.client.ResourceLocator;
import com.atlassian.crowd.integration.util.PropertyUtils;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationManagerException;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.application.CrowdApplicationPasswordManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.util.I18nHelper;
import org.apache.log4j.Logger;

public class CrowdApplicationPasswordManagerGeneric
implements CrowdApplicationPasswordManager {
    private final Logger logger = Logger.getLogger(this.getClass());
    private ApplicationService applicationService;
    private ApplicationManager applicationManager;
    private PasswordHelper passwordHelper;
    private PropertyUtils propertyUtils;
    private ClientProperties clientProperties;
    private I18nHelper i18nHelper;
    private ResourceLocator resourceLocator;

    public void resetCrowdPasswordIfRequired() throws ObjectNotFoundException, ApplicationManagerException {
        try {
            ApplicationAuthenticationContext applicationAuthContext = new ApplicationAuthenticationContext();
            applicationAuthContext.setName(this.clientProperties.getApplicationName());
            applicationAuthContext.setCredential(new PasswordCredential(this.clientProperties.getApplicationPassword()));
            this.applicationService.authenticateApplication(applicationAuthContext);
        }
        catch (InvalidAuthenticationException e) {
            this.logger.info((Object)"Password in crowd.properties does not match imported data. Resetting the Crowd application's password in the database.");
            Application crowdApp = this.applicationManager.findByName(this.i18nHelper.getText("application.name").toLowerCase());
            String password = this.passwordHelper.generateRandomPassword();
            PasswordCredential credential = new PasswordCredential(password);
            this.applicationManager.updateCredential(crowdApp, credential);
            this.propertyUtils.updateProperty(this.resourceLocator.getResourceLocation(), "application.password", password);
            this.logger.info((Object)"Password for Crowd app has been reset in the database and crowd.properties");
        }
        this.clientProperties.updateProperties(this.resourceLocator.getProperties());
    }

    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager = applicationManager;
    }

    public void setPasswordHelper(PasswordHelper passwordHelper) {
        this.passwordHelper = passwordHelper;
    }

    public void setPropertyUtils(PropertyUtils propertyUtils) {
        this.propertyUtils = propertyUtils;
    }

    public void setI18nHelper(I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
    }

    public void setResourceLocator(ResourceLocator resourceLocator) {
        this.resourceLocator = resourceLocator;
    }

    public void setApplicationService(ApplicationService applicationService) {
        this.applicationService = applicationService;
    }

    public void setClientProperties(ClientProperties clientProperties) {
        this.clientProperties = clientProperties;
    }
}

