/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application;

import com.atlassian.crowd.event.application.ApplicationAuthenticatedEvent;
import com.atlassian.crowd.event.user.UserAuthenticationFailedAccessDeniedEvent;
import com.atlassian.crowd.event.user.UserAuthenticationFailedInvalidAuthenticationEvent;
import com.atlassian.crowd.event.user.UserAuthenticationSucceededEvent;
import com.atlassian.crowd.integration.authentication.ApplicationAuthenticationContext;
import com.atlassian.crowd.integration.authentication.AuthenticationContext;
import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.authentication.UserAuthenticationContext;
import com.atlassian.crowd.integration.authentication.ValidationFactor;
import com.atlassian.crowd.integration.directory.RemoteDirectory;
import com.atlassian.crowd.integration.exception.ApplicationPermissionException;
import com.atlassian.crowd.integration.exception.BulkAddFailedException;
import com.atlassian.crowd.integration.exception.DirectoryAccessException;
import com.atlassian.crowd.integration.exception.DirectoryInstantiationException;
import com.atlassian.crowd.integration.exception.DirectoryPermissionException;
import com.atlassian.crowd.integration.exception.ExpiredCredentialException;
import com.atlassian.crowd.integration.exception.InactiveAccountException;
import com.atlassian.crowd.integration.exception.InvalidAuthenticationException;
import com.atlassian.crowd.integration.exception.InvalidCredentialException;
import com.atlassian.crowd.integration.exception.InvalidEmailAddressException;
import com.atlassian.crowd.integration.exception.InvalidGroupException;
import com.atlassian.crowd.integration.exception.InvalidMembershipException;
import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.exception.InvalidUserException;
import com.atlassian.crowd.integration.exception.MembershipNotFoundException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.model.comparators.DirectoryEntityComparator;
import com.atlassian.crowd.integration.model.group.Group;
import com.atlassian.crowd.integration.model.group.GroupTemplate;
import com.atlassian.crowd.integration.model.group.GroupType;
import com.atlassian.crowd.integration.model.group.GroupWithAttributes;
import com.atlassian.crowd.integration.model.user.User;
import com.atlassian.crowd.integration.model.user.UserTemplate;
import com.atlassian.crowd.integration.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.integration.model.user.UserWithAttributes;
import com.atlassian.crowd.manager.GenericManager;
import com.atlassian.crowd.manager.application.ApplicationAccessDeniedException;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.cache.CacheManagerException;
import com.atlassian.crowd.manager.directory.BulkAddResult;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.permission.PermissionManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationDAO;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.model.directory.OperationType;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.password.encoder.PasswordEncoder;
import com.atlassian.crowd.password.factory.PasswordEncoderFactory;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.ReturnType;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.util.search.SearchResultsUtil;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationServiceGeneric
extends GenericManager
implements ApplicationService {
    private ApplicationDAO applicationDAO;
    private PasswordEncoderFactory passwordEncoderFactory;
    private PermissionManager permissionManager;
    private EventManager eventManager;

    public List<Application> findAuthorisedApplications(User user) throws ObjectNotFoundException, DirectoryAccessException {
        MembershipQuery query = QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).membershipsOf(EntityDescriptor.user()).withName(user.getName()).returningAtMost(-1).asNames();
        List groupMemberships = this.directoryManager.searchNestedGroupRelationships(user.getDirectoryId().longValue(), query);
        List authorisedApplications = this.applicationDAO.findAuthorisedApplications(user.getDirectoryId().longValue(), groupMemberships);
        return authorisedApplications;
    }

    public Token authenticateApplication(ApplicationAuthenticationContext authenticationContext) throws InvalidAuthenticationException {
        try {
            Application application = this.applicationDAO.findByName(authenticationContext.getName());
            if (!application.isActive()) {
                throw new InvalidAuthenticationException("Application is not active");
            }
            boolean passwordValid = this.getAtlassianSha1Encoder().isPasswordValid(application.getCredential().getCredential(), authenticationContext.getCredential().getCredential(), null);
            if (!passwordValid) {
                throw new InvalidAuthenticationException("The password in the application's crowd.properties file does not match the password in Crowd. Application with invalid password: " + authenticationContext.getName());
            }
            Token token = this.generateApplicationToken(authenticationContext);
            this.eventManager.publishEvent((Event)new ApplicationAuthenticatedEvent((Object)this, application, token));
            return token;
        }
        catch (ObjectNotFoundException e) {
            throw new InvalidAuthenticationException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidTokenException e) {
            throw new InvalidAuthenticationException(e.getMessage(), (Throwable)e);
        }
    }

    public Token authenticateUser(UserAuthenticationContext authenticationContext, boolean validatePassword, boolean ignoreCache) throws InvalidAuthenticationException, DirectoryAccessException, InactiveAccountException, ApplicationAccessDeniedException, ExpiredCredentialException {
        if (authenticationContext == null) {
            throw new InvalidAuthenticationException("Unable to authenticate with null context");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Authenticating user: " + authenticationContext.getName()));
        }
        try {
            Application application = this.applicationDAO.findByName(authenticationContext.getApplication());
            User user = validatePassword ? this.authenticateUser(application, authenticationContext) : this.findUserByName(application, authenticationContext.getName());
            Token token = this.generateUserToken(user.getDirectoryId(), (AuthenticationContext)authenticationContext);
            if (this.isAllowedToAuthenticate(token, application, ignoreCache)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("User <" + authenticationContext.getName() + "> has access to the application <" + application.getName() + ">"));
                }
                this.eventManager.publishEvent((Event)new UserAuthenticationSucceededEvent((Object)this, user, application, token));
                return token;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("User <" + authenticationContext.getName() + "> does NOT have access to the application <" + application.getName() + ">"));
            }
            this.eventManager.publishEvent((Event)new UserAuthenticationFailedAccessDeniedEvent((Object)this, user, application));
            throw new ApplicationAccessDeniedException(authenticationContext.getApplication());
        }
        catch (ObjectNotFoundException e) {
            throw new InvalidAuthenticationException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidTokenException e) {
            throw new InvalidAuthenticationException(e.getMessage(), (Throwable)e);
        }
        catch (CacheManagerException e) {
            throw new InvalidAuthenticationException(e.getMessage(), (Throwable)e);
        }
    }

    private User authenticateUser(Application application, UserAuthenticationContext authenticationContext) throws InvalidAuthenticationException, DirectoryAccessException, InactiveAccountException, ExpiredCredentialException {
        if (application.getDirectoryMappings() == null || application.getDirectoryMappings().size() == 0) {
            throw new InvalidAuthenticationException("Unable to authenticate user as there are no directories mapped to the application " + authenticationContext.getApplication());
        }
        for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
            RemoteDirectory remoteDirectory = directoryMapping.getDirectory().getImplementation();
            try {
                return remoteDirectory.authenticate(authenticationContext.getName(), authenticationContext.getCredential());
            }
            catch (ObjectNotFoundException e) {
            }
            catch (InvalidAuthenticationException e) {
                this.eventManager.publishEvent((Event)new UserAuthenticationFailedInvalidAuthenticationEvent((Object)this, directoryMapping.getDirectory(), authenticationContext.getName()));
                throw e;
            }
        }
        throw new InvalidAuthenticationException("User with username <" + authenticationContext.getName() + "> does not exist in any of the assigned directories of application <" + application.getName() + ">");
    }

    public Token authenticateUser(UserAuthenticationContext authenticateContext) throws InvalidAuthenticationException, DirectoryAccessException, InactiveAccountException, ApplicationAccessDeniedException, ExpiredCredentialException {
        return this.authenticateUser(authenticateContext, true, false);
    }

    public Token authenticateUserWithoutValidatingPassword(UserAuthenticationContext authenticateContext) throws InvalidAuthenticationException, DirectoryAccessException, InactiveAccountException, ApplicationAccessDeniedException {
        try {
            return this.authenticateUser(authenticateContext, false, false);
        }
        catch (ExpiredCredentialException e) {
            this.logger.fatal((Object)"This should never happen! This user is not authenticated by validating the password.");
            throw new InvalidAuthenticationException();
        }
    }

    public Token validateApplicationToken(String tokenKey, ValidationFactor[] clientValidationFactors) throws InvalidTokenException {
        return this.genericValidateToken(tokenKey, clientValidationFactors);
    }

    public Token validateUserToken(String userTokenKey, ValidationFactor[] validationFactors, String applicationName) throws InvalidTokenException, ApplicationAccessDeniedException, DirectoryAccessException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("validateUserToken: " + userTokenKey));
        }
        Token validatedToken = this.genericValidateToken(userTokenKey, validationFactors);
        Application application = null;
        try {
            application = this.applicationDAO.findByName(applicationName);
        }
        catch (ObjectNotFoundException e) {
            throw new ApplicationAccessDeniedException(applicationName);
        }
        if (this.isAllowedToAuthenticate(validatedToken, application)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("user has access to the application <" + application.getName() + ">"));
            }
            return validatedToken;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("user does NOT have access to the application <" + application.getName() + ">"));
        }
        throw new ApplicationAccessDeniedException(applicationName);
    }

    public User findUserByName(Application application, String name) throws ObjectNotFoundException, DirectoryAccessException {
        for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
            try {
                return this.directoryManager.findUserByName(directoryMapping.getDirectory().getId().longValue(), name);
            }
            catch (ObjectNotFoundException e) {
            }
            catch (DirectoryInstantiationException e) {
                this.logger.error((Object)e);
            }
        }
        throw new ObjectNotFoundException(User.class, (Object)name);
    }

    public UserWithAttributes findUserWithAttributesByName(Application application, String name) throws ObjectNotFoundException, DirectoryAccessException {
        for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
            try {
                return this.directoryManager.findUserWithAttributesByName(directoryMapping.getDirectory().getId().longValue(), name);
            }
            catch (ObjectNotFoundException e) {
            }
            catch (DirectoryInstantiationException e) {
                this.logger.error((Object)e);
            }
        }
        throw new ObjectNotFoundException(User.class, (Object)name);
    }

    public User addUser(Application application, UserTemplate user, PasswordCredential credential) throws InvalidUserException, DirectoryAccessException, InvalidCredentialException, ApplicationPermissionException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding user <" + user.getName() + "> for application <" + application.getName() + ">"));
        }
        try {
            this.findUserByName(application, user.getName());
            throw new InvalidUserException((User)user, "User already exists");
        }
        catch (ObjectNotFoundException e) {
            for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
                Directory directory = directoryMapping.getDirectory();
                if (!this.permissionManager.hasPermission(application, directory, OperationType.CREATE_USER)) continue;
                try {
                    user.setDirectoryId(directory.getId());
                    this.directoryManager.addUser(directory.getId().longValue(), user, credential);
                }
                catch (DirectoryPermissionException dpe) {
                    this.logger.info((Object)("Could not add user <" + user.getName() + "> to directory <" + directory.getName() + ">"));
                    this.logger.info((Object)dpe.getMessage());
                }
                catch (ObjectNotFoundException onfe) {
                    this.logger.error((Object)onfe.getMessage(), (Throwable)onfe);
                }
            }
            try {
                return this.findUserByName(application, user.getName());
            }
            catch (ObjectNotFoundException e2) {
                throw new ApplicationPermissionException(this.i18nHelper.getText("permission.application.exception.add.user", Arrays.asList(application.getName())));
            }
        }
    }

    public void addAllUsers(Application application, Collection<UserTemplateWithCredentialAndAttributes> userTemplates) throws ApplicationPermissionException, RemoteException, DirectoryAccessException, BulkAddFailedException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding users for application " + application));
        }
        HashSet<String> failedUsers = new HashSet<String>();
        HashSet<String> existingUsers = new HashSet<String>();
        boolean hasAddPermission = false;
        for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
            if (!this.permissionManager.hasPermission(directoryMapping.getDirectory(), OperationType.CREATE_USER)) continue;
            hasAddPermission = true;
            Directory directory = directoryMapping.getDirectory();
            try {
                for (UserTemplateWithCredentialAndAttributes userTemplate : userTemplates) {
                    userTemplate.setDirectoryId(directory.getId());
                }
                BulkAddResult result = this.directoryManager.addAllUsers(directory.getId().longValue(), userTemplates, false);
                for (User user : result.getExistingEntities()) {
                    existingUsers.add(user.getName());
                }
                for (User user : result.getFailedEntities()) {
                    failedUsers.add(user.getName());
                }
            }
            catch (DirectoryPermissionException dpe) {
                this.logger.info((Object)("Could not add users to directory " + directory.getName()));
                this.logger.info((Object)dpe.getMessage());
            }
            catch (ObjectNotFoundException onfe) {
                this.logger.error((Object)onfe.getMessage(), (Throwable)onfe);
            }
        }
        if (!hasAddPermission) {
            throw new ApplicationPermissionException(this.i18nHelper.getText("permission.application.exception.add.user", Arrays.asList(application.getName())));
        }
        if (failedUsers.size() > 0 || existingUsers.size() > 0) {
            throw new BulkAddFailedException(failedUsers, existingUsers);
        }
    }

    public User updateUser(Application application, UserTemplate user) throws InvalidUserException, DirectoryAccessException, ApplicationPermissionException, ObjectNotFoundException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Updating user <" + user.getName() + "> for application <" + application.getName() + ">"));
        }
        this.findUserByName(application, user.getName());
        boolean atleastOneDirectoryHasPermission = false;
        for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
            Directory directory = directoryMapping.getDirectory();
            if (!this.permissionManager.hasPermission(application, directory, OperationType.UPDATE_USER)) continue;
            try {
                user.setDirectoryId(directory.getId());
                this.directoryManager.updateUser(directory.getId().longValue(), user);
                atleastOneDirectoryHasPermission = true;
            }
            catch (DirectoryPermissionException dpe) {
                this.logger.info((Object)("Could not update user <" + user.getName() + "> to directory <" + directory.getName() + ">"));
                this.logger.info((Object)dpe.getMessage());
            }
            catch (ObjectNotFoundException e) {}
        }
        if (!atleastOneDirectoryHasPermission) {
            throw new ApplicationPermissionException(this.i18nHelper.getText("permission.application.exception.modify.user", Arrays.asList(application.getName())));
        }
        return this.findUserByName(application, user.getName());
    }

    public void updateUserCredential(Application application, String username, PasswordCredential credential) throws DirectoryAccessException, ObjectNotFoundException, InvalidCredentialException, ApplicationPermissionException {
        User user = this.findUserByName(application, username);
        Directory directory = this.directoryManager.findDirectoryById(user.getDirectoryId().longValue());
        if (this.permissionManager.hasPermission(application, directory, OperationType.UPDATE_USER)) {
            try {
                this.directoryManager.updateUserCredential(user.getDirectoryId().longValue(), username, credential);
            }
            catch (DirectoryPermissionException e) {
                throw new ApplicationPermissionException((Throwable)e);
            }
        } else {
            throw new ApplicationPermissionException(this.i18nHelper.getText("permission.application.exception.modify.user", Arrays.asList(application.getName())));
        }
    }

    public void resetUserCredential(Application application, String username) throws DirectoryAccessException, ObjectNotFoundException, InvalidCredentialException, ApplicationPermissionException, InvalidEmailAddressException {
        User user = this.findUserByName(application, username);
        Directory directory = this.directoryManager.findDirectoryById(user.getDirectoryId().longValue());
        if (this.permissionManager.hasPermission(application, directory, OperationType.UPDATE_USER)) {
            try {
                this.directoryManager.resetPassword(user.getDirectoryId().longValue(), username);
            }
            catch (DirectoryPermissionException e) {
                throw new ApplicationPermissionException((Throwable)e);
            }
        } else {
            throw new ApplicationPermissionException(this.i18nHelper.getText("permission.application.exception.modify.user", Arrays.asList(application.getName())));
        }
    }

    public void storeUserAttributes(Application application, String username, Map<String, List<String>> attributes) throws DirectoryAccessException, ApplicationPermissionException, ObjectNotFoundException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Storing user attributes for user <" + username + "> and application <" + application.getName() + ">"));
        }
        this.findUserByName(application, username);
        boolean atleastOneDirectoryHasPermission = false;
        for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
            Directory directory = directoryMapping.getDirectory();
            if (!this.permissionManager.hasPermission(application, directory, OperationType.UPDATE_USER)) continue;
            try {
                this.directoryManager.storeUserAttributes(directory.getId().longValue(), username, attributes);
                atleastOneDirectoryHasPermission = true;
            }
            catch (DirectoryPermissionException dpe) {
                this.logger.info((Object)("Could not update user <" + username + "> to directory <" + directory.getName() + ">"));
                this.logger.info((Object)dpe.getMessage());
            }
            catch (ObjectNotFoundException e) {}
        }
        if (!atleastOneDirectoryHasPermission) {
            throw new ApplicationPermissionException(this.i18nHelper.getText("permission.application.exception.modify.user", Arrays.asList(application.getName())));
        }
    }

    public void removeUserAttributes(Application application, String username, String attributeName) throws DirectoryAccessException, ApplicationPermissionException, ObjectNotFoundException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Removing user attributes for user <" + username + "> and application <" + application.getName() + ">"));
        }
        this.findUserByName(application, username);
        boolean atleastOneDirectoryHasPermission = false;
        for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
            Directory directory = directoryMapping.getDirectory();
            if (!this.permissionManager.hasPermission(application, directory, OperationType.UPDATE_USER)) continue;
            try {
                this.directoryManager.removeUserAttributes(directory.getId().longValue(), username, attributeName);
                atleastOneDirectoryHasPermission = true;
            }
            catch (DirectoryPermissionException dpe) {
                this.logger.info((Object)("Could not update user <" + username + "> to directory <" + directory.getName() + ">"));
                this.logger.info((Object)dpe.getMessage());
            }
            catch (ObjectNotFoundException e) {}
        }
        if (!atleastOneDirectoryHasPermission) {
            throw new ApplicationPermissionException(this.i18nHelper.getText("permission.application.exception.modify.user", Arrays.asList(application.getName())));
        }
    }

    public void removeUser(Application application, String username) throws DirectoryAccessException, ObjectNotFoundException, ApplicationPermissionException {
        this.findUserByName(application, username);
        boolean permissibleByAnyDirectory = false;
        for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
            Directory directory = directoryMapping.getDirectory();
            if (!this.permissionManager.hasPermission(application, directory, OperationType.DELETE_USER)) continue;
            try {
                this.directoryManager.removeUser(directory.getId().longValue(), username);
                permissibleByAnyDirectory = true;
            }
            catch (DirectoryPermissionException e) {
                this.logger.info((Object)("Could not remove user <" + username + "> from directory <" + directory.getName() + ">"));
            }
            catch (ObjectNotFoundException e) {}
        }
        if (!permissibleByAnyDirectory) {
            throw new ApplicationPermissionException(this.i18nHelper.getText("permission.application.exception.remove.user", Arrays.asList(application.getName())));
        }
    }

    public List searchUsers(Application application, EntityQuery query) throws DirectoryAccessException {
        TreeSet results = query.getReturnType() == ReturnType.ENTITY ? new TreeSet(new DirectoryEntityComparator()) : new TreeSet();
        int totalResults = query.getStartIndex() + query.getMaxResults();
        if (query.getMaxResults() == -1) {
            totalResults = -1;
        }
        for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
            try {
                int maxResults = totalResults - results.size();
                if (query.getMaxResults() == -1) {
                    maxResults = -1;
                }
                EntityQuery totalQuery = new EntityQuery(query, 0, maxResults);
                List users = this.directoryManager.searchUsers(directoryMapping.getDirectory().getId().longValue(), totalQuery);
                results.addAll(users);
                if (query.getMaxResults() == -1 || results.size() < query.getMaxResults()) continue;
                break;
            }
            catch (ObjectNotFoundException e) {
            }
        }
        return SearchResultsUtil.constrainResults(new ArrayList(results), query.getStartIndex(), query.getMaxResults());
    }

    public Group findGroupByName(Application application, String name) throws ObjectNotFoundException, DirectoryAccessException {
        for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
            try {
                return this.directoryManager.findGroupByName(directoryMapping.getDirectory().getId().longValue(), name);
            }
            catch (ObjectNotFoundException e) {
            }
            catch (DirectoryInstantiationException e) {
                this.logger.error((Object)e);
            }
        }
        throw new ObjectNotFoundException(Group.class, (Object)name);
    }

    public GroupWithAttributes findGroupWithAttributesByName(Application application, String name) throws ObjectNotFoundException, DirectoryAccessException {
        for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
            try {
                return this.directoryManager.findGroupWithAttributesByName(directoryMapping.getDirectory().getId().longValue(), name);
            }
            catch (ObjectNotFoundException e) {
            }
            catch (DirectoryInstantiationException e) {
                this.logger.error((Object)e);
            }
        }
        throw new ObjectNotFoundException(Group.class, (Object)name);
    }

    public Group addGroup(Application application, GroupTemplate group) throws InvalidGroupException, DirectoryAccessException, ApplicationPermissionException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding group <" + group.getName() + "> for application <" + application.getName() + ">"));
        }
        try {
            this.findGroupByName(application, group.getName());
            throw new InvalidGroupException((Group)group, "Group already exists");
        }
        catch (ObjectNotFoundException e) {
            OperationType operationType = GroupType.GROUP.equals((Object)group.getType()) ? OperationType.CREATE_GROUP : OperationType.CREATE_ROLE;
            for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
                Directory directory = directoryMapping.getDirectory();
                if (!this.permissionManager.hasPermission(application, directory, operationType)) continue;
                try {
                    group.setDirectoryId(directory.getId());
                    this.directoryManager.addGroup(directory.getId().longValue(), group);
                }
                catch (DirectoryPermissionException dpe) {
                    this.logger.info((Object)("Could not add group <" + group.getName() + "> to directory <" + directory.getName() + ">"));
                    this.logger.info((Object)dpe.getMessage());
                }
                catch (ObjectNotFoundException onfe) {
                    this.logger.error((Object)onfe.getMessage(), (Throwable)onfe);
                }
            }
            try {
                return this.findGroupByName(application, group.getName());
            }
            catch (ObjectNotFoundException e2) {
                throw new ApplicationPermissionException(this.i18nHelper.getText("permission.application.exception.add.group", Arrays.asList(application.getName())));
            }
        }
    }

    public Group updateGroup(Application application, GroupTemplate group) throws InvalidGroupException, DirectoryAccessException, ApplicationPermissionException, ObjectNotFoundException {
        Group groupToUpdate;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Updating group <" + group.getName() + "> for application <" + application.getName() + ">"));
        }
        OperationType operationType = GroupType.GROUP.equals((Object)(groupToUpdate = this.findGroupByName(application, group.getName())).getType()) ? OperationType.UPDATE_GROUP : OperationType.UPDATE_ROLE;
        boolean atleastOneDirectoryHasPermission = false;
        for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
            Directory directory = directoryMapping.getDirectory();
            if (!this.permissionManager.hasPermission(application, directory, operationType)) continue;
            try {
                group.setDirectoryId(directory.getId());
                this.directoryManager.updateGroup(directory.getId().longValue(), group);
                atleastOneDirectoryHasPermission = true;
            }
            catch (DirectoryPermissionException dpe) {
                this.logger.info((Object)("Could not update group <" + group.getName() + "> to directory <" + directory.getName() + ">"));
                this.logger.info((Object)dpe.getMessage());
            }
            catch (ObjectNotFoundException e) {}
        }
        if (!atleastOneDirectoryHasPermission) {
            throw new ApplicationPermissionException(this.i18nHelper.getText("permission.application.exception.modify.group", Arrays.asList(application.getName())));
        }
        return this.findGroupByName(application, group.getName());
    }

    public void storeGroupAttributes(Application application, String groupname, Map<String, List<String>> attributes) throws DirectoryAccessException, ApplicationPermissionException, ObjectNotFoundException {
        Group groupToUpdate;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Storing group attributes for group <" + groupname + "> and application <" + application.getName() + ">"));
        }
        OperationType operationType = GroupType.GROUP.equals((Object)(groupToUpdate = this.findGroupByName(application, groupname)).getType()) ? OperationType.UPDATE_GROUP : OperationType.UPDATE_ROLE;
        boolean atleastOneDirectoryHasPermission = false;
        for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
            Directory directory = directoryMapping.getDirectory();
            if (!this.permissionManager.hasPermission(application, directory, operationType)) continue;
            try {
                this.directoryManager.storeGroupAttributes(directory.getId().longValue(), groupname, attributes);
                atleastOneDirectoryHasPermission = true;
            }
            catch (DirectoryPermissionException dpe) {
                this.logger.info((Object)("Could not update group <" + groupname + "> to directory <" + directory.getName() + ">"));
                this.logger.info((Object)dpe.getMessage());
            }
            catch (ObjectNotFoundException e) {}
        }
        if (!atleastOneDirectoryHasPermission) {
            throw new ApplicationPermissionException(this.i18nHelper.getText("permission.application.exception.modify.group", Arrays.asList(application.getName())));
        }
    }

    public void removeGroupAttributes(Application application, String groupname, String attributeName) throws DirectoryAccessException, ApplicationPermissionException, ObjectNotFoundException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Removing group attributes for group <" + groupname + "> and application <" + application.getName() + ">"));
        }
        Group groupToUpdate = this.findGroupByName(application, groupname);
        boolean atleastOneDirectoryHasPermission = false;
        OperationType operationType = GroupType.GROUP.equals((Object)groupToUpdate.getType()) ? OperationType.UPDATE_GROUP : OperationType.UPDATE_ROLE;
        for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
            Directory directory = directoryMapping.getDirectory();
            if (!this.permissionManager.hasPermission(application, directory, operationType)) continue;
            try {
                this.directoryManager.removeGroupAttributes(directory.getId().longValue(), groupname, attributeName);
                atleastOneDirectoryHasPermission = true;
            }
            catch (DirectoryPermissionException dpe) {
                this.logger.info((Object)("Could not update group <" + groupname + "> to directory <" + directory.getName() + ">"));
                this.logger.info((Object)dpe.getMessage());
            }
            catch (ObjectNotFoundException e) {}
        }
        if (!atleastOneDirectoryHasPermission) {
            throw new ApplicationPermissionException(this.i18nHelper.getText("permission.application.exception.modify.group", Arrays.asList(application.getName())));
        }
    }

    public void removeGroup(Application application, String groupname) throws DirectoryAccessException, ObjectNotFoundException, ApplicationPermissionException {
        Group groupToRemove = this.findGroupByName(application, groupname);
        boolean permissibleByAnyDirectory = false;
        OperationType operationType = GroupType.GROUP.equals((Object)groupToRemove.getType()) ? OperationType.DELETE_GROUP : OperationType.DELETE_ROLE;
        for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
            Directory directory = directoryMapping.getDirectory();
            if (!this.permissionManager.hasPermission(application, directory, operationType)) continue;
            try {
                this.directoryManager.removeGroup(directory.getId().longValue(), groupname);
                permissibleByAnyDirectory = true;
            }
            catch (DirectoryPermissionException e) {
                this.logger.info((Object)("Could not remove group <" + groupname + "> from directory <" + directory.getName() + ">"));
            }
            catch (ObjectNotFoundException e) {}
        }
        if (!permissibleByAnyDirectory) {
            throw new ApplicationPermissionException(this.i18nHelper.getText("permission.application.exception.remove.group", Arrays.asList(application.getName())));
        }
    }

    public List searchGroups(Application application, EntityQuery query) throws DirectoryAccessException {
        TreeSet results = query.getReturnType() == ReturnType.ENTITY ? new TreeSet(new DirectoryEntityComparator()) : new TreeSet();
        int totalResults = query.getStartIndex() + query.getMaxResults();
        if (query.getMaxResults() == -1) {
            totalResults = -1;
        }
        for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
            try {
                int maxResults = totalResults - results.size();
                if (query.getMaxResults() == -1) {
                    maxResults = -1;
                }
                EntityQuery totalQuery = new EntityQuery(query, 0, maxResults);
                List groups = this.directoryManager.searchGroups(directoryMapping.getDirectory().getId().longValue(), totalQuery);
                results.addAll(groups);
                if (query.getMaxResults() == -1 || results.size() < query.getMaxResults()) continue;
                break;
            }
            catch (ObjectNotFoundException e) {
            }
        }
        return SearchResultsUtil.constrainResults(new ArrayList(results), query.getStartIndex(), query.getMaxResults());
    }

    public void addUserToGroup(Application application, String username, String groupName) throws DirectoryAccessException, ObjectNotFoundException, ApplicationPermissionException {
        boolean permissibleByAnyDirectory = false;
        Group groupToUpdate = this.findGroupByName(application, groupName);
        OperationType operationType = GroupType.GROUP.equals((Object)groupToUpdate.getType()) ? OperationType.UPDATE_GROUP : OperationType.UPDATE_ROLE;
        for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
            Directory directory = directoryMapping.getDirectory();
            if (!this.permissionManager.hasPermission(application, directory, operationType)) continue;
            try {
                this.directoryManager.addUserToGroup(directory.getId().longValue(), username, groupName);
                permissibleByAnyDirectory = true;
            }
            catch (DirectoryPermissionException e) {
                this.logger.info((Object)("Could not add user <" + username + "> to group <" + groupName + "> from directory <" + directory.getName() + ">"));
            }
            catch (ObjectNotFoundException e) {
                permissibleByAnyDirectory = true;
            }
        }
        if (!permissibleByAnyDirectory) {
            throw new ApplicationPermissionException(this.i18nHelper.getText("permission.application.exception.modify.group", Arrays.asList(application.getName())));
        }
        if (!this.isUserDirectGroupMember(application, username, groupName)) {
            throw new ObjectNotFoundException(Group.class, (Object)("group = " + groupName + ", user = " + username));
        }
    }

    public void addGroupToGroup(Application application, String childGroup, String parentGroup) throws DirectoryAccessException, ObjectNotFoundException, ApplicationPermissionException {
        boolean permissibleByAnyDirectory = false;
        Group parentGroupToModify = this.findGroupByName(application, parentGroup);
        OperationType operationType = GroupType.GROUP.equals((Object)parentGroupToModify.getType()) ? OperationType.UPDATE_GROUP : OperationType.UPDATE_ROLE;
        for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
            Directory directory = directoryMapping.getDirectory();
            if (!this.permissionManager.hasPermission(application, directory, operationType)) continue;
            try {
                this.directoryManager.addGroupToGroup(directory.getId().longValue(), childGroup, parentGroup);
                permissibleByAnyDirectory = true;
            }
            catch (DirectoryPermissionException e) {
                this.logger.info((Object)("Could not add child group <" + childGroup + "> to parent group <" + parentGroup + "> from directory <" + directory.getName() + ">"));
            }
            catch (ObjectNotFoundException e) {
                permissibleByAnyDirectory = true;
            }
            catch (InvalidMembershipException e) {
                this.logger.info((Object)("Could not add child group <" + childGroup + "> to parent group <" + parentGroup + "> from directory <" + directory.getName() + ">: " + e.getMessage()));
            }
        }
        if (!permissibleByAnyDirectory) {
            throw new ApplicationPermissionException(this.i18nHelper.getText("permission.application.exception.modify.group", Arrays.asList(application.getName())));
        }
        if (!this.isGroupDirectGroupMember(application, childGroup, parentGroup)) {
            throw new ObjectNotFoundException(Group.class, (Object)("parentGroup = " + parentGroup + ", childGroup = " + childGroup));
        }
    }

    public void removeUserFromGroup(Application application, String username, String groupName) throws DirectoryAccessException, ObjectNotFoundException, ApplicationPermissionException, MembershipNotFoundException {
        OperationType operationType;
        boolean permissibleByAnyDirectory = false;
        Group groupToUpdate = this.findGroupByName(application, groupName);
        OperationType operationType2 = operationType = GroupType.GROUP.equals((Object)groupToUpdate.getType()) ? OperationType.UPDATE_GROUP : OperationType.UPDATE_ROLE;
        if (!this.isUserDirectGroupMember(application, username, groupName)) {
            throw new MembershipNotFoundException(username, groupName);
        }
        for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
            Directory directory = directoryMapping.getDirectory();
            if (!this.permissionManager.hasPermission(application, directory, operationType)) continue;
            try {
                this.directoryManager.removeUserFromGroup(directory.getId().longValue(), username, groupName);
                permissibleByAnyDirectory = true;
            }
            catch (DirectoryPermissionException e) {
                this.logger.info((Object)("Could not remove user <" + username + "> to group <" + groupName + "> from directory <" + directory.getName() + ">"));
            }
            catch (ObjectNotFoundException e) {
                permissibleByAnyDirectory = true;
            }
        }
        if (!permissibleByAnyDirectory) {
            throw new ApplicationPermissionException(this.i18nHelper.getText("permission.application.exception.modify.group", Arrays.asList(application.getName())));
        }
    }

    public void removeGroupFromGroup(Application application, String childGroup, String parentGroup) throws DirectoryAccessException, ObjectNotFoundException, ApplicationPermissionException, MembershipNotFoundException {
        boolean permissibleByAnyDirectory = false;
        if (!this.isGroupDirectGroupMember(application, childGroup, parentGroup)) {
            throw new MembershipNotFoundException(childGroup, parentGroup);
        }
        Group parentGroupToModify = this.findGroupByName(application, parentGroup);
        OperationType operationType = GroupType.GROUP.equals((Object)parentGroupToModify.getType()) ? OperationType.UPDATE_GROUP : OperationType.UPDATE_ROLE;
        for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
            Directory directory = directoryMapping.getDirectory();
            if (!this.permissionManager.hasPermission(application, directory, operationType)) continue;
            try {
                this.directoryManager.removeGroupFromGroup(directory.getId().longValue(), childGroup, parentGroup);
                permissibleByAnyDirectory = true;
            }
            catch (DirectoryPermissionException e) {
                this.logger.info((Object)("Could not remove child group <" + childGroup + "> to parent group <" + parentGroup + "> from directory <" + directory.getName() + ">"));
            }
            catch (ObjectNotFoundException e) {
                permissibleByAnyDirectory = true;
            }
            catch (InvalidMembershipException e) {
                this.logger.info((Object)("Could not remove child group <" + childGroup + "> from parent group <" + parentGroup + "> from directory <" + directory.getName() + ">: " + e.getMessage()));
            }
        }
        if (!permissibleByAnyDirectory) {
            throw new ApplicationPermissionException(this.i18nHelper.getText("permission.application.exception.modify.group", Arrays.asList(application.getName())));
        }
    }

    public boolean isUserDirectGroupMember(Application application, String username, String groupName) throws DirectoryAccessException {
        for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
            Directory directory = directoryMapping.getDirectory();
            try {
                if (!this.directoryManager.isUserDirectGroupMember(directory.getId().longValue(), username, groupName)) continue;
                return true;
            }
            catch (ObjectNotFoundException e) {
            }
        }
        return false;
    }

    public boolean isGroupDirectGroupMember(Application application, String childGroup, String parentGroup) throws DirectoryAccessException {
        for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
            Directory directory = directoryMapping.getDirectory();
            try {
                if (!this.directoryManager.isGroupDirectGroupMember(directory.getId().longValue(), childGroup, parentGroup)) continue;
                return true;
            }
            catch (ObjectNotFoundException e) {
            }
        }
        return false;
    }

    public boolean isUserNestedGroupMember(Application application, String username, String groupName) throws DirectoryAccessException {
        for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
            Directory directory = directoryMapping.getDirectory();
            try {
                if (!this.directoryManager.isUserNestedGroupMember(directory.getId().longValue(), username, groupName)) continue;
                return true;
            }
            catch (ObjectNotFoundException e) {
            }
        }
        return false;
    }

    public boolean isGroupNestedGroupMember(Application application, String childGroup, String parentGroup) throws DirectoryAccessException {
        for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
            Directory directory = directoryMapping.getDirectory();
            try {
                if (!this.directoryManager.isGroupNestedGroupMember(directory.getId().longValue(), childGroup, parentGroup)) continue;
                return true;
            }
            catch (ObjectNotFoundException e) {
            }
        }
        return false;
    }

    public List searchDirectGroupRelationships(Application application, MembershipQuery query) throws DirectoryAccessException {
        TreeSet results = query.getReturnType() == ReturnType.ENTITY ? new TreeSet(new DirectoryEntityComparator()) : new TreeSet();
        int totalResults = query.getStartIndex() + query.getMaxResults();
        if (query.getMaxResults() == -1) {
            totalResults = -1;
        }
        for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
            try {
                int maxResults = totalResults - results.size();
                if (query.getMaxResults() == -1) {
                    maxResults = -1;
                }
                MembershipQuery totalQuery = new MembershipQuery(query, 0, maxResults);
                List relations = this.directoryManager.searchDirectGroupRelationships(directoryMapping.getDirectory().getId().longValue(), totalQuery);
                results.addAll(relations);
                if (query.getMaxResults() == -1 || results.size() < query.getMaxResults()) continue;
                break;
            }
            catch (ObjectNotFoundException e) {
            }
        }
        return SearchResultsUtil.constrainResults(new ArrayList(results), query.getStartIndex(), query.getMaxResults());
    }

    public List searchNestedGroupRelationships(Application application, MembershipQuery query) throws DirectoryAccessException {
        TreeSet results = query.getReturnType() == ReturnType.ENTITY ? new TreeSet(new DirectoryEntityComparator()) : new TreeSet();
        int totalResults = query.getStartIndex() + query.getMaxResults();
        if (query.getMaxResults() == -1) {
            totalResults = -1;
        }
        for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
            try {
                int maxResults = totalResults - results.size();
                if (query.getMaxResults() == -1) {
                    maxResults = -1;
                }
                MembershipQuery totalQuery = new MembershipQuery(query, 0, maxResults);
                List relations = this.directoryManager.searchNestedGroupRelationships(directoryMapping.getDirectory().getId().longValue(), totalQuery);
                results.addAll(relations);
                if (query.getMaxResults() == -1 || results.size() < query.getMaxResults()) continue;
                break;
            }
            catch (ObjectNotFoundException e) {
            }
        }
        return SearchResultsUtil.constrainResults(new ArrayList(results), query.getStartIndex(), query.getMaxResults());
    }

    private PasswordEncoder getAtlassianSha1Encoder() {
        return this.passwordEncoderFactory.getEncoder("atlassian-sha1");
    }

    public void setApplicationDAO(ApplicationDAO applicationDAO) {
        this.applicationDAO = applicationDAO;
    }

    public void setPasswordEncoderFactory(PasswordEncoderFactory passwordEncoderFactory) {
        this.passwordEncoderFactory = passwordEncoderFactory;
    }

    @Override
    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }
}

