/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application;

import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.exception.InvalidCredentialException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationManagerException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationDAO;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.password.encoder.PasswordEncoder;
import com.atlassian.crowd.password.factory.PasswordEncoderFactory;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.I18nHelper;
import java.util.List;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationManagerGeneric
implements ApplicationManager {
    private ApplicationDAO applicationDAO;
    private PasswordEncoderFactory passwordEncoderFactory;
    private I18nHelper i18nHelper;

    public Application add(Application application) throws InvalidCredentialException {
        application.setName(application.getName().toLowerCase());
        this.encryptAndUpdateApplicationCredential(application, application.getCredential());
        return this.applicationDAO.add(application);
    }

    public Application findById(long id) throws ObjectNotFoundException {
        return this.applicationDAO.findById(id);
    }

    public Application findByName(String name) throws ObjectNotFoundException {
        return this.applicationDAO.findByName(name);
    }

    public void remove(Application application) throws ApplicationManagerException {
        if (application.isPermanent()) {
            throw new ApplicationManagerException(this.i18nHelper.getText("exception.application.delete.not.allowed"));
        }
        this.applicationDAO.remove(application);
    }

    public void removeDirectoryFromApplication(Directory directory, Application application) throws ApplicationManagerException {
        DirectoryMapping mapping = application.getDirectoryMapping(directory.getId().longValue());
        if (mapping != null && application.removeDirectoryMapping(directory.getId().longValue())) {
            this.applicationDAO.update(application);
        }
    }

    public List<Application> search(EntityQuery query) {
        return this.applicationDAO.search(query);
    }

    public List<Application> findAll() {
        return this.search(QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.application()).returningAtMost(-1));
    }

    public Application update(Application application) throws ApplicationManagerException {
        if (application.getType() == ApplicationType.CROWD && !application.isActive()) {
            throw new ApplicationManagerException(this.i18nHelper.getText("exception.application.deactivate.not.allowed"));
        }
        if (application.isPermanent()) {
            try {
                Application savedApp = this.findById(application.getId());
                if (!savedApp.getName().equals(application.getName())) {
                    throw new ApplicationManagerException(this.i18nHelper.getText("exception.application.rename.not.allowed"));
                }
            }
            catch (ObjectNotFoundException e) {
                throw new ApplicationManagerException(e.getMessage(), (Throwable)e);
            }
        }
        return this.applicationDAO.update(application);
    }

    public Application updateCredential(Application application, PasswordCredential passwordCredential) throws ApplicationManagerException {
        Validate.notNull((Object)application);
        Validate.notNull((Object)passwordCredential);
        Validate.notNull((Object)passwordCredential.getCredential());
        this.encryptAndUpdateApplicationCredential(application, passwordCredential);
        return this.update(application);
    }

    private void encryptAndUpdateApplicationCredential(Application application, PasswordCredential passwordCredential) {
        PasswordEncoder encoder = this.getAtlassianSha1Encoder();
        String encrypedPassword = encoder.encodePassword(passwordCredential.getCredential(), null);
        passwordCredential.setCredential(encrypedPassword);
        passwordCredential.setEncryptedCredential(true);
        application.setCredential(passwordCredential);
        application.setAttribute("atlassian_sha1_applied", Boolean.TRUE.toString());
    }

    private PasswordEncoder getAtlassianSha1Encoder() {
        return this.passwordEncoderFactory.getEncoder("atlassian-sha1");
    }

    public void setApplicationDAO(ApplicationDAO applicationDAO) {
        this.applicationDAO = applicationDAO;
    }

    public void setPasswordEncoderFactory(PasswordEncoderFactory passwordEncoderFactory) {
        this.passwordEncoderFactory = passwordEncoderFactory;
    }

    public void setI18nHelper(I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
    }
}

