/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.connector;

import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.directory.connector.RFC2307Directory;
import com.atlassian.crowd.integration.exception.InvalidCredentialException;
import com.atlassian.crowd.integration.exception.InvalidGroupException;
import com.atlassian.crowd.integration.exception.InvalidUserException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.model.group.Group;
import com.atlassian.crowd.integration.model.group.GroupTemplate;
import com.atlassian.crowd.integration.model.user.LDAPUserWithAttributes;
import com.atlassian.crowd.integration.model.user.User;
import com.atlassian.crowd.integration.model.user.UserTemplate;
import com.atlassian.crowd.password.encoder.PasswordEncoder;
import com.atlassian.crowd.password.factory.PasswordEncoderFactory;
import com.atlassian.spring.container.ContainerManager;
import javax.naming.directory.Attributes;
import org.apache.commons.lang.StringUtils;

public class Rfc2307
extends RFC2307Directory {
    public static String getStaticDirectoryType() {
        return "Generic Posix/RFC2307 Directory (Read-Only)";
    }

    protected String encodePassword(String unencodedPassword) {
        if (unencodedPassword == null) {
            return null;
        }
        String encryptionAlgorithm = this.ldapPropertiesMapper.getUserEncryptionMethod();
        if (!StringUtils.isBlank((String)encryptionAlgorithm)) {
            PasswordEncoderFactory passwordEncoderFactory = (PasswordEncoderFactory)ContainerManager.getComponent((String)"passwordEncoderFactory");
            PasswordEncoder passwordEncoder = passwordEncoderFactory.getLdapEncoder(encryptionAlgorithm);
            return passwordEncoder.encodePassword(unencodedPassword, null);
        }
        return unencodedPassword;
    }

    protected void getNewUserDirectorySpecificAttributes(User user, Attributes attributes) {
        this.addDefaultSnToUserAttributes(attributes, user.getName());
    }

    public String getDescriptiveName() {
        return Rfc2307.getStaticDirectoryType();
    }

    public void addUserToGroup(String username, String groupName) throws ObjectNotFoundException {
        throw new UnsupportedOperationException("POSIX support is currently read-only");
    }

    public void addGroupToGroup(String childGroup, String parentGroup) throws ObjectNotFoundException {
        throw new UnsupportedOperationException("POSIX support is currently read-only");
    }

    public void removeUserFromGroup(String username, String groupName) throws ObjectNotFoundException {
        throw new UnsupportedOperationException("POSIX support is currently read-only");
    }

    public void removeGroupFromGroup(String childGroup, String parentGroup) throws ObjectNotFoundException {
        throw new UnsupportedOperationException("POSIX support is currently read-only");
    }

    public LDAPUserWithAttributes addUser(UserTemplate user, PasswordCredential credential) throws InvalidUserException, InvalidCredentialException, ObjectNotFoundException {
        throw new UnsupportedOperationException("POSIX support is currently read-only");
    }

    public Group addGroup(GroupTemplate group) throws InvalidGroupException, ObjectNotFoundException {
        throw new UnsupportedOperationException("POSIX support is currently read-only");
    }

    public Group renameGroup(String oldName, String newName) throws ObjectNotFoundException, InvalidGroupException {
        throw new UnsupportedOperationException("POSIX support is currently read-only");
    }

    public User renameUser(String oldName, String newName) throws ObjectNotFoundException, InvalidUserException {
        throw new UnsupportedOperationException("POSIX support is currently read-only");
    }

    public Group updateGroup(GroupTemplate group) throws ObjectNotFoundException {
        throw new UnsupportedOperationException("POSIX support is currently read-only");
    }

    public User updateUser(UserTemplate user) throws ObjectNotFoundException {
        throw new UnsupportedOperationException("POSIX support is currently read-only");
    }

    public void removeUser(String name) throws ObjectNotFoundException {
        throw new UnsupportedOperationException("POSIX support is currently read-only");
    }

    public void removeGroup(String name) throws ObjectNotFoundException {
        throw new UnsupportedOperationException("POSIX support is currently read-only");
    }
}

