/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.importer.mappers.csv;

import com.atlassian.crowd.importer.mappers.csv.CsvMapper;
import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.authentication.PasswordHelper;
import com.atlassian.crowd.integration.model.user.UserTemplateWithCredentialAndAttributes;
import org.apache.commons.collections.OrderedBidiMap;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserMapper
extends CsvMapper<UserTemplateWithCredentialAndAttributes> {
    private PasswordHelper passwordHelper;
    private Boolean setpassword;
    private Boolean encryptPassword;

    public UserMapper(Long directoryId, OrderedBidiMap configuration, PasswordHelper passwordHelper, Boolean setPassword, Boolean encryptPassword) {
        super(directoryId, configuration);
        this.passwordHelper = passwordHelper;
        this.setpassword = setPassword;
        this.encryptPassword = encryptPassword;
    }

    @Override
    public UserTemplateWithCredentialAndAttributes mapRow(String[] resultSet) {
        UserTemplateWithCredentialAndAttributes user = null;
        if (resultSet != null && resultSet.length > 0) {
            String username = this.getString(resultSet, "user.username");
            PasswordCredential credential = null;
            String password = this.getString(resultSet, "user.password");
            if (StringUtils.isNotBlank((String)password)) {
                credential = new PasswordCredential(password);
                if (this.encryptPassword.booleanValue()) {
                    credential.setEncryptedCredential(false);
                } else {
                    credential.setEncryptedCredential(true);
                }
            } else {
                credential = new PasswordCredential(this.passwordHelper.generateRandomPassword(), false);
            }
            user = new UserTemplateWithCredentialAndAttributes(username, this.directoryId, credential);
            user.setActive(true);
            user.setEmailAddress(this.getString(resultSet, "user.emailaddress"));
            String firstName = this.getString(resultSet, "user.firstname");
            String lastName = this.getString(resultSet, "user.lastname");
            user.setFirstName(firstName);
            user.setLastName(lastName);
            user.setDisplayName(firstName + " " + lastName);
        }
        return user;
    }
}

