/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.importer.importers;

import com.atlassian.crowd.importer.config.Configuration;
import com.atlassian.crowd.importer.config.DirectoryConfiguration;
import com.atlassian.crowd.importer.exceptions.ImporterException;
import com.atlassian.crowd.importer.importers.BaseImporter;
import com.atlassian.crowd.importer.model.GroupMembership;
import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.authentication.PasswordHelper;
import com.atlassian.crowd.integration.model.group.Group;
import com.atlassian.crowd.integration.model.group.GroupTemplate;
import com.atlassian.crowd.integration.model.user.InternalUser;
import com.atlassian.crowd.integration.model.user.User;
import com.atlassian.crowd.integration.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryImporter
extends BaseImporter {
    private PasswordHelper passwordHelper;

    public DirectoryImporter(DirectoryManager directoryManager, PasswordHelper passwordHelper) {
        super(directoryManager);
        this.passwordHelper = passwordHelper;
    }

    @Override
    public Collection<GroupMembership> findGroupMemberships(Configuration configuration) throws ImporterException {
        DirectoryConfiguration directoryConfiguration = (DirectoryConfiguration)configuration;
        Collection<GroupTemplate> groups = this.findGroups(configuration);
        HashSet<GroupMembership> memberships = new HashSet<GroupMembership>();
        try {
            for (GroupTemplate group : groups) {
                List members = this.directoryManager.searchDirectGroupRelationships(configuration.getDirectoryID().longValue(), QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.user()).membersOf(EntityDescriptor.group()).withName(group.getName()).returningAtMost(-1).asNames());
                for (String member : members) {
                    memberships.add(new GroupMembership(member, group.getName()));
                }
            }
        }
        catch (Exception e) {
            throw new ImporterException(e);
        }
        return memberships;
    }

    @Override
    public Collection<GroupTemplate> findGroups(Configuration configuration) throws ImporterException {
        DirectoryConfiguration directoryConfiguration = (DirectoryConfiguration)configuration;
        ArrayList<GroupTemplate> groupsToAdd = new ArrayList<GroupTemplate>();
        try {
            List groups = this.directoryManager.searchGroups(directoryConfiguration.getSourceDirectoryID().longValue(), QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1));
            for (Group group : groups) {
                GroupTemplate groupTemplate = new GroupTemplate(group);
                groupsToAdd.add(groupTemplate);
            }
        }
        catch (Exception e) {
            throw new ImporterException(e);
        }
        return groupsToAdd;
    }

    @Override
    public Collection<UserTemplateWithCredentialAndAttributes> findUsers(Configuration configuration) throws ImporterException {
        DirectoryConfiguration directoryConfiguration = (DirectoryConfiguration)configuration;
        ArrayList<UserTemplateWithCredentialAndAttributes> usersToAdd = new ArrayList<UserTemplateWithCredentialAndAttributes>();
        try {
            List users = this.directoryManager.searchUsers(directoryConfiguration.getSourceDirectoryID().longValue(), QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1));
            for (User user : users) {
                PasswordCredential credential = user instanceof InternalUser ? ((InternalUser)user).getCredential() : new PasswordCredential(this.passwordHelper.generateRandomPassword(), false);
                usersToAdd.add(new UserTemplateWithCredentialAndAttributes(user, credential));
            }
        }
        catch (Exception e) {
            throw new ImporterException(e);
        }
        return usersToAdd;
    }

    @Override
    public void init(Configuration configuration) {
    }

    @Override
    public Class getConfigurationType() {
        return DirectoryConfiguration.class;
    }
}

