/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.importer.importers;

import com.atlassian.crowd.importer.config.Configuration;
import com.atlassian.crowd.importer.importers.JdbcImporter;
import com.atlassian.crowd.importer.mappers.jdbc.GroupMapper;
import com.atlassian.crowd.importer.mappers.jdbc.MembershipMapper;
import com.atlassian.crowd.importer.mappers.jdbc.UserMapper;
import com.atlassian.crowd.integration.authentication.PasswordHelper;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import org.springframework.jdbc.core.RowMapper;

public class ConfluenceHibernateImporter
extends JdbcImporter {
    private static final String FIND_GROUPS_SQL = "SELECT groupname FROM groups ORDER BY groupname";
    private static final String FIND_USERS_SQL = "SELECT name, password, email, fullname FROM users";
    private static final String FIND_USER_GROUP_MEMBERSHIPS = "SELECT (SELECT name from users where id=userid) as username, (SELECT groupname from groups where id=groupid) as groupname from local_members";

    public ConfluenceHibernateImporter(DirectoryManager directoryManager, PasswordHelper passwordHelper) {
        super(directoryManager, passwordHelper);
    }

    public String getSelectAllGroupsSQL() {
        return FIND_GROUPS_SQL;
    }

    public String getSelectAllUsersSQL() {
        return FIND_USERS_SQL;
    }

    public String getSelectAllUserGroupMembershipsSQL() {
        return FIND_USER_GROUP_MEMBERSHIPS;
    }

    public RowMapper getGroupMapper(Configuration configuration) {
        return new GroupMapper("groupname", "groupname", configuration.getDirectoryID());
    }

    public RowMapper getMembershipMapper() {
        return new MembershipMapper("username", "groupname");
    }

    public RowMapper getUserMapper(Configuration configuration, PasswordHelper passwordHelper) {
        return new UserMapper(configuration, passwordHelper, "name", "email", "fullname", "password");
    }
}

