/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.importer.config;

import com.atlassian.crowd.importer.config.Configuration;
import com.atlassian.crowd.importer.exceptions.ImporterConfigurationException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

public class JdbcConfiguration
extends Configuration {
    private String databaseURL;
    private String databaseDriver;
    private String username;
    private String password;

    public JdbcConfiguration(Long directoryID, String application, Boolean importPasswords, String databaseURL, String databaseDriver, String username, String password) {
        super(directoryID, application, importPasswords, Boolean.FALSE);
        this.databaseURL = databaseURL;
        this.databaseDriver = databaseDriver;
        this.username = username;
        this.password = password;
    }

    public JdbcConfiguration() {
    }

    public void isValid() throws ImporterConfigurationException {
        super.isValid();
        if (StringUtils.isNotBlank((String)this.databaseURL) && StringUtils.isNotBlank((String)this.databaseDriver) && StringUtils.isNotBlank((String)this.username)) {
            Connection connection = null;
            try {
                DriverManagerDataSource driverManagerDataSource = new DriverManagerDataSource(this.getDatabaseDriver(), this.getDatabaseURL(), this.getUsername(), this.getPassword());
                connection = driverManagerDataSource.getConnection(this.getUsername(), this.getPassword());
            }
            catch (Exception e) {
                throw new ImporterConfigurationException("Could not load database connection ", e);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {}
                }
            }
        }
        throw new ImporterConfigurationException("Missing attributes for a JdbcConfiguration: Database URL: " + this.databaseURL + " Database Driver: " + this.databaseDriver + " Database Username: " + this.username);
    }

    public String getDatabaseURL() {
        return this.databaseURL;
    }

    public void setDatabaseURL(String databaseURL) {
        this.databaseURL = databaseURL;
    }

    public String getDatabaseDriver() {
        return this.databaseDriver;
    }

    public void setDatabaseDriver(String databaseDriver) {
        this.databaseDriver = databaseDriver;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JdbcConfiguration that = (JdbcConfiguration)o;
        if (this.databaseDriver != null ? !this.databaseDriver.equals(that.databaseDriver) : that.databaseDriver != null) {
            return false;
        }
        if (this.databaseURL != null ? !this.databaseURL.equals(that.databaseURL) : that.databaseURL != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        return !(this.username != null ? !this.username.equals(that.username) : that.username != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.databaseURL != null ? this.databaseURL.hashCode() : 0);
        result = 31 * result + (this.databaseDriver != null ? this.databaseDriver.hashCode() : 0);
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        return result;
    }
}

