/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory;

import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.exception.DirectoryAccessException;
import com.atlassian.crowd.integration.exception.ExpiredCredentialException;
import com.atlassian.crowd.integration.exception.InactiveAccountException;
import com.atlassian.crowd.integration.exception.InvalidAuthenticationException;
import com.atlassian.crowd.integration.exception.InvalidCredentialException;
import com.atlassian.crowd.integration.exception.InvalidGroupException;
import com.atlassian.crowd.integration.exception.InvalidMembershipException;
import com.atlassian.crowd.integration.exception.InvalidUserException;
import com.atlassian.crowd.integration.exception.MembershipNotFoundException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.model.AttributeAware;
import com.atlassian.crowd.integration.model.group.Group;
import com.atlassian.crowd.integration.model.group.GroupTemplate;
import com.atlassian.crowd.integration.model.group.GroupWithAttributes;
import com.atlassian.crowd.integration.model.user.User;
import com.atlassian.crowd.integration.model.user.UserTemplate;
import com.atlassian.crowd.integration.model.user.UserWithAttributes;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface RemoteDirectory
extends AttributeAware {
    public long getDirectoryId();

    public void setDirectoryId(long var1);

    public String getDescriptiveName();

    public void setAttributes(Map<String, String> var1);

    public User findUserByName(String var1) throws ObjectNotFoundException;

    public UserWithAttributes findUserWithAttributesByName(String var1) throws ObjectNotFoundException;

    public User authenticate(String var1, PasswordCredential var2) throws ObjectNotFoundException, InactiveAccountException, InvalidAuthenticationException, ExpiredCredentialException;

    public User addUser(UserTemplate var1, PasswordCredential var2) throws InvalidUserException, ObjectNotFoundException, InvalidCredentialException;

    public User updateUser(UserTemplate var1) throws InvalidUserException, ObjectNotFoundException;

    public void updateUserCredential(String var1, PasswordCredential var2) throws ObjectNotFoundException, InvalidCredentialException;

    public User renameUser(String var1, String var2) throws ObjectNotFoundException, InvalidUserException;

    public void storeUserAttributes(String var1, Map<String, List<String>> var2) throws ObjectNotFoundException;

    public void removeUserAttributes(String var1, String var2) throws ObjectNotFoundException;

    public void removeUser(String var1) throws ObjectNotFoundException;

    public List searchUsers(EntityQuery var1);

    public Group findGroupByName(String var1) throws ObjectNotFoundException;

    public GroupWithAttributes findGroupWithAttributesByName(String var1) throws ObjectNotFoundException;

    public Group addGroup(GroupTemplate var1) throws InvalidGroupException, ObjectNotFoundException;

    public Group updateGroup(GroupTemplate var1) throws InvalidGroupException, ObjectNotFoundException;

    public Group renameGroup(String var1, String var2) throws ObjectNotFoundException, InvalidGroupException;

    public void storeGroupAttributes(String var1, Map<String, List<String>> var2) throws ObjectNotFoundException;

    public void removeGroupAttributes(String var1, String var2) throws ObjectNotFoundException;

    public void removeGroup(String var1) throws ObjectNotFoundException;

    public List searchGroups(EntityQuery var1);

    public boolean isUserDirectGroupMember(String var1, String var2);

    public boolean isGroupDirectGroupMember(String var1, String var2);

    public void addUserToGroup(String var1, String var2) throws ObjectNotFoundException;

    public void addGroupToGroup(String var1, String var2) throws ObjectNotFoundException, InvalidMembershipException;

    public void removeUserFromGroup(String var1, String var2) throws ObjectNotFoundException, MembershipNotFoundException;

    public void removeGroupFromGroup(String var1, String var2) throws ObjectNotFoundException, InvalidMembershipException, MembershipNotFoundException;

    public List searchGroupRelationships(MembershipQuery var1);

    public void testConnection() throws DirectoryAccessException;

    public boolean supportsNestedGroups();
}

