/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.hibernate;

import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.util.persistence.hibernate.ObjectDao;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public abstract class HibernateDao
extends HibernateDaoSupport
implements ObjectDao {
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    protected BatchProcessor batchProcessor;

    public void save(Object persistentObject) throws DataAccessException {
        this.logger.debug((Object)("Saving object: " + persistentObject));
        this.getHibernateTemplate().save(persistentObject);
    }

    public void saveOrUpdate(Object persistentObject) throws DataAccessException {
        this.logger.debug((Object)("Saving or updating object: " + persistentObject));
        this.getHibernateTemplate().saveOrUpdate(persistentObject);
    }

    public void update(Object persistentObject) throws DataAccessException {
        this.logger.debug((Object)("Updating object: " + persistentObject));
        this.getHibernateTemplate().saveOrUpdate(persistentObject);
    }

    public void remove(Object persistentObject) throws DataAccessException {
        this.logger.debug((Object)("Deleting object: " + persistentObject));
        this.getHibernateTemplate().delete(persistentObject);
    }

    public Object load(final long ID) throws ObjectNotFoundException {
        Object obj = this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                return session.get(HibernateDao.this.getPersistentClass(), (Serializable)new Long(ID));
            }
        });
        if (obj == null) {
            throw new ObjectNotFoundException(this.getPersistentClass(), (Object)ID);
        }
        this.logger.debug((Object)("Loaded object: " + obj));
        return obj;
    }

    public Object loadReference(final long id) {
        return this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                return session.load(HibernateDao.this.getPersistentClass(), (Serializable)Long.valueOf(id));
            }
        });
    }

    public abstract Class getPersistentClass();

    public void setBatchProcessor(BatchProcessor batchProcessor) {
        this.batchProcessor = batchProcessor;
    }
}

