/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service.soap;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.authentication.TrustedProxyManager;
import com.atlassian.crowd.integration.authentication.AuthenticatedToken;
import com.atlassian.crowd.integration.authentication.ValidationFactor;
import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.cache.CacheManager;
import com.atlassian.crowd.manager.cache.CacheManagerException;
import com.atlassian.crowd.manager.cache.NotInCacheException;
import com.atlassian.crowd.manager.license.CrowdLicenseManager;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.RemoteAddress;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.crowd.util.RemoteAddressHelper;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.codehaus.xfire.transport.http.XFireServletController;

public class SOAPService {
    private static final Logger logger = Logger.getLogger(SOAPService.class);
    private ApplicationService applicationService;
    private ApplicationManager applicationManager;
    private PropertyManager propertyManager;
    private CacheManager cacheManager;
    private CrowdLicenseManager crowdLicenseManager;
    private TrustedProxyManager trustedProxyManager;
    private I18nHelper i18nHelper;

    public ValidationFactor[] getApplicationClientValidationFactors(String name) {
        HttpServletRequest request = this.getClientRequest();
        String remoteAddress = request.getRemoteAddr();
        String remoteHost = request.getRemoteHost();
        ArrayList<ValidationFactor> validationFactors = new ArrayList<ValidationFactor>();
        validationFactors.add(new ValidationFactor("remote_address", remoteAddress));
        validationFactors.add(new ValidationFactor("remote_host", remoteHost));
        validationFactors.add(new ValidationFactor("NAME", name));
        String remoteAddressXForwardFor = request.getHeader("X-Forwarded-For");
        if (remoteAddressXForwardFor != null && !remoteAddressXForwardFor.equals(remoteAddress)) {
            validationFactors.add(new ValidationFactor("X-Forwarded-For", remoteAddressXForwardFor));
        }
        return validationFactors.toArray(new ValidationFactor[validationFactors.size()]);
    }

    public Application validateSOAPService(AuthenticatedToken applicationToken) throws RemoteException, InvalidAuthorizationTokenException {
        try {
            logger.debug((Object)"validating license key");
            this.validateLicense();
            logger.debug((Object)("validating application token: " + applicationToken.getToken()));
            Token token = this.applicationService.validateApplicationToken(applicationToken.getToken(), this.getApplicationClientValidationFactors(applicationToken.getName()));
            logger.debug((Object)("loading application: " + token.getName()));
            Application application = this.applicationManager.findByName(token.getName());
            this.isValidRemoteAddress(application);
            return application;
        }
        catch (InvalidTokenException e) {
            throw new InvalidAuthorizationTokenException(this.i18nHelper.getText("soapservice.authenticationinvalid.exception"), (Throwable)e);
        }
        catch (ObjectNotFoundException e) {
            throw new InvalidAuthorizationTokenException(this.i18nHelper.getText("soapservice.authenticationinvalid.exception"), (Throwable)e);
        }
    }

    private HttpServletRequest getClientRequest() {
        return XFireServletController.getRequest();
    }

    private String getRemoteAddressOrTrustedXFF(HttpServletRequest request) {
        String remoteAddress = request.getRemoteAddr();
        String xForwardedFor = request.getHeader("X-Forwarded-For");
        if (xForwardedFor != null && this.trustedProxyManager.isTrusted(remoteAddress)) {
            return xForwardedFor;
        }
        return remoteAddress;
    }

    private boolean isValidRemoteAddress(Application application) throws CacheManagerException, InvalidAuthorizationTokenException {
        boolean cacheEnabled;
        HttpServletRequest request = this.getClientRequest();
        String address = this.getRemoteAddressOrTrustedXFF(request);
        String host = request.getRemoteHost();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Client address: " + address));
            logger.debug((Object)("Client host: " + host));
        }
        if (cacheEnabled = this.propertyManager.isCacheEnabled()) {
            Boolean isActive = null;
            try {
                isActive = (Boolean)this.cacheManager.get(Application.class.toString() + application.getName() + address);
                if (isActive != null && isActive.booleanValue()) {
                    return true;
                }
            }
            catch (NotInCacheException e) {
                // empty catch block
            }
            try {
                isActive = (Boolean)this.cacheManager.get(Application.class.toString() + application.getName() + host);
                if (isActive != null && isActive.booleanValue()) {
                    return true;
                }
            }
            catch (NotInCacheException e) {
                // empty catch block
            }
        }
        RemoteAddress requestAddress = new RemoteAddress(address);
        RemoteAddress requestHost = new RemoteAddress(host);
        for (RemoteAddress allowedAddress : application.getRemoteAddresses()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Comparing to accepted address: " + allowedAddress.getAddress()));
            }
            if (!RemoteAddressHelper.isAddressAllowed((RemoteAddress)allowedAddress, (RemoteAddress)requestAddress) && !RemoteAddressHelper.isAddressAllowed((RemoteAddress)allowedAddress, (RemoteAddress)requestHost)) continue;
            if (cacheEnabled) {
                this.cacheManager.put(Application.class.toString() + application.getName() + allowedAddress.getAddress(), (Serializable)Boolean.TRUE);
            }
            return true;
        }
        logger.info((Object)this.i18nHelper.getText("soapservice.clienthostinvalid.exception", (Object)EasyList.build((Object)address, (Object)host)));
        throw new InvalidAuthorizationTokenException(this.i18nHelper.getText("soapservice.clienthostinvalid.exception", (Object)EasyList.build((Object)address, (Object)host)));
    }

    protected void validateLicense() throws RemoteException {
        if (!this.crowdLicenseManager.isLicenseValid()) {
            throw new RemoteException(this.i18nHelper.getText("soapservice.licenseinvalid.exception"));
        }
    }

    public void setApplicationService(ApplicationService applicationService) {
        this.applicationService = applicationService;
    }

    public void setPropertyManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setCrowdLicenseManager(CrowdLicenseManager crowdLicenseManager) {
        this.crowdLicenseManager = crowdLicenseManager;
    }

    public void setTrustedProxyManager(TrustedProxyManager trustedProxyManager) {
        this.trustedProxyManager = trustedProxyManager;
    }

    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager = applicationManager;
    }

    public void setI18nHelper(I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
    }
}

