/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.property;

import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.manager.property.PluginPropertyManager;
import com.atlassian.crowd.model.property.Property;
import com.atlassian.crowd.model.property.PropertyDAO;
import java.util.List;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginPropertyManagerGeneric
implements PluginPropertyManager {
    public static final String KEY_PREFIX = "plugin.";
    private final PropertyDAO propertyDAO;

    public PluginPropertyManagerGeneric(PropertyDAO propertyDAO) {
        this.propertyDAO = propertyDAO;
    }

    private String generatePropertyKey(String key) {
        return key.startsWith(KEY_PREFIX) ? key : KEY_PREFIX + key;
    }

    public String getProperty(String key, String name) throws ObjectNotFoundException {
        Validate.notEmpty((String)key, (String)"You cannot find an entry with a null/empty key");
        Validate.notEmpty((String)name, (String)"You cannot find an entry with a null/empty name");
        return this.propertyDAO.find(this.generatePropertyKey(key), name).getValue();
    }

    public void setProperty(String key, String name, String value) {
        Validate.notEmpty((String)key, (String)"You cannot create an entry with a null/empty key");
        Validate.notEmpty((String)name, (String)"You cannot create an entry with a null/empty name");
        String propertyKey = this.generatePropertyKey(key);
        Property property = null;
        try {
            property = this.propertyDAO.find(propertyKey, name);
        }
        catch (ObjectNotFoundException e) {
            // empty catch block
        }
        if (property == null) {
            property = new Property(propertyKey, name, value);
        } else {
            property.setValue(value);
        }
        this.propertyDAO.update(property);
    }

    public void removeProperty(String key, String name) {
        Validate.notEmpty((String)key, (String)"You cannot remove an entry with a null/empty key");
        Validate.notEmpty((String)name, (String)"You cannot remove an entry with a null/empty name");
        if (key.startsWith(KEY_PREFIX)) {
            this.propertyDAO.remove(key, name);
        } else {
            this.propertyDAO.remove(KEY_PREFIX + key, name);
        }
    }

    public List<Property> findAll(String key) {
        Validate.notEmpty((String)key, (String)"You cannot find an entries with a null/empty key");
        if (key.startsWith(KEY_PREFIX)) {
            return this.propertyDAO.findAll(key);
        }
        return this.propertyDAO.findAll(KEY_PREFIX + key);
    }
}

