/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.bootstrap;

import com.atlassian.config.ConfigurationException;
import com.atlassian.config.bootstrap.DefaultAtlassianBootstrapManager;
import com.atlassian.config.lifecycle.events.ApplicationStartedEvent;
import com.atlassian.crowd.manager.bootstrap.CrowdBootstrapManager;
import com.atlassian.crowd.plugin.PluginUtils;
import com.atlassian.crowd.util.persistence.hibernate.MappingResources;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import com.atlassian.spring.container.ContainerManager;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.xwork.config.Configuration;
import com.opensymphony.xwork.config.ConfigurationManager;
import javax.servlet.ServletContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class CrowdBootstrapManagerImpl
extends DefaultAtlassianBootstrapManager
implements CrowdBootstrapManager {
    public String getConfigDirectory() {
        return (String)this.getProperty("crowd.config.directory");
    }

    public void setConfigDirectory(String configurationDirectory) {
        this.setProperty("crowd.config.directory", configurationDirectory);
    }

    protected void postBootstrapDatabase() {
        super.postBootstrapDatabase();
        PluginUtils.initialiseWebworkForPluginSupport((ServletContext)ServletActionContext.getServletContext());
        Configuration config = ConfigurationManager.getConfiguration();
        config.reload();
        EventManager eventManager = (EventManager)ContainerManager.getComponent((String)"eventManager");
        eventManager.publishEvent((Event)new ApplicationStartedEvent((Object)this));
    }

    public static boolean isContainterReady(ServletContext servletContext) {
        return WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext) != null;
    }

    public String getServerID() {
        return this.getString("crowd.server.id");
    }

    public void setServerID(String sid) throws ConfigurationException {
        this.setProperty("crowd.server.id", sid);
        this.save();
    }

    public void setMappingResources(MappingResources mappingResources) {
        this.setTables(mappingResources.getTableNames());
    }
}

