/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.monitor.listener;

import com.atlassian.crowd.event.remote.principal.RemoteUserCreatedEvent;
import com.atlassian.crowd.event.remote.principal.RemoteUserDeletedEvent;
import com.atlassian.crowd.event.remote.principal.RemoteUserUpdatedEvent;
import com.atlassian.crowd.integration.directory.connector.LDAPDirectory;
import com.atlassian.crowd.integration.directory.monitor.listener.ChangeListener;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.model.user.LDAPUserWithAttributes;
import com.atlassian.crowd.integration.model.user.User;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import javax.naming.Name;
import org.springframework.ldap.core.ContextMapper;

public class UserChangeListener
extends ChangeListener {
    public UserChangeListener(LDAPDirectory remoteDirectory, Name baseDN, String objectFilter, ContextMapper mapper, EventManager eventManager, boolean lookupUpdates) {
        super(remoteDirectory, baseDN, objectFilter, mapper, eventManager, lookupUpdates);
    }

    protected void publishEntityCreatedEvent(Object entity) {
        this.eventManager.publishEvent((Event)new RemoteUserCreatedEvent((Object)this, this.getDirectoryID(), (User)entity));
    }

    protected void publishEntityUpdatedEvent(Object entity) {
        this.eventManager.publishEvent((Event)new RemoteUserUpdatedEvent((Object)this, this.getDirectoryID(), (User)entity));
    }

    protected void publishEntityDeletedEvent(Object entity) {
        this.eventManager.publishEvent((Event)new RemoteUserDeletedEvent((Object)this, this.getDirectoryID(), ((User)entity).getName()));
    }

    protected Object lookupEntity(String dn) {
        try {
            return this.remoteDirectory.findEntityByDN(dn, LDAPUserWithAttributes.class);
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
    }
}

