/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.connector.mapper.attribute.group;

import com.atlassian.crowd.integration.directory.connector.mapper.attribute.AttributeMapper;
import com.atlassian.crowd.integration.directory.connector.util.IncrementalAttributeMapper;
import com.atlassian.crowd.integration.directory.connector.util.ListAttributeValueProcessor;
import com.atlassian.crowd.util.connector.DNStandardiser;
import java.util.ArrayList;
import java.util.List;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.LdapTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RFC4519MemberDnRangeMapper
implements AttributeMapper {
    public static final String ATTRIBUTE_KEY = "memberDNs";
    private final String groupMemberAttribute;
    private final boolean relaxedDnStandardisation;
    private final LdapTemplate ldapTemplate;

    public RFC4519MemberDnRangeMapper(LdapTemplate ldapTemplate, String groupMemberAttribute, boolean relaxedDnStandardisation) {
        this.groupMemberAttribute = groupMemberAttribute;
        this.relaxedDnStandardisation = relaxedDnStandardisation;
        this.ldapTemplate = ldapTemplate;
    }

    @Override
    public String getKey() {
        return ATTRIBUTE_KEY;
    }

    @Override
    public List<String> getValues(DirContextAdapter ctx) throws Exception {
        ListAttributeValueProcessor valueAggregator = new ListAttributeValueProcessor();
        IncrementalAttributeMapper incrementalAttributeMapper = new IncrementalAttributeMapper(this.groupMemberAttribute, valueAggregator);
        while (incrementalAttributeMapper.hasMore()) {
            this.ldapTemplate.lookup(ctx.getDn(), incrementalAttributeMapper.getAttributesArray(), (AttributesMapper)incrementalAttributeMapper);
        }
        ArrayList<String> standardDNs = new ArrayList<String>(valueAggregator.getValues().size());
        for (String memberDN : valueAggregator.getValues()) {
            String dn = DNStandardiser.standardise(memberDN, !this.relaxedDnStandardisation);
            standardDNs.add(dn);
        }
        return standardDNs;
    }
}

