/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.connector;

import com.atlassian.crowd.integration.directory.connector.SpringLDAPConnector;
import com.atlassian.crowd.integration.directory.connector.mapper.attribute.AttributeMapper;
import com.atlassian.crowd.integration.directory.connector.mapper.attribute.group.RFC4519MemberDnMapper;
import com.atlassian.crowd.integration.directory.connector.mapper.attribute.user.MemberOfOverlayMapper;
import com.atlassian.crowd.integration.exception.InvalidMembershipException;
import com.atlassian.crowd.integration.exception.MembershipNotFoundException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.model.DirectoryEntity;
import com.atlassian.crowd.integration.model.LDAPDirectoryEntity;
import com.atlassian.crowd.integration.model.group.GroupType;
import com.atlassian.crowd.integration.model.group.LDAPGroupWithAttributes;
import com.atlassian.crowd.integration.model.user.LDAPUserWithAttributes;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.ReturnType;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.util.search.SearchResultsUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.Name;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import org.apache.commons.lang.Validate;
import org.springframework.ldap.AttributeInUseException;
import org.springframework.ldap.NameAlreadyBoundException;
import org.springframework.ldap.OperationNotSupportedException;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.HardcodedFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RFC4519Directory
extends SpringLDAPConnector {
    @Override
    protected List<AttributeMapper> getCustomGroupAttributeMappers() {
        List<AttributeMapper> mappers = super.getCustomGroupAttributeMappers();
        mappers.add(this.getMemberDnMapper());
        return mappers;
    }

    protected AttributeMapper getMemberDnMapper() {
        return new RFC4519MemberDnMapper(this.ldapPropertiesMapper.getGroupMemberAttribute(), this.ldapPropertiesMapper.isRelaxedDnStandardisation());
    }

    @Override
    protected List<AttributeMapper> getCustomUserAttributeMappers() {
        List<AttributeMapper> mappers = super.getCustomUserAttributeMappers();
        if (this.ldapPropertiesMapper.isUsingUserMembershipAttributeForGroupMembership()) {
            mappers.add(new MemberOfOverlayMapper(this.ldapPropertiesMapper.getUserGroupMembershipsAttribute(), this.ldapPropertiesMapper.isRelaxedDnStandardisation()));
        }
        return mappers;
    }

    private List<String> getMemberDNs(LDAPGroupWithAttributes group) {
        return group.getAttributes("memberDNs");
    }

    private List<String> getMemberOfs(LDAPUserWithAttributes user) {
        return user.getAttributes("memberOf");
    }

    private boolean isDnDirectGroupMember(String memberDN, LDAPGroupWithAttributes parentGroup) {
        boolean isMember = false;
        List<String> memberDNs = this.getMemberDNs(parentGroup);
        if (memberDNs != null) {
            isMember = memberDNs.contains(memberDN);
        }
        return isMember;
    }

    public boolean isUserDirectGroupMember(String username, String groupName) {
        Validate.notEmpty((String)username, (String)"username argument cannot be null or empty");
        Validate.notEmpty((String)groupName, (String)"groupName argument cannot be null or empty");
        try {
            LDAPGroupWithAttributes group = this.findGroupByName(groupName);
            LDAPUserWithAttributes user = this.findUserByName(username);
            return this.isDnDirectGroupMember(user.getDn(), group);
        }
        catch (ObjectNotFoundException e) {
            return false;
        }
    }

    public boolean isGroupDirectGroupMember(String childGroup, String parentGroup) {
        Validate.notEmpty((String)childGroup, (String)"childGroup argument cannot be null or empty");
        Validate.notEmpty((String)parentGroup, (String)"parentGroup argument cannot be null or empty");
        try {
            LDAPGroupWithAttributes parent = this.findGroupByName(parentGroup);
            LDAPGroupWithAttributes child = this.findGroupByName(childGroup);
            return this.isDnDirectGroupMember(child.getDn(), parent);
        }
        catch (ObjectNotFoundException e) {
            return false;
        }
    }

    private void addDnToGroup(String dn, LDAPGroupWithAttributes group) {
        try {
            ModificationItem[] mods = new ModificationItem[]{new ModificationItem(1, new BasicAttribute(this.ldapPropertiesMapper.getGroupMemberAttribute(), dn))};
            this.ldapTemplate.modifyAttributes((Name)this.asLdapName(group.getDn(), LDAPDirectoryEntity.class), mods);
        }
        catch (AttributeInUseException e) {
        }
        catch (NameAlreadyBoundException e) {
        }
        catch (ObjectNotFoundException e) {
            this.logger.error((Object)("Could not modify memers of group with DN: " + dn), (Throwable)e);
        }
    }

    public void addUserToGroup(String username, String groupName) throws ObjectNotFoundException {
        Validate.notEmpty((String)username, (String)"username argument cannot be null or empty");
        Validate.notEmpty((String)groupName, (String)"groupName argument cannot be null or empty");
        LDAPGroupWithAttributes group = this.findGroupByName(groupName);
        LDAPUserWithAttributes user = this.findUserByName(username);
        this.addDnToGroup(user.getDn(), group);
    }

    public void addGroupToGroup(String childGroup, String parentGroup) throws ObjectNotFoundException, InvalidMembershipException {
        Validate.notEmpty((String)childGroup, (String)"childGroup argument cannot be null or empty");
        Validate.notEmpty((String)parentGroup, (String)"parentGroup argument cannot be null or empty");
        LDAPGroupWithAttributes parent = this.findGroupByName(parentGroup);
        LDAPGroupWithAttributes child = this.findGroupByName(childGroup);
        if (parent.getType() != child.getType()) {
            throw new InvalidMembershipException("Cannot add group of type " + child.getType().name() + " to group of type " + parent.getType().name());
        }
        this.addDnToGroup(child.getDn(), parent);
    }

    private void removeDnFromGroup(String dn, LDAPGroupWithAttributes group) {
        try {
            ModificationItem[] mods = new ModificationItem[]{new ModificationItem(3, new BasicAttribute(this.ldapPropertiesMapper.getGroupMemberAttribute(), dn))};
            this.ldapTemplate.modifyAttributes((Name)this.asLdapName(group.getDn(), LDAPDirectoryEntity.class), mods);
        }
        catch (OperationNotSupportedException e) {
        }
        catch (ObjectNotFoundException e) {
            this.logger.error((Object)("Could not modify memers of group with DN: " + dn), (Throwable)e);
        }
    }

    public void removeUserFromGroup(String username, String groupName) throws ObjectNotFoundException, MembershipNotFoundException {
        Validate.notEmpty((String)username, (String)"username argument cannot be null or empty");
        Validate.notEmpty((String)groupName, (String)"groupName argument cannot be null or empty");
        LDAPGroupWithAttributes group = this.findGroupByName(groupName);
        LDAPUserWithAttributes user = this.findUserByName(username);
        if (!this.isDnDirectGroupMember(user.getDn(), group)) {
            throw new MembershipNotFoundException(username, groupName);
        }
        this.removeDnFromGroup(user.getDn(), group);
    }

    public void removeGroupFromGroup(String childGroup, String parentGroup) throws ObjectNotFoundException, MembershipNotFoundException, InvalidMembershipException {
        Validate.notEmpty((String)childGroup, (String)"childGroup argument cannot be null or empty");
        Validate.notEmpty((String)parentGroup, (String)"parentGroup argument cannot be null or empty");
        LDAPGroupWithAttributes parent = this.findGroupByName(parentGroup);
        LDAPGroupWithAttributes child = this.findGroupByName(childGroup);
        if (!this.isDnDirectGroupMember(child.getDn(), parent)) {
            throw new MembershipNotFoundException(childGroup, parentGroup);
        }
        if (parent.getType() != child.getType()) {
            throw new InvalidMembershipException("Cannot remove group of type " + child.getType().name() + " from group of type " + parent.getType().name());
        }
        this.removeDnFromGroup(child.getDn(), parent);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected List searchGroupRelationshipsWithGroupTypeSpecified(MembershipQuery query) {
        void var2_10;
        if (query.isFindMembers()) {
            if (query.getEntityToMatch().getEntityType() != Entity.GROUP) throw new IllegalArgumentException("You can only find the GROUP or USER members of a GROUP");
            if (query.getEntityToReturn().getEntityType() == Entity.USER) {
                if (this.ldapPropertiesMapper.isUsingUserMembershipAttribute()) {
                    List<LDAPUserWithAttributes> list = this.findUserMembersOfGroupViaMemberOf(query.getEntityNameToMatch(), query.getEntityToMatch().getGroupType(), query.getStartIndex(), query.getMaxResults());
                } else {
                    List<LDAPUserWithAttributes> list = this.findUserMembersOfGroupViaMemberDN(query.getEntityNameToMatch(), query.getEntityToMatch().getGroupType(), query.getStartIndex(), query.getMaxResults());
                }
            } else {
                if (query.getEntityToReturn().getEntityType() != Entity.GROUP) throw new IllegalArgumentException("You can only find the GROUP or USER members of a GROUP");
                if (this.ldapPropertiesMapper.isNestedGroupsDisabled()) {
                    List list = Collections.emptyList();
                } else {
                    List<LDAPGroupWithAttributes> list = this.findGroupMembersOfGroupViaMemberDN(query.getEntityNameToMatch(), query.getEntityToMatch().getGroupType(), query.getStartIndex(), query.getMaxResults());
                }
            }
        } else {
            if (query.getEntityToReturn().getEntityType() != Entity.GROUP) throw new IllegalArgumentException("You can only find the GROUP memberships of USER or GROUP");
            if (query.getEntityToMatch().getEntityType() == Entity.USER) {
                if (this.ldapPropertiesMapper.isUsingUserMembershipAttributeForGroupMembership()) {
                    List<LDAPGroupWithAttributes> list = this.findGroupMembershipsOfUserViaMemberOf(query.getEntityNameToMatch(), query.getEntityToReturn().getGroupType(), query.getStartIndex(), query.getMaxResults());
                } else {
                    List<LDAPGroupWithAttributes> list = this.findGroupMembershipsOfUserViaMemberDN(query.getEntityNameToMatch(), query.getEntityToReturn().getGroupType(), query.getStartIndex(), query.getMaxResults());
                }
            } else {
                if (query.getEntityToMatch().getEntityType() != Entity.GROUP) throw new IllegalArgumentException("You can only find the GROUP memberships of USER or GROUP");
                if (this.ldapPropertiesMapper.isNestedGroupsDisabled()) {
                    List list = Collections.emptyList();
                } else {
                    List<LDAPGroupWithAttributes> list = this.findGroupMembershipsOfGroupViaMemberDN(query.getEntityNameToMatch(), query.getEntityToReturn().getGroupType(), query.getStartIndex(), query.getMaxResults());
                }
            }
        }
        if (query.getReturnType() != ReturnType.NAME) return var2_10;
        return SearchResultsUtil.convertEntitiesToNames((List<? extends DirectoryEntity>)var2_10);
    }

    private List<LDAPGroupWithAttributes> findGroupMembershipsOfUserViaMemberOf(String username, GroupType groupType, int startIndex, int maxResults) {
        List<Object> results;
        block11: {
            try {
                LDAPUserWithAttributes user = this.findUserByName(username);
                List<String> memberOfs = this.getMemberOfs(user);
                if (memberOfs != null) {
                    int totalResultSize;
                    if (maxResults == -1) {
                        results = new ArrayList<LDAPGroupWithAttributes>();
                        totalResultSize = -1;
                    } else {
                        results = new ArrayList<LDAPGroupWithAttributes>(maxResults);
                        totalResultSize = startIndex + maxResults;
                    }
                    for (String groupDN : memberOfs) {
                        try {
                            LDAPGroupWithAttributes entity = this.findEntityByDN(groupDN, LDAPGroupWithAttributes.class);
                            if (entity.getType() == groupType) {
                                results.add(entity);
                            }
                        }
                        catch (ObjectNotFoundException e) {
                            // empty catch block
                        }
                        if (totalResultSize == -1 || results.size() < totalResultSize) continue;
                        break;
                    }
                    results = SearchResultsUtil.constrainResults(results, startIndex, maxResults);
                    break block11;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("User with name <" + username + "> does not have any memberOf values and therefore has no memberships"));
                }
                results = Collections.emptyList();
            }
            catch (ObjectNotFoundException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("User with name <" + username + "> does not exist and therefore has no memberships"));
                }
                results = Collections.emptyList();
            }
        }
        return results;
    }

    private List<LDAPGroupWithAttributes> findGroupMembershipsOfUserViaMemberDN(String username, GroupType groupType, int startIndex, int maxResults) {
        try {
            LDAPUserWithAttributes user = this.findUserByName(username);
            return this.findGroupMembershipsOfEntityViaMemberDN(user.getDn(), groupType, startIndex, maxResults);
        }
        catch (ObjectNotFoundException e) {
            return Collections.emptyList();
        }
        catch (IllegalArgumentException e) {
            return Collections.emptyList();
        }
    }

    private List<LDAPGroupWithAttributes> findGroupMembershipsOfGroupViaMemberDN(String groupName, GroupType groupType, int startIndex, int maxResults) {
        try {
            LDAPGroupWithAttributes group = this.findGroupByNameAndType(groupName, groupType);
            return this.findGroupMembershipsOfEntityViaMemberDN(group.getDn(), groupType, startIndex, maxResults);
        }
        catch (ObjectNotFoundException e) {
            return Collections.emptyList();
        }
    }

    private List<LDAPGroupWithAttributes> findGroupMembershipsOfEntityViaMemberDN(String dn, GroupType groupType, int startIndex, int maxResults) {
        Name baseDN;
        ContextMapper contextMapper;
        AndFilter filter = new AndFilter();
        if (groupType == GroupType.GROUP) {
            filter.and((Filter)new HardcodedFilter(this.ldapPropertiesMapper.getGroupFilter()));
            filter.and((Filter)new EqualsFilter(this.ldapPropertiesMapper.getGroupMemberAttribute(), dn));
            contextMapper = this.getGroupContextMapper(GroupType.GROUP);
            baseDN = this.searchDN.getGroup();
        } else if (groupType == GroupType.LEGACY_ROLE) {
            filter.and((Filter)new HardcodedFilter(this.ldapPropertiesMapper.getRoleFilter()));
            filter.and((Filter)new EqualsFilter(this.ldapPropertiesMapper.getRoleMemberAttribute(), dn));
            contextMapper = this.getGroupContextMapper(GroupType.LEGACY_ROLE);
            baseDN = this.searchDN.getRole();
        } else {
            throw new IllegalArgumentException("Cannot find group memberships of entity via member DN for GroupType: " + groupType);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Executing search at DN: <" + this.searchDN.getGroup() + "> with filter: <" + filter.encode() + ">"));
        }
        return this.searchEntities(baseDN, filter.encode(), contextMapper, startIndex, maxResults);
    }

    private List<LDAPGroupWithAttributes> findGroupMembersOfGroupViaMemberDN(String groupName, GroupType groupType, int startIndex, int maxResults) {
        return this.findMembersOfGroupViaMemberDN(groupName, groupType, LDAPGroupWithAttributes.class, startIndex, maxResults);
    }

    private List<LDAPUserWithAttributes> findUserMembersOfGroupViaMemberDN(String groupName, GroupType groupType, int startIndex, int maxResults) {
        return this.findMembersOfGroupViaMemberDN(groupName, groupType, LDAPUserWithAttributes.class, startIndex, maxResults);
    }

    private List<LDAPUserWithAttributes> findUserMembersOfGroupViaMemberOf(String groupName, GroupType groupType, int startIndex, int maxResults) {
        List results;
        try {
            LDAPGroupWithAttributes group = this.findGroupWithAttributesByName(groupName);
            if (group.getType() == groupType) {
                AndFilter filter = new AndFilter();
                filter.and((Filter)new HardcodedFilter(this.ldapPropertiesMapper.getUserFilter()));
                filter.and((Filter)new EqualsFilter(this.ldapPropertiesMapper.getUserGroupMembershipsAttribute(), group.getDn()));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Executing search at DN: <" + this.searchDN.getUser() + "> with filter: <" + filter.encode() + ">"));
                }
                results = this.searchEntities(this.searchDN.getUser(), filter.encode(), this.getUserContextMapper(), startIndex, maxResults);
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Group with name <" + groupName + "> does exist but is of GroupType <" + group.getType() + "> and not <" + groupType + ">"));
                }
                results = Collections.emptyList();
            }
        }
        catch (ObjectNotFoundException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Group with name <" + groupName + "> does not exist and therefore has no members"));
            }
            results = Collections.emptyList();
        }
        return results;
    }

    private <T extends LDAPDirectoryEntity> List<T> findMembersOfGroupViaMemberDN(String groupName, GroupType groupType, Class<T> memberClass, int startIndex, int maxResults) {
        List results;
        block13: {
            try {
                LDAPGroupWithAttributes group = this.findGroupByNameAndType(groupName, groupType);
                List<String> memberDNs = this.getMemberDNs(group);
                if (memberDNs != null) {
                    int totalResultSize;
                    if (maxResults == -1) {
                        results = new ArrayList();
                        totalResultSize = -1;
                    } else {
                        results = new ArrayList(maxResults);
                        totalResultSize = startIndex + maxResults;
                    }
                    for (String memberDN : memberDNs) {
                        try {
                            T entity = this.findEntityByDN(memberDN, memberClass);
                            if (entity instanceof LDAPGroupWithAttributes) {
                                if (((LDAPGroupWithAttributes)entity).getType() == groupType) {
                                    results.add(entity);
                                }
                            } else {
                                results.add(entity);
                            }
                        }
                        catch (ObjectNotFoundException e) {
                            // empty catch block
                        }
                        if (totalResultSize == -1 || results.size() < totalResultSize) continue;
                        break;
                    }
                    results = SearchResultsUtil.constrainResults(results, startIndex, maxResults);
                    break block13;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Group with name <" + groupName + "> does not have any memberDNs and therefore has no members"));
                }
                results = Collections.emptyList();
            }
            catch (ObjectNotFoundException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Group with name <" + groupName + "> does not exist and therefore has no members"));
                }
                results = Collections.emptyList();
            }
        }
        return results;
    }
}

