/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory;

import com.atlassian.crowd.integration.model.AttributeAware;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.math.NumberUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeValuesHolder
implements AttributeAware {
    private final Map<String, String> attributes;

    public AttributeValuesHolder(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public List<String> getAttributes(String name) {
        String value = this.getAttribute(name);
        if (value != null) {
            return Arrays.asList(value);
        }
        return null;
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public long getAttributeAsLong(String name, long defaultValue) {
        String value = this.getAttribute(name);
        if (NumberUtils.isNumber((String)value)) {
            return NumberUtils.createLong((String)value);
        }
        return defaultValue;
    }

    public boolean getAttributeAsBoolean(String name, boolean defaultValue) {
        String value = this.getAttribute(name);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return defaultValue;
    }

    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }
}

