/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.attributes;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.attributes.AttributeUtil;
import org.apache.commons.attributes.Attributes;

public class AttributeIndex {
    private final HashMap index = new HashMap();
    private final ClassLoader classLoader;
    static /* synthetic */ Class class$org$apache$commons$attributes$Indexed;

    public AttributeIndex(ClassLoader cl) throws Exception {
        this.classLoader = cl;
        Enumeration<URL> enumeration = cl.getResources("META-INF/attrs.index");
        while (enumeration.hasMoreElements()) {
            URL url = enumeration.nextElement();
            this.loadFromURL(url);
        }
        Iterator iter = this.index.values().iterator();
        while (iter.hasNext()) {
            ((IndexNode)iter.next()).seal();
        }
    }

    private IndexNode getNode(Class attributeClass) {
        IndexNode node = (IndexNode)this.index.get(attributeClass.getName());
        if (node == null) {
            node = new IndexNode();
            this.index.put(attributeClass.getName(), node);
        }
        return node;
    }

    private void addIndex(Collection attributes, Class clazz) {
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            this.getNode(iter.next().getClass()).classes.add(clazz);
        }
    }

    private void addIndex(Collection attributes, Field field) {
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            this.getNode(iter.next().getClass()).fields.add(field);
        }
    }

    private void addIndex(Collection attributes, Method method) {
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            this.getNode(iter.next().getClass()).methods.add(method);
        }
    }

    private void addIndex(Collection attributes, Constructor constructor) {
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            this.getNode(iter.next().getClass()).constructors.add(constructor);
        }
    }

    private void addReturnIndex(Collection attributes, Method method) {
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            this.getNode(iter.next().getClass()).returnValues.add(method);
        }
    }

    private void addIndex(Collection attributes, Method method, int parameter) {
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            this.getNode(iter.next().getClass()).methodParameters.add(new MethodParameter(method, parameter));
        }
    }

    private void addIndex(Collection attributes, Constructor ctor, int parameter) {
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            this.getNode(iter.next().getClass()).constructorParameters.add(new ConstructorParameter(ctor, parameter));
        }
    }

    private void addClass(String clazzName) throws Exception {
        Class<?> clazz = this.classLoader.loadClass(clazzName);
        Collection coll = Attributes.getAttributes(clazz);
        coll = AttributeUtil.getObjectsWithAttributeType(coll, class$org$apache$commons$attributes$Indexed == null ? (class$org$apache$commons$attributes$Indexed = AttributeIndex.class$("org.apache.commons.attributes.Indexed")) : class$org$apache$commons$attributes$Indexed);
        this.addIndex(coll, clazz);
        Field[] fields = clazz.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            coll = Attributes.getAttributes(fields[i]);
            coll = AttributeUtil.getObjectsWithAttributeType(coll, class$org$apache$commons$attributes$Indexed == null ? AttributeIndex.class$("org.apache.commons.attributes.Indexed") : class$org$apache$commons$attributes$Indexed);
            this.addIndex(coll, fields[i]);
            ++i;
        }
        Method[] methods = clazz.getDeclaredMethods();
        int i2 = 0;
        while (i2 < methods.length) {
            coll = Attributes.getAttributes(methods[i2]);
            coll = AttributeUtil.getObjectsWithAttributeType(coll, class$org$apache$commons$attributes$Indexed == null ? AttributeIndex.class$("org.apache.commons.attributes.Indexed") : class$org$apache$commons$attributes$Indexed);
            this.addIndex(coll, methods[i2]);
            coll = Attributes.getReturnAttributes(methods[i2]);
            coll = AttributeUtil.getObjectsWithAttributeType(coll, class$org$apache$commons$attributes$Indexed == null ? AttributeIndex.class$("org.apache.commons.attributes.Indexed") : class$org$apache$commons$attributes$Indexed);
            this.addReturnIndex(coll, methods[i2]);
            int numParameters = methods[i2].getParameterTypes().length;
            int j = 0;
            while (j < numParameters) {
                coll = Attributes.getParameterAttributes(methods[i2], j);
                coll = AttributeUtil.getObjectsWithAttributeType(coll, class$org$apache$commons$attributes$Indexed == null ? AttributeIndex.class$("org.apache.commons.attributes.Indexed") : class$org$apache$commons$attributes$Indexed);
                this.addIndex(coll, methods[i2], j);
                ++j;
            }
            ++i2;
        }
        Constructor<?>[] ctors = clazz.getDeclaredConstructors();
        int i3 = 0;
        while (i3 < ctors.length) {
            coll = Attributes.getAttributes(ctors[i3]);
            coll = AttributeUtil.getObjectsWithAttributeType(coll, class$org$apache$commons$attributes$Indexed == null ? AttributeIndex.class$("org.apache.commons.attributes.Indexed") : class$org$apache$commons$attributes$Indexed);
            this.addIndex(coll, ctors[i3]);
            int numParameters = ctors[i3].getParameterTypes().length;
            int j = 0;
            while (j < numParameters) {
                coll = Attributes.getParameterAttributes(ctors[i3], j);
                coll = AttributeUtil.getObjectsWithAttributeType(coll, class$org$apache$commons$attributes$Indexed == null ? AttributeIndex.class$("org.apache.commons.attributes.Indexed") : class$org$apache$commons$attributes$Indexed);
                this.addIndex(coll, ctors[i3], j);
                ++j;
            }
            ++i3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromURL(URL url) throws Exception {
        URLConnection connection = url.openConnection();
        BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        try {
            Object currentAttributeClass = null;
            String line = null;
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("Class: ")) continue;
                String className = line.substring("Class: ".length()).trim();
                this.addClass(className);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            br.close();
            throw throwable;
        }
        br.close();
    }

    public Collection getClassesWithAttribute(String attributeClass) {
        if (this.index.containsKey(attributeClass)) {
            Collection classes = ((IndexNode)this.index.get((Object)attributeClass)).classes;
            Iterator iter = classes.iterator();
            ArrayList<String> converted = new ArrayList<String>(classes.size());
            while (iter.hasNext()) {
                converted.add(((Class)iter.next()).getName().replace('$', '.'));
            }
            return converted;
        }
        return Collections.EMPTY_SET;
    }

    public Collection getClassesWithAttribute(Class attributeClass) {
        return this.getClassesWithAttribute(attributeClass.getName());
    }

    public Collection getClasses(Class attributeClass) {
        if (this.index.containsKey(attributeClass.getName())) {
            return ((IndexNode)this.index.get((Object)attributeClass.getName())).classes;
        }
        return Collections.EMPTY_SET;
    }

    public Collection getMethods(Class attributeClass) {
        if (this.index.containsKey(attributeClass.getName())) {
            return ((IndexNode)this.index.get((Object)attributeClass.getName())).methods;
        }
        return Collections.EMPTY_SET;
    }

    public Collection getMethodsReturning(Class attributeClass) {
        if (this.index.containsKey(attributeClass.getName())) {
            return ((IndexNode)this.index.get((Object)attributeClass.getName())).returnValues;
        }
        return Collections.EMPTY_SET;
    }

    public Collection getFields(Class attributeClass) {
        if (this.index.containsKey(attributeClass.getName())) {
            return ((IndexNode)this.index.get((Object)attributeClass.getName())).fields;
        }
        return Collections.EMPTY_SET;
    }

    public Collection getConstructors(Class attributeClass) {
        if (this.index.containsKey(attributeClass.getName())) {
            return ((IndexNode)this.index.get((Object)attributeClass.getName())).constructors;
        }
        return Collections.EMPTY_SET;
    }

    public Collection getConstructorParameters(Class attributeClass) {
        if (this.index.containsKey(attributeClass.getName())) {
            return ((IndexNode)this.index.get((Object)attributeClass.getName())).constructorParameters;
        }
        return Collections.EMPTY_SET;
    }

    public Collection getMethodParameters(Class attributeClass) {
        if (this.index.containsKey(attributeClass.getName())) {
            return ((IndexNode)this.index.get((Object)attributeClass.getName())).methodParameters;
        }
        return Collections.EMPTY_SET;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class IndexNode {
        public Collection classes = new HashSet();
        public Collection fields = new HashSet();
        public Collection methods = new HashSet();
        public Collection constructors = new HashSet();
        public Collection returnValues = new HashSet();
        public Collection constructorParameters = new HashSet();
        public Collection methodParameters = new HashSet();

        private IndexNode() {
        }

        public void seal() {
            this.classes = this.seal(this.classes);
            this.fields = this.seal(this.fields);
            this.methods = this.seal(this.methods);
            this.constructors = this.seal(this.constructors);
            this.returnValues = this.seal(this.returnValues);
            this.constructorParameters = this.seal(this.constructorParameters);
            this.methodParameters = this.seal(this.methodParameters);
        }

        private Collection seal(Collection coll) {
            return Collections.unmodifiableCollection(coll);
        }
    }

    public static class ConstructorParameter {
        private final Constructor ctor;
        private final int index;

        public ConstructorParameter(Constructor ctor, int index) {
            this.ctor = ctor;
            this.index = index;
        }

        public Constructor getConstructor() {
            return this.ctor;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean equals(Object o) {
            return o != null && o instanceof ConstructorParameter && this.ctor.equals(((ConstructorParameter)o).ctor) && this.index == ((ConstructorParameter)o).index;
        }

        public int hashCode() {
            return this.ctor.hashCode() + this.index;
        }

        public String toString() {
            return this.ctor.toString() + ":" + this.index;
        }
    }

    public static class MethodParameter {
        private final Method method;
        private final int index;

        public MethodParameter(Method method, int index) {
            this.method = method;
            this.index = index;
        }

        public Method getMethod() {
            return this.method;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean equals(Object o) {
            return o != null && o instanceof MethodParameter && this.method.equals(((MethodParameter)o).method) && this.index == ((MethodParameter)o).index;
        }

        public int hashCode() {
            return this.method.hashCode() + this.index;
        }

        public String toString() {
            return this.method.toString() + ":" + this.index;
        }
    }
}

