/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.model.directory.DirectoryType;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.SearchRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.DirectoryTermKeys;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpgradeTask396
implements UpgradeTask {
    private DirectoryManager directoryManager;
    private final Collection<String> errors = new ArrayList<String>();

    @Override
    public String getBuildNumber() {
        return "396";
    }

    @Override
    public String getShortDescription() {
        return "Disabling caching for LDAP directories with roles enabled";
    }

    @Override
    public void doUpgrade() throws Exception {
        List ldapDirectories = this.directoryManager.searchDirectories(QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Restriction.on((Property)DirectoryTermKeys.TYPE).exactlyMatching((Object)DirectoryType.CONNECTOR)).returningAtMost(-1));
        for (Directory directory : ldapDirectories) {
            if (Boolean.parseBoolean(directory.getAttribute("ldap.roles.disabled"))) continue;
            directory.setAttribute("useCaching", Boolean.FALSE.toString());
            directory.setAttribute("useMonitoring", Boolean.FALSE.toString());
            this.directoryManager.updateDirectory(directory);
        }
    }

    @Override
    public Collection<String> getErrors() {
        return this.errors;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }
}

