/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.model.directory.DirectoryType;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpgradeTask361
implements UpgradeTask {
    private DirectoryManager directoryManager;
    private final Collection<String> errors = new ArrayList<String>();

    @Override
    public String getBuildNumber() {
        return "361";
    }

    @Override
    public String getShortDescription() {
        return "Setting ldap.roles.disabled=false for directories without the property set";
    }

    @Override
    public void doUpgrade() throws Exception {
        List directories = this.directoryManager.searchDirectories(QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.directory()).returningAtMost(-1));
        for (Directory directory : directories) {
            String disabled;
            if (DirectoryType.CONNECTOR != directory.getType() || (disabled = directory.getAttribute("ldap.roles.disabled")) != null) continue;
            directory.setAttribute("ldap.roles.disabled", Boolean.FALSE.toString());
            this.directoryManager.updateDirectory(directory);
        }
    }

    @Override
    public Collection<String> getErrors() {
        return this.errors;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }
}

