/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpgradeTask215
implements UpgradeTask {
    private Collection errors = new ArrayList();
    private DirectoryManager directoryManager;

    public String getBuildNumber() {
        return "215";
    }

    public String getShortDescription() {
        return "Removing superfluous paged results size attribute(ldap.pagedresults.size) from directories that don't paged results configured.";
    }

    public void doUpgrade() throws Exception {
        List directories = this.directoryManager.searchDirectories(QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.directory()).returningAtMost(-1));
        for (Directory directory : directories) {
            Boolean usingPagedResults = Boolean.valueOf(directory.getAttribute("ldap.pagedresults"));
            if (usingPagedResults.booleanValue()) continue;
            directory.removeAttribute("ldap.pagedresults.size");
            this.directoryManager.updateDirectory(directory);
        }
    }

    public Collection getErrors() {
        return this.errors;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }
}

