/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.interceptor;

import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.Interceptor;
import com.opensymphony.xwork.util.LocalizedTextUtil;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class I18nInterceptor
implements Interceptor {
    protected static final Log log = LogFactory.getLog((Class)I18nInterceptor.class);
    public static final String DEFAULT_SESSION_ATTRIBUTE = "WW_TRANS_I18N_LOCALE";
    public static final String DEFAULT_PARAMETER = "request_locale";
    protected String parameterName = "request_locale";
    protected String attributeName = "WW_TRANS_I18N_LOCALE";

    public I18nInterceptor() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"new I18nInterceptor()");
        }
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public void init() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"init()");
        }
    }

    public void destroy() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"destroy()");
        }
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        Map session;
        Map params;
        Object requested_locale;
        if (log.isDebugEnabled()) {
            log.debug((Object)("intercept '" + invocation.getProxy().getNamespace() + "/" + invocation.getProxy().getActionName() + "' { "));
        }
        if ((requested_locale = (params = invocation.getInvocationContext().getParameters()).remove(this.parameterName)) != null && requested_locale.getClass().isArray() && ((Object[])requested_locale).length == 1) {
            requested_locale = ((Object[])requested_locale)[0];
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("requested_locale=" + requested_locale));
        }
        if ((session = invocation.getInvocationContext().getSession()) != null) {
            Object locale;
            if (requested_locale != null) {
                Locale locale2 = locale = requested_locale instanceof Locale ? (Locale)requested_locale : LocalizedTextUtil.localeFromString(requested_locale.toString(), null);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("store locale=" + locale));
                }
                if (locale != null) {
                    session.put(this.attributeName, locale);
                }
            }
            if ((locale = session.get(this.attributeName)) != null && locale instanceof Locale) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("apply locale=" + locale));
                }
                this.saveLocale(invocation, (Locale)locale);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("before Locale=" + invocation.getStack().findValue("locale")));
        }
        String result = invocation.invoke();
        if (log.isDebugEnabled()) {
            log.debug((Object)("after Locale=" + invocation.getStack().findValue("locale")));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"intercept } ");
        }
        return result;
    }

    protected void saveLocale(ActionInvocation invocation, Locale locale) {
        invocation.getInvocationContext().setLocale(locale);
    }
}

