<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="/webwork" prefix="ww" %>

<html>
<head>
    <title>
        <ww:text name="menu.viewdirectory.label">
            <ww:param id="0" value="directory.name"/>
        </ww:text>
    </title>

    <meta name="section" content="directories"/>
    <meta name="pagename" content="view"/>
    <meta name="help.url" content="<ww:property value="getText('help.directory.connector.configuration')"/>"/>

    <script type="text/javascript" language="javascript">
        function hideShowRoleConfiguration()
        {
            // get the form
            var form = document.configuration_details;

            // hide role configuration if "Disable Roles" is checked
            if (form.rolesDisabled.checked)
            {
                document.getElementById("roleConfiguration").style.display="none";
            }
            else
            {
                document.getElementById("roleConfiguration").style.display="block";
            }
        }

                
        function testGroupSearch()
        {
            document.configuration_details.action = "<ww:url namespace="/console/secure/directory" action="testUpdateGroupSearch" method="testUpdateGroupSearch" includeParams="none"/>";

            document.configuration_details.submit();
        }

        function testRoleSearch()
        {
            document.configuration_details.action = "<ww:url namespace="/console/secure/directory" action="testUpdateRoleSearch" method="testUpdateRoleSearch" includeParams="none"/>";

            document.configuration_details.submit();
        }

        function testPrincipalSearch()
        {
            document.configuration_details.action = "<ww:url namespace="/console/secure/directory" action="testUpdatePrincipalSearch" method="testUpdatePrincipalSearch" includeParams="none"/>";

            document.configuration_details.submit();
        }

    </script>
</head>
<body onload="hideShowRoleConfiguration();">
<h2>
    <ww:text name="menu.viewdirectory.label">
        <ww:param id="0" value="directory.name"/>
    </ww:text>
</h2>

<div class="page-content">

<ul class="tabs">

    <li>
        <a id="connector-general"
           href="<ww:url namespace="/console/secure/directory" action="viewconnector" includeParams="none"><ww:param name="ID" value="ID" /></ww:url>"><ww:text
                name="menu.details.label"/></a>
    </li>

    <li>
        <a id="connector-connectiondetails"
           href="<ww:url namespace="/console/secure/directory" action="updateconnectorconnection" includeParams="none"><ww:param name="ID" value="ID" /></ww:url>"><ww:text name="menu.connector.label"/></a>
    </li>

    <li class="on">
        <span class="tab"><ww:text name="menu.configuration.label"/></span>
    </li>

    <li>
        <a id="connector-permissions"
           href="<ww:url namespace="/console/secure/directory" action="updateconnectorpermissions" includeParams="none"><ww:param name="ID" value="ID" /></ww:url>"><ww:text
                name="menu.permissions.label"/></a>
    </li>

    <li>
        <a id="connector-options" href="<ww:url namespace="/console/secure/directory" action="updateconnectoroptions" includeParams="none"><ww:param name="ID" value="ID" /></ww:url>"><ww:text name="menu.optional.label"/></a>
    </li>

</ul>

<div class="tabContent static" id="tab3">

<div class="crowdForm">
    <form id="configuration_details" name="configuration_details" method="post" action="<ww:url namespace="/console/secure/directory" action="updateconnectorconfiguration" method="update" includeParams="none" />">

            <div class="formBody">

                <ww:component template="form_messages.jsp"/>

                <input type="hidden" name="ID" value="<ww:property value="ID" />"/>

                <h3>
                    <ww:property value="getText('directoryconnector.userconfiguration.label')"/>
                </h3>

                <ww:textfield name="userDNaddition" size="35px;">
                    <ww:param name="label" value="getText('directoryconnector.userdnaddition.label')"/>
                    <ww:param name="description">
                        <ww:property value="getText('directoryconnector.userdnaddition.description')"/>
                    </ww:param>
                </ww:textfield>

                <ww:textfield name="userObjectClass" size="35px;">
                    <ww:param name="label" value="getText('directoryconnector.userobjectclass.label')"/>
                    <ww:param name="description">
                        <ww:property value="getText('directoryconnector.userobjectclass.description')"/>
                    </ww:param>
                    <ww:param name="required" value="true" />
                </ww:textfield>

                <ww:textfield name="userObjectFilter" size="35px;">
                    <ww:param name="label" value="getText('directoryconnector.userobjectfilter.label')"/>
                    <ww:param name="description">
                        <ww:property value="getText('directoryconnector.userobjectfilter.description')"/>
                    </ww:param>
                    <ww:param name="required" value="true" />
                </ww:textfield>

                <ww:textfield name="userNameAttr" size="35px;">
                    <ww:param name="label" value="getText('directoryconnector.usernameattribute.label')"/>
                    <ww:param name="description">
                        <ww:property value="getText('directoryconnector.usernameattribute.description')"/>
                    </ww:param>
                    <ww:param name="required" value="true" />
                </ww:textfield>

                <ww:textfield name="userNameRdnAttr" size="35px;">
                    <ww:param name="label" value="getText('directoryconnector.usernamerdnattribute.label')"/>
                    <ww:param name="description">
                        <ww:property value="getText('directoryconnector.usernamerdnattribute.description')"/>
                    </ww:param>
                    <ww:param name="required" value="true" />
                </ww:textfield>

                <ww:textfield name="userFirstnameAttr" size="35px;">
                    <ww:param name="label" value="getText('directoryconnector.userfirstnameattribute.label')"/>
                    <ww:param name="description">
                        <ww:property value="getText('directoryconnector.userfirstnameattribute.description')"/>
                    </ww:param>
                    <ww:param name="required" value="true" />
                </ww:textfield>

                <ww:textfield name="userLastnameAttr" size="35px;">
                    <ww:param name="label" value="getText('directoryconnector.userlastnameattribute.label')"/>
                    <ww:param name="description">
                        <ww:property value="getText('directoryconnector.userlastnameattribute.description')"/>
                    </ww:param>
                    <ww:param name="required" value="true" />
                </ww:textfield>

                <ww:textfield name="userDisplayNameAttr" size="35px;">
                    <ww:param name="label" value="getText('directoryconnector.userdisplaynameattribute.label')"/>
                    <ww:param name="description">
                        <ww:property value="getText('directoryconnector.userdisplaynameattribute.description')"/>
                    </ww:param>
                    <ww:param name="required" value="true" />
                </ww:textfield>

                <ww:textfield name="userMailAttr" size="35px;">
                    <ww:param name="label" value="getText('directoryconnector.usermailattribute.label')"/>
                    <ww:param name="description">
                        <ww:property value="getText('directoryconnector.usermailattribute.description')"/>
                    </ww:param>
                    <ww:param name="required" value="true" />
                </ww:textfield>

                <ww:textfield name="userGroupMemberAttr" size="35px;">
                    <ww:param name="label" value="getText('directoryconnector.usermemberofattribute.label')"/>
                    <ww:param name="description">
                        <ww:property value="getText('directoryconnector.usermemberofattribute.description')"/>
                    </ww:param>
                    <ww:param name="required" value="true" />
                </ww:textfield>

                <ww:textfield name="userPasswordAttr" size="35px;">
                    <ww:param name="label" value="getText('directoryconnector.userpassword.label')"/>
                    <ww:param name="description">
                        <ww:property value="getText('directoryconnector.userpassword.description')"/>
                    </ww:param>
                    <ww:param name="required" value="true" />
                </ww:textfield>

                <div class="textFieldButton buttons" style="">
                    <input id="test-search-principal" type="button" class="button" style="width: 125px;" value="<ww:property value="getText('directoryconnector.testsearch.label')"/>" onClick="testPrincipalSearch();"/>
                </div>

                <h3>
                    <ww:property value="getText('directoryconnector.groupconfiguration.label')"/>
                </h3>

                <ww:textfield name="groupDNaddition" size="35px;">
                    <ww:param name="label" value="getText('directoryconnector.groupdnaddition.label')"/>
                    <ww:param name="description">
                        <ww:property value="getText('directoryconnector.groupdnaddition.description')"/>
                    </ww:param>
                </ww:textfield>

                <ww:textfield name="groupObjectClass" size="35px;">
                    <ww:param name="label" value="getText('directoryconnector.groupobjectclass.label')"/>
                    <ww:param name="description">
                        <ww:property value="getText('directoryconnector.groupobjectclass.description')"/>
                    </ww:param>
                    <ww:param name="required" value="true" />
                </ww:textfield>

                <ww:textfield name="groupObjectFilter" size="35px;">
                    <ww:param name="label" value="getText('directoryconnector.groupobjectfilter.label')"/>
                    <ww:param name="description">
                        <ww:property value="getText('directoryconnector.groupobjectfilter.description')"/>
                    </ww:param>
                    <ww:param name="required" value="true" />
                </ww:textfield>

                <ww:textfield name="groupNameAttr" size="35px;">
                    <ww:param name="label" value="getText('directoryconnector.groupname.label')"/>
                    <ww:param name="description">
                        <ww:property value="getText('directoryconnector.groupname.description')"/>
                    </ww:param>
                    <ww:param name="required" value="true" />
                </ww:textfield>

                <ww:textfield name="groupDescriptionAttr" size="35px;">
                    <ww:param name="label" value="getText('directoryconnector.groupdescription.label')"/>
                    <ww:param name="description">
                        <ww:property value="getText('directoryconnector.groupdescription.description')"/>
                    </ww:param>
                    <ww:param name="required" value="true" />
                </ww:textfield>

                <ww:textfield name="groupMemberAttr" size="35px;">
                    <ww:param name="label" value="getText('directoryconnector.groupmember.label')"/>
                    <ww:param name="description">
                        <ww:property value="getText('directoryconnector.groupmember.description')"/>
                    </ww:param>
                    <ww:param name="required" value="true" />
                </ww:textfield>

                <div class="textFieldButton buttons" style="">
                    <input id="test-search-group" type="button" class="button" style="width: 125px;" value="<ww:property value="getText('directoryconnector.testsearch.label')"/>" onClick="testGroupSearch();"/>
                </div>

                <h3>
                    <ww:property value="getText('directoryconnector.roleconfiguration.label')"/>
                </h3>

                <ww:checkbox name="rolesDisabled" fieldValue="true" onchange="javascript:hideShowRoleConfiguration();">
                    <ww:param name="label" value="getText('directoryconnector.rolesdisabled.label')"/>
                    <ww:param name="description">
                        <ww:property value="getText('directoryconnector.rolesdisabled.description')"/>
                    </ww:param>
                </ww:checkbox>

                <div id="roleConfiguration">
                    <ww:textfield name="roleDNaddition" size="35px;">
                        <ww:param name="label" value="getText('directoryconnector.rolednaddition.label')"/>
                        <ww:param name="description">
                            <ww:property value="getText('directoryconnector.rolednaddition.description')"/>
                        </ww:param>
                    </ww:textfield>

                    <ww:textfield name="roleObjectClass" size="35px;">
                        <ww:param name="label" value="getText('directoryconnector.roleobjectclass.label')"/>
                        <ww:param name="description">
                            <ww:property value="getText('directoryconnector.roleobjectclass.description')"/>
                        </ww:param>
                        <ww:param name="required" value="true" />
                    </ww:textfield>

                    <ww:textfield name="roleObjectFilter" size="35px;">
                        <ww:param name="label" value="getText('directoryconnector.roleobjectfilter.label')"/>
                        <ww:param name="description">
                            <ww:property value="getText('directoryconnector.roleobjectfilter.description')"/>
                        </ww:param>
                        <ww:param name="required" value="true" />
                    </ww:textfield>

                    <ww:textfield name="roleNameAttr" size="35px;">
                        <ww:param name="label" value="getText('directoryconnector.rolename.label')"/>
                        <ww:param name="description">
                            <ww:property value="getText('directoryconnector.rolename.description')"/>
                        </ww:param>
                        <ww:param name="required" value="true" />
                    </ww:textfield>

                    <ww:textfield name="roleDescriptionAttr" size="35px;">
                        <ww:param name="label" value="getText('directoryconnector.roledescription.label')"/>
                        <ww:param name="description">
                            <ww:property value="getText('directoryconnector.roledescription.description')"/>
                        </ww:param>
                        <ww:param name="required" value="true" />
                    </ww:textfield>

                    <ww:textfield name="roleMemberAttr" size="35px;">
                        <ww:param name="label" value="getText('directoryconnector.rolemember.label')"/>
                        <ww:param name="description">
                            <ww:property value="getText('directoryconnector.rolemember.description')"/>
                        </ww:param>
                        <ww:param name="required" value="true" />
                    </ww:textfield>


                    <div class="textFieldButton buttons" style="">
                        <input id="test-search-role" type="button" class="button" style="width: 125px;" value="<ww:property value="getText('directoryconnector.testsearch.label')"/>" onClick="testRoleSearch();"/>
                    </div>

                </div>

            </div>

            <div class="formFooter wizardFooter">
                <div class="buttons">
                    <input type="submit" class="button" value="<ww:property value="getText('update.label')"/> &raquo;"/>
                    <input type="button" class="button" value="<ww:property value="getText('cancel.label')"/>"
                           onClick="window.location='<ww:url namespace="/console/secure/directory" action="viewconnector" method="default" includeParams="none" ><ww:param name="ID" value="ID" /></ww:url>';"/>
                </div>
            </div>

        </form>

    </div>

</div>

</div>
</body>
</html>