/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service;

import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.authentication.UserAuthenticationContext;
import com.atlassian.crowd.integration.authentication.ValidationFactor;
import com.atlassian.crowd.integration.exception.DirectoryAccessException;
import com.atlassian.crowd.integration.exception.InactiveAccountException;
import com.atlassian.crowd.integration.exception.InvalidAuthenticationException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetails;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetailsService;
import com.atlassian.crowd.manager.application.ApplicationAccessDeniedException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.service.UserService;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import org.springframework.dao.DataAccessException;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.anonymous.AnonymousAuthenticationToken;
import org.springframework.security.userdetails.UsernameNotFoundException;

public class UserServiceImpl
implements UserService {
    private final ApplicationManager applicationManager;
    private final ApplicationService applicationService;
    private final CrowdUserDetailsService crowdUserDetailsService;

    public UserServiceImpl(ApplicationManager applicationManager, ApplicationService applicationService, CrowdUserDetailsService crowdUserDetailsService) {
        this.applicationManager = applicationManager;
        this.applicationService = applicationService;
        this.crowdUserDetailsService = crowdUserDetailsService;
    }

    public String getRemoteUsername() {
        String username = null;
        CrowdUserDetails userDetails = this.getCrowdUserDetails();
        if (userDetails != null) {
            username = userDetails.getUsername();
        }
        return username;
    }

    private CrowdUserDetails getCrowdUserDetails() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null && !(auth instanceof AnonymousAuthenticationToken) && auth.getPrincipal() != null && auth.getPrincipal() instanceof CrowdUserDetails) {
            return (CrowdUserDetails)auth.getPrincipal();
        }
        return null;
    }

    public String getAuthenticatedUsername(HttpServletRequest request) {
        return this.getRemoteUsername();
    }

    public boolean isUserInGroup(String username, String group) {
        Application application = this.getCrowdApplication();
        try {
            return this.applicationService.isUserNestedGroupMember(application, username, group);
        }
        catch (DirectoryAccessException e) {
            throw new RuntimeException("Failed to connect to underlying directory", e);
        }
    }

    private Application getCrowdApplication() {
        Application application;
        try {
            application = this.applicationManager.findByName(ApplicationType.CROWD.getDisplayName());
        }
        catch (ObjectNotFoundException e) {
            throw new RuntimeException("Failed to find Crowd application for service, with name: <" + ApplicationType.CROWD.getDisplayName() + ">", e);
        }
        return application;
    }

    public boolean isSystemAdmin(String username) throws DataAccessException {
        try {
            CrowdUserDetails userDetails = this.crowdUserDetailsService.loadUserByUsername(username);
            String adminRole = this.crowdUserDetailsService.getAuthorityPrefix() + this.crowdUserDetailsService.getAuthoritySuffix();
            for (int i = 0; i < userDetails.getAuthorities().length; ++i) {
                if (!userDetails.getAuthorities()[i].getAuthority().equals(adminRole)) continue;
                return true;
            }
        }
        catch (UsernameNotFoundException usernameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public boolean authenticate(String username, String password) {
        UserAuthenticationContext context = this.buildUserAuthenticationContext(username, password);
        try {
            Token token = this.applicationService.authenticateUser(context);
            if (token.getRandomHash() != null) {
                return true;
            }
        }
        catch (InvalidAuthenticationException e) {
            return false;
        }
        catch (DirectoryAccessException e) {
            throw new RuntimeException("Failed to authenticate user due to: " + e.getMessage(), e);
        }
        catch (InactiveAccountException e) {
            return false;
        }
        catch (ApplicationAccessDeniedException e) {
            return false;
        }
        return false;
    }

    public Principal resolve(String username) throws DataAccessException {
        final CrowdUserDetails userDetails = this.crowdUserDetailsService.loadUserByUsername(username);
        if (userDetails != null) {
            return new Principal(){

                public String getName() {
                    return userDetails.getUsername();
                }
            };
        }
        return null;
    }

    private UserAuthenticationContext buildUserAuthenticationContext(String username, String password) {
        UserAuthenticationContext context = new UserAuthenticationContext();
        context.setApplication(ApplicationType.CROWD.getDisplayName());
        context.setName(username);
        context.setCredential(new PasswordCredential(password));
        context.setValidationFactors(new ValidationFactor[0]);
        return context;
    }
}

