/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.token;

import com.atlassian.config.lifecycle.events.ApplicationStartedEvent;
import com.atlassian.crowd.event.XMLRestoreFinishedEvent;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.manager.property.PropertyManagerException;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.model.token.TokenDAO;
import com.atlassian.crowd.model.token.TokenDAOPersistence;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.dao.DataAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenDAOProxy
implements TokenDAO,
ApplicationListener {
    private static final Logger logger = Logger.getLogger(TokenDAOProxy.class);
    private TokenDAO implementation;
    private TokenDAOPersistence daoMemory;
    private TokenDAOPersistence daoHibernate;
    private ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private PropertyManager propertyManager;

    public TokenDAOProxy(boolean initialUseIsMemory, TokenDAOPersistence daoMemory, TokenDAOPersistence daoHibernate, PropertyManager propertyManager) {
        this.daoMemory = daoMemory;
        this.daoHibernate = daoHibernate;
        this.implementation = initialUseIsMemory ? daoMemory : daoHibernate;
        this.propertyManager = propertyManager;
    }

    public TokenDAOProxy(TokenDAOPersistence daoMemory, TokenDAOPersistence daoHibernate, PropertyManager propertyManager) {
        this(Boolean.FALSE, daoMemory, daoHibernate, propertyManager);
    }

    private void lockRead() {
        this.readWriteLock.readLock().lock();
    }

    private void unlockRead() {
        this.readWriteLock.readLock().unlock();
    }

    private void lockWrite() {
        this.readWriteLock.writeLock().lock();
    }

    private void unlockWrite() {
        this.readWriteLock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token findByRandomHash(String randomHash) throws DataAccessException, ObjectNotFoundException {
        try {
            this.lockRead();
            Token token = this.implementation.findByRandomHash(randomHash);
            return token;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token findByIdentifierHash(String identifierHash) throws ObjectNotFoundException {
        try {
            this.lockRead();
            Token token = this.implementation.findByIdentifierHash(identifierHash);
            return token;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token add(Token token) throws DataAccessException {
        try {
            this.lockRead();
            Token token2 = this.implementation.add(token);
            return token2;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token update(Token token) throws ObjectNotFoundException {
        try {
            this.lockRead();
            Token token2 = this.implementation.update(token);
            return token2;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Token token) throws DataAccessException {
        try {
            this.lockRead();
            this.implementation.remove(token);
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Token> search(EntityQuery query) {
        try {
            this.lockRead();
            List list = this.implementation.search(query);
            return list;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token findByID(long ID) throws DataAccessException, ObjectNotFoundException {
        try {
            this.lockRead();
            Token token = this.implementation.findByID(ID);
            return token;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(long directoryID, String name) throws DataAccessException {
        try {
            this.lockRead();
            this.implementation.remove(directoryID, name);
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(long directoryId) {
        try {
            this.lockRead();
            this.implementation.removeAll(directoryId);
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAccessedBefore(Date expiryTime) {
        try {
            this.lockRead();
            this.implementation.removeAccessedBefore(expiryTime);
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        try {
            this.lockRead();
            this.daoMemory.removeAll();
            this.daoHibernate.removeAll();
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getPersistentClass() {
        try {
            this.lockRead();
            Class clazz = this.implementation.getPersistentClass();
            return clazz;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Object persistentObject) throws DataAccessException {
        try {
            this.lockRead();
            this.implementation.save(persistentObject);
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Object persistentObject) throws DataAccessException {
        try {
            this.lockRead();
            this.implementation.update(persistentObject);
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object persistentObject) throws DataAccessException {
        try {
            this.lockRead();
            this.implementation.update(persistentObject);
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(long ID) throws ObjectNotFoundException {
        try {
            this.lockRead();
            Object object = this.implementation.load(ID);
            return object;
        }
        finally {
            this.unlockRead();
        }
    }

    public boolean isUsingHibernateDAO() {
        return this.implementation == this.daoHibernate;
    }

    public void setUsingDatabaseStorage(boolean useDatabaseStorage) throws PropertyManagerException {
        this.propertyManager.setUsingDatabaseTokenStorage(useDatabaseStorage);
        if (useDatabaseStorage) {
            if (!this.isUsingHibernateDAO()) {
                this.switchToHibernate();
            }
        } else if (this.isUsingHibernateDAO()) {
            this.switchToMemory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void switchToMemory() {
        logger.info((Object)"About to switch to in-memory token storage");
        try {
            this.lockWrite();
            if (this.implementation != this.daoHibernate) {
                throw new IllegalStateException("Cannot switch; already in memory caching mode");
            }
            this.move(this.daoMemory, this.daoHibernate);
            this.implementation = this.daoMemory;
        }
        finally {
            this.unlockWrite();
        }
        logger.info((Object)"Finished switch to in-memory token storage");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void switchToHibernate() {
        try {
            logger.info((Object)"About to switch to database token storage");
            this.lockWrite();
            if (this.implementation != this.daoMemory) {
                throw new IllegalStateException("Cannot switch; already in database caching mode");
            }
            this.move(this.daoHibernate, this.daoMemory);
            this.implementation = this.daoHibernate;
        }
        finally {
            this.unlockWrite();
        }
        logger.info((Object)"Finished switch to database token storage");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void move(TokenDAOPersistence to, TokenDAOPersistence from) {
        try {
            this.lockWrite();
            Collection tokens = from.loadAll();
            if (tokens != null) {
                to.saveAll(tokens);
                from.removeAll();
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationStartedEvent || event instanceof XMLRestoreFinishedEvent) {
            try {
                this.setUsingDatabaseStorage(this.propertyManager.isUsingDatabaseTokenStorage());
            }
            catch (PropertyManagerException e) {
                logger.error((Object)"Failed to set token storage on application startup", (Throwable)e);
            }
        }
    }
}

