/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.membership;

import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.model.group.InternalGroup;
import com.atlassian.crowd.integration.model.membership.InternalMembership;
import com.atlassian.crowd.integration.model.membership.MembershipType;
import com.atlassian.crowd.integration.model.user.InternalUser;
import com.atlassian.crowd.model.group.GroupDAOHibernate;
import com.atlassian.crowd.model.membership.MembershipDAO;
import com.atlassian.crowd.model.principal.UserDAOHibernate;
import com.atlassian.crowd.search.hibernate.HQLQuery;
import com.atlassian.crowd.search.hibernate.HQLQueryTranslater;
import com.atlassian.crowd.search.hibernate.HibernateSearchResultsTransformer;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchResult;
import java.sql.SQLException;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.springframework.orm.hibernate3.HibernateCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MembershipDAOHibernate
extends HibernateDao
implements MembershipDAO {
    private UserDAOHibernate userDAO;
    private GroupDAOHibernate groupDAO;
    private HQLQueryTranslater hqlQueryTranslater;

    @Override
    public Class getPersistentClass() {
        return InternalMembership.class;
    }

    public boolean isUserDirectMember(long directoryId, String username, String groupName) {
        try {
            this.findInternalMembership(directoryId, username, groupName, MembershipType.GROUP_USER);
            return true;
        }
        catch (ObjectNotFoundException e) {
            return false;
        }
    }

    public boolean isGroupDirectMember(long directoryId, String childGroup, String parentGroup) {
        try {
            this.findInternalMembership(directoryId, childGroup, parentGroup, MembershipType.GROUP_GROUP);
            return true;
        }
        catch (ObjectNotFoundException e) {
            return false;
        }
    }

    public void addUserToGroup(long directoryId, String username, String groupName) throws ObjectNotFoundException {
        InternalUser internalUser = this.findUser(directoryId, username);
        InternalGroup internalGroup = this.findGroup(directoryId, groupName);
        super.save(new InternalMembership(internalGroup, internalUser));
    }

    public void removeUserFromGroup(long directoryId, String username, String groupName) throws ObjectNotFoundException {
        InternalMembership internalMembership = this.findInternalMembership(directoryId, username, groupName, MembershipType.GROUP_USER);
        super.remove(internalMembership);
    }

    public void addGroupToGroup(long directoryId, String childGroup, String parentGroup) throws ObjectNotFoundException {
        InternalGroup internalChildGroup = this.findGroup(directoryId, childGroup);
        InternalGroup internalParentGroup = this.findGroup(directoryId, parentGroup);
        super.save(new InternalMembership(internalParentGroup, internalChildGroup));
    }

    public void removeGroupFromGroup(long directoryId, String childGroup, String parentGroup) throws ObjectNotFoundException {
        InternalMembership internalMembership = this.findInternalMembership(directoryId, childGroup, parentGroup, MembershipType.GROUP_GROUP);
        super.remove(internalMembership);
    }

    public void removeGroupMembers(final long directoryId, final String groupName) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("removeAllEntityMembers").setString("entityName", groupName.toLowerCase()).setLong("directoryId", directoryId).executeUpdate();
            }
        });
    }

    public void removeGroupMemberships(final long directoryId, final String groupName) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("removeAllEntityMemberships").setString("entityName", groupName.toLowerCase()).setLong("directoryId", directoryId).setParameter("membershipType", (Object)MembershipType.GROUP_GROUP).executeUpdate();
            }
        });
    }

    public void removeUserMemberships(final long directoryId, final String username) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("removeAllEntityMemberships").setString("entityName", username.toLowerCase()).setLong("directoryId", directoryId).setParameter("membershipType", (Object)MembershipType.GROUP_USER).executeUpdate();
            }
        });
    }

    public void removeAllRelationships(final long directoryId) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("removeAllRelationships").setLong("directoryId", directoryId).executeUpdate();
            }
        });
    }

    public void removeAllUserRelationships(final long directoryId) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("removeAllRelationshipsOfType").setLong("directoryId", directoryId).setParameter("membershipType", (Object)MembershipType.GROUP_USER).executeUpdate();
            }
        });
    }

    public List search(final long directoryId, final MembershipQuery query) {
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                HQLQuery hqlQuery = MembershipDAOHibernate.this.hqlQueryTranslater.asHQL(directoryId, query);
                Query hibernateQuery = session.createQuery(hqlQuery.toString()).setFirstResult(query.getStartIndex());
                if (query.getMaxResults() != -1) {
                    hibernateQuery.setMaxResults(query.getMaxResults());
                }
                ListIterator<Object> iterator = hqlQuery.getParameterValues().listIterator();
                while (iterator.hasNext()) {
                    Object value = iterator.next();
                    hibernateQuery.setParameter(iterator.previousIndex(), value);
                }
                return HibernateSearchResultsTransformer.transformResults(hibernateQuery.list());
            }
        });
    }

    private InternalMembership findInternalMembership(final long directoryId, final String childName, final String parentName, final MembershipType type) throws ObjectNotFoundException {
        InternalMembership internalMembership = (InternalMembership)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createCriteria(MembershipDAOHibernate.this.getPersistentClass()).add((Criterion)Expression.eq((String)"directory.id", (Object)directoryId)).add((Criterion)Expression.eq((String)"lowerParentName", (Object)parentName.toLowerCase())).add((Criterion)Expression.eq((String)"lowerChildName", (Object)childName.toLowerCase())).add((Criterion)Expression.eq((String)"membershipType", (Object)type)).uniqueResult();
            }
        });
        if (internalMembership == null) {
            throw new ObjectNotFoundException(InternalMembership.class, (Object)("InternalMembership: directoryid<" + directoryId + ">, childName<" + childName + ">, parentName<" + parentName + ">, membershipType<" + type + ">"));
        }
        return internalMembership;
    }

    public void renameUserRelationships(final long directoryId, final String oldName, final String newName) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("renameChild").setLong("directoryId", directoryId).setString("oldName", oldName.toLowerCase()).setString("newName", newName).setString("lowerNewName", newName.toLowerCase()).setParameter("membershipType", (Object)MembershipType.GROUP_USER).executeUpdate();
            }
        });
    }

    public void renameGroupRelationships(final long directoryId, final String oldName, final String newName) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                session.getNamedQuery("renameChild").setLong("directoryId", directoryId).setString("oldName", oldName.toLowerCase()).setString("newName", newName).setString("lowerNewName", newName.toLowerCase()).setParameter("membershipType", (Object)MembershipType.GROUP_GROUP).executeUpdate();
                session.getNamedQuery("renameParent").setLong("directoryId", directoryId).setString("oldName", oldName.toLowerCase()).setString("newName", newName).setString("lowerNewName", newName.toLowerCase()).setParameter("membershipType", (Object)MembershipType.GROUP_GROUP).executeUpdate();
                return session.getNamedQuery("renameParent").setLong("directoryId", directoryId).setString("oldName", oldName.toLowerCase()).setString("newName", newName).setString("lowerNewName", newName.toLowerCase()).setParameter("membershipType", (Object)MembershipType.GROUP_USER).executeUpdate();
            }
        });
    }

    public List<InternalMembership> findAll() {
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createCriteria(MembershipDAOHibernate.this.getPersistentClass()).list();
            }
        });
    }

    public BatchResult<InternalMembership> addAll(Set<InternalMembership> memberships) {
        return this.batchProcessor.merge(memberships);
    }

    private InternalGroup findGroup(long directoryId, String groupName) throws ObjectNotFoundException {
        return this.groupDAO.findByName(directoryId, groupName);
    }

    private InternalUser findUser(long directoryId, String username) throws ObjectNotFoundException {
        return this.userDAO.findByName(directoryId, username);
    }

    public void setUserDAO(UserDAOHibernate userDAO) {
        this.userDAO = userDAO;
    }

    public void setGroupDAO(GroupDAOHibernate groupDAO) {
        this.groupDAO = groupDAO;
    }

    public void setHqlQueryTranslater(HQLQueryTranslater hqlQueryTranslater) {
        this.hqlQueryTranslater = hqlQueryTranslater;
    }
}

