/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.directory;

import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.model.directory.DirectoryDAO;
import com.atlassian.crowd.model.group.GroupDAO;
import com.atlassian.crowd.model.principal.UserDAO;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.hibernate.HQLQuery;
import com.atlassian.crowd.search.hibernate.HQLQueryTranslater;
import com.atlassian.crowd.search.hibernate.HibernateSearchResultsTransformer;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import java.sql.SQLException;
import java.util.List;
import java.util.ListIterator;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.HibernateCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryDAOHibernate
extends HibernateDao
implements DirectoryDAO {
    private UserDAO userDAO;
    private GroupDAO groupDAO;
    private HQLQueryTranslater hqlQueryTranslater;

    @Override
    public Class getPersistentClass() {
        return Directory.class;
    }

    public Directory findById(long id) throws ObjectNotFoundException {
        return (Directory)this.load(id);
    }

    public Directory findByName(final String name) throws ObjectNotFoundException {
        Object result = this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createCriteria(DirectoryDAOHibernate.this.getPersistentClass()).add((Criterion)Restrictions.eq((String)"lowerName", (Object)name.toLowerCase())).uniqueResult();
            }
        });
        if (result == null) {
            throw new ObjectNotFoundException(this.getPersistentClass(), (Object)name);
        }
        return (Directory)result;
    }

    public Directory add(Directory directory) {
        directory.setCreatedDateToNow();
        directory.setUpdatedDateToNow();
        directory.validate();
        super.save(directory);
        return directory;
    }

    public Directory update(Directory directory) {
        directory.setUpdatedDateToNow();
        directory.validate();
        super.update(directory);
        return directory;
    }

    public void remove(Directory directory) {
        this.groupDAO.removeAll(directory.getId().longValue());
        this.userDAO.removeAll(directory.getId().longValue());
        super.remove(directory);
    }

    public List<Directory> search(final EntityQuery query) {
        if (query.getEntityDescriptor().getEntityType() != Entity.DIRECTORY) {
            throw new IllegalArgumentException("DirectoryDAO can only evaluate EntityQueries for Entity.DIRECTORY");
        }
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                HQLQuery hqlQuery = DirectoryDAOHibernate.this.hqlQueryTranslater.asHQL(query);
                Query hibernateQuery = session.createQuery(hqlQuery.toString()).setFirstResult(query.getStartIndex());
                if (query.getMaxResults() != -1) {
                    hibernateQuery.setMaxResults(query.getMaxResults());
                }
                ListIterator<Object> iterator = hqlQuery.getParameterValues().listIterator();
                while (iterator.hasNext()) {
                    Object value = iterator.next();
                    hibernateQuery.setParameter(iterator.previousIndex(), value);
                }
                return HibernateSearchResultsTransformer.transformResults(hibernateQuery.list());
            }
        });
    }

    public void setUserDAO(UserDAO userDAO) {
        this.userDAO = userDAO;
    }

    public void setGroupDAO(GroupDAO groupDAO) {
        this.groupDAO = groupDAO;
    }

    public void setHqlQueryTranslater(HQLQueryTranslater hqlQueryTranslater) {
        this.hqlQueryTranslater = hqlQueryTranslater;
    }
}

