/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager;

import com.atlassian.crowd.authentication.TokenFactory;
import com.atlassian.crowd.integration.authentication.ApplicationAuthenticationContext;
import com.atlassian.crowd.integration.authentication.AuthenticationContext;
import com.atlassian.crowd.integration.authentication.ValidationFactor;
import com.atlassian.crowd.integration.exception.DirectoryAccessException;
import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.manager.cache.CacheManager;
import com.atlassian.crowd.manager.cache.NotInCacheException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.GroupMapping;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.model.token.TokenDAO;
import com.atlassian.crowd.util.I18nHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.springframework.util.Assert;

public abstract class GenericManager {
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected TokenDAO tokenDAO;
    protected PropertyManager propertyManager;
    protected I18nHelper i18nHelper;
    protected CacheManager cacheManager;
    protected TokenFactory tokenFactory;
    protected DirectoryManager directoryManager;

    protected Token generateUserToken(long directoryID, AuthenticationContext authenticationContext) throws InvalidTokenException {
        ValidationFactor[] factors;
        Assert.notNull((Object)authenticationContext);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("generateUserToken: user " + authenticationContext.getName()));
        }
        if ((factors = authenticationContext.getValidationFactors()) == null) {
            factors = new ValidationFactor[]{};
        }
        Token token = this.tokenFactory.create(directoryID, authenticationContext.getName(), new ArrayList<ValidationFactor>(Arrays.asList(factors)));
        try {
            Token existingToken = this.tokenDAO.findByIdentifierHash(token.getIdentifierHash());
            if (this.isExpired(existingToken)) {
                this.logger.debug((Object)"Token exists matching identifierHash, but is expired, so need to create a new token");
                this.tokenDAO.remove(existingToken);
                throw new ObjectNotFoundException(Token.class, (Object)token.getIdentifierHash());
            }
            token = this.tokenDAO.update(existingToken);
            this.logger.debug((Object)"Returning existing token that matched identifierHash");
        }
        catch (ObjectNotFoundException e) {
            this.tokenDAO.add(token);
            this.logger.debug((Object)"Returning newly created token");
        }
        return token;
    }

    protected Token generateApplicationToken(ApplicationAuthenticationContext authenticationContext) throws InvalidTokenException {
        return this.generateUserToken(-1L, (AuthenticationContext)authenticationContext);
    }

    protected Token genericValidateToken(String token, ValidationFactor[] validationFactors) throws InvalidTokenException {
        Assert.notNull((Object)token, (String)"A token key cannot be null");
        Assert.notNull((Object)validationFactors, (String)"The array of ValidationFactors cannot be null");
        this.logger.debug((Object)"genericValidateToken");
        try {
            Token existingToken = this.tokenDAO.findByRandomHash(token);
            Token validationToken = this.tokenFactory.create(existingToken.getDirectoryId(), existingToken.getName(), new ArrayList<ValidationFactor>(Arrays.asList(validationFactors)), existingToken.getRandomNumber());
            if (this.logger.isDebugEnabled()) {
                StringBuffer message = new StringBuffer("Current Validation Factors: \n");
                for (int i = 0; i < validationFactors.length; ++i) {
                    ValidationFactor validationFactor = validationFactors[i];
                    message.append(validationFactor);
                }
                this.logger.debug((Object)message.toString());
                this.logger.debug((Object)("comparing existing token " + existingToken + " with a validation token " + validationToken));
            }
            if (!existingToken.getRandomHash().equals(validationToken.getRandomHash())) {
                this.logger.debug((Object)"The token keys don't match");
                throw new InvalidTokenException("Token doesn't match the existing token.");
            }
            this.logger.debug((Object)"they match");
            if (this.isExpired(existingToken)) {
                this.logger.debug((Object)"token has expired. removing from db");
                this.tokenDAO.remove(existingToken);
                throw new InvalidTokenException("Token has expired.");
            }
            this.logger.debug((Object)"returning validated token, with updated last accessed time");
            return this.tokenDAO.update(existingToken);
        }
        catch (ObjectNotFoundException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("The token " + token + " was not found in db"));
            }
            throw new InvalidTokenException("Token does not validate.");
        }
    }

    protected boolean isExpired(Token token) {
        long now = System.currentTimeMillis();
        long timeSpread = now - token.getLastAccessedDate().getTime();
        long allowedElapse = 60000L * this.propertyManager.getSessionTime();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"checking if the token is expired:");
            this.logger.debug((Object)("\tnow: \t\t\t" + now));
            this.logger.debug((Object)("\tlast accessed: \t" + token.getLastAccessedDate()));
            this.logger.debug((Object)("\tdifference: \t" + timeSpread));
            this.logger.debug((Object)("\tallowed elapse: " + allowedElapse));
        }
        return timeSpread > allowedElapse;
    }

    public boolean isAllowedToAuthenticate(String username, long directoryId, Application application) throws DirectoryAccessException {
        if (!application.isActive()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("User does not have access to application '" + application.getName() + "' as the application is inactive"));
            }
            return false;
        }
        DirectoryMapping directoryMapping = application.getDirectoryMapping(directoryId);
        if (directoryMapping != null) {
            if (directoryMapping.isAllowAllToAuthenticate()) {
                return true;
            }
            for (GroupMapping groupMapping : directoryMapping.getAuthorisedGroups()) {
                try {
                    if (!this.directoryManager.isUserNestedGroupMember(directoryId, username, groupMapping.getGroupName())) continue;
                    return true;
                }
                catch (ObjectNotFoundException e) {
                }
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("User does not have access to application '" + application.getName() + "' as the directory is not allow all to authenticate and the user is not a member of any of the authorised groups"));
        }
        return false;
    }

    public boolean isAllowedToAuthenticate(Token token, Application application, boolean ignoreCache) throws DirectoryAccessException {
        if (ignoreCache || !this.propertyManager.isCacheEnabled()) {
            return this.isAllowedToAuthenticate(token.getName(), token.getDirectoryId(), application);
        }
        try {
            Boolean hasAccess = (Boolean)this.cacheManager.get(application.getName() + token.getRandomHash());
            if (hasAccess.booleanValue()) {
                return true;
            }
        }
        catch (NotInCacheException e) {
            // empty catch block
        }
        boolean hasAccess = this.isAllowedToAuthenticate(token.getName(), token.getDirectoryId(), application);
        this.cacheManager.put(application.getName() + token.getRandomHash(), (Serializable)Boolean.valueOf(hasAccess));
        return hasAccess;
    }

    public boolean isAllowedToAuthenticate(Token token, Application application) throws DirectoryAccessException {
        return this.isAllowedToAuthenticate(token, application, false);
    }

    public void setI18nHelper(I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
    }

    public void setTokenDAO(TokenDAO tokenDAO) {
        this.tokenDAO = tokenDAO;
    }

    public void setPropertyManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setTokenFactory(TokenFactory tokenFactory) {
        this.tokenFactory = tokenFactory;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }
}

