/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.directory.monitor.listener;

import com.atlassian.crowd.integration.directory.connector.ApacheDS15;
import com.atlassian.crowd.integration.directory.connector.LDAPPropertiesMapper;
import com.atlassian.crowd.integration.directory.monitor.listener.DirectoryListener;
import com.atlassian.crowd.integration.directory.monitor.listener.GroupChangeListener;
import com.atlassian.crowd.integration.directory.monitor.listener.UserChangeListener;
import com.atlassian.crowd.integration.model.group.GroupType;
import com.atlassian.crowd.manager.directory.monitor.DirectoryMonitorRegistrationException;
import com.atlassian.crowd.manager.directory.monitor.DirectoryMonitorUnregistrationException;
import com.atlassian.event.EventManager;
import org.apache.log4j.Logger;

public class ApacheDSPersistentSearchListener
implements DirectoryListener {
    private final Logger logger = Logger.getLogger(ApacheDSPersistentSearchListener.class);
    private final ApacheDS15 remoteDirectory;
    private final EventManager eventManager;
    private final LDAPPropertiesMapper ldapPropertiesMapper;
    private final UserChangeListener userChangeListener;
    private final GroupChangeListener groupChangeListener;

    public ApacheDSPersistentSearchListener(ApacheDS15 remoteDirectory, EventManager eventManager) {
        this.remoteDirectory = remoteDirectory;
        this.eventManager = eventManager;
        this.ldapPropertiesMapper = remoteDirectory.getLdapPropertiesMapper();
        this.userChangeListener = new UserChangeListener(remoteDirectory, remoteDirectory.getSearchDN().getUser(), this.ldapPropertiesMapper.getUserFilter(), remoteDirectory.getUserContextMapper(), eventManager, true);
        this.groupChangeListener = new GroupChangeListener(remoteDirectory, remoteDirectory.getSearchDN().getGroup(), this.ldapPropertiesMapper.getGroupFilter(), remoteDirectory.getGroupContextMapper(GroupType.GROUP), eventManager, true);
    }

    public long getDirectoryID() {
        return this.remoteDirectory.getDirectoryId();
    }

    public void startListening() throws DirectoryMonitorRegistrationException {
        try {
            this.remoteDirectory.addChangeListener(this.userChangeListener);
            this.remoteDirectory.addChangeListener(this.groupChangeListener);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            try {
                this.stopListening();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new DirectoryMonitorRegistrationException((Throwable)e);
        }
    }

    public void stopListening() throws DirectoryMonitorUnregistrationException {
        Exception error = null;
        try {
            this.remoteDirectory.removeChangeListener(this.userChangeListener);
        }
        catch (Exception e) {
            error = e;
            this.logger.warn((Object)("Unable to remove UserChangeListener for directory with ID: " + this.getDirectoryID()));
        }
        try {
            this.remoteDirectory.removeChangeListener(this.groupChangeListener);
        }
        catch (Exception e) {
            error = e;
            this.logger.warn((Object)("Unable to remove GroupChangeListener for directory with ID: " + this.getDirectoryID()));
        }
        if (error != null) {
            throw new DirectoryMonitorUnregistrationException((Throwable)error);
        }
    }
}

